/*
 * Decompiled with CFR 0.152.
 */
package org.silvercatcher.reforged;

import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.silvercatcher.reforged.ReforgedRegistry;
import org.silvercatcher.reforged.api.IZombieEquippable;

public class ReforgedMonsterArmourer {
    private static final UUID itemModifierUUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    private static Item[] zombieWeapons;
    private Random random = new Random();

    private void equipZombie(EntityZombie zombie) {
        if ((zombie.func_184582_a(EntityEquipmentSlot.MAINHAND) == null || zombie.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b()) && this.random.nextInt(10) == 0) {
            Item item = this.randomFrom(zombieWeapons);
            zombie.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(item));
            zombie.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(new AttributeModifier(itemModifierUUID, "Weapon Damage", 99.0, 0));
        }
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinWorldEvent event) {
        if (event.isCanceled() || event.getEntity() == null || event.getWorld().field_72995_K || !(event.getEntity() instanceof EntityZombie) || zombieWeapons == null) {
            return;
        }
        this.equipZombie((EntityZombie)event.getEntity());
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load e) {
        if (e.isCanceled() || e.getWorld().field_72995_K) {
            return;
        }
        ArrayList<Item> list = new ArrayList<Item>();
        for (Item i : ReforgedRegistry.registrationList) {
            if (!(i instanceof IZombieEquippable)) continue;
            int c = 0;
            while ((float)c < ((IZombieEquippable)i).zombieSpawnChance()) {
                list.add(i);
                ++c;
            }
        }
        zombieWeapons = list.isEmpty() ? null : list.toArray(new Item[list.size()]);
    }

    private Item randomFrom(Item[] selection) {
        return selection[this.random.nextInt(selection.length)];
    }
}

