/*
 * Decompiled with CFR 0.152.
 */
package net.slayer5934.chococraft.client.gui;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.slayer5934.chococraft.common.ChocoConfig;
import net.slayer5934.chococraft.common.entities.EntityChocobo;
import net.slayer5934.chococraft.common.entities.properties.ChocoboAttributes;
import net.slayer5934.chococraft.common.handler.ExperienceHandler;
import net.slayer5934.chococraft.common.network.PacketManager;
import net.slayer5934.chococraft.common.network.packets.PacketUpgradeChocobo;

public class GuiChocoboInfo
extends GuiScreen {
    public static final ResourceLocation TEXTURE = new ResourceLocation("chococraft", "textures/gui/chocobo_stats.png");
    private final EntityChocobo chocobo;
    private final EntityPlayer player;
    private int xSize = 176;
    private int ySize = 89;
    private int guiLeft;
    private int guiTop;

    public GuiChocoboInfo(EntityChocobo chocobo, EntityPlayer player) {
        this.chocobo = chocobo;
        this.player = player;
    }

    public void func_73866_w_() {
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.field_146292_n.add(new GuiButton(1, this.guiLeft + 180, this.guiTop + 1, 80, 20, I18n.func_135052_a((String)"gui.chocoinfo.button.sprint", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(2, this.guiLeft + 180, this.guiTop + 23, 80, 20, I18n.func_135052_a((String)"gui.chocoinfo.button.glide", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(3, this.guiLeft + 180, this.guiTop + 45, 80, 20, I18n.func_135052_a((String)"gui.chocoinfo.button.dive", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(4, this.guiLeft + 180, this.guiTop + 67, 80, 20, I18n.func_135052_a((String)"gui.chocoinfo.button.fly", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(0, this.guiLeft + 180, this.guiTop + 80, 0, 0, ""));
    }

    protected void func_146284_a(GuiButton b) {
        switch (b.field_146127_k) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                PacketUpgradeChocobo packet = new PacketUpgradeChocobo(this.chocobo, b.field_146127_k);
                PacketManager.INSTANCE.sendToServer((IMessage)packet);
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        this.func_73729_b(0, 0, 0, 0, this.xSize, this.ySize);
        String name = this.chocobo.func_145748_c_().func_150260_c();
        int nameLength = this.field_146289_q.func_78256_a(name);
        this.field_146289_q.func_175063_a(name, (float)(this.xSize / 2 - nameLength / 2), 4.0f, -1);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.drawGenderInfo();
        this.drawHealthInfo();
        this.drawSpeedInfo();
        this.drawStaminaInfo();
        this.drawAbilityInfo();
        this.interceptButtons();
        GlStateManager.func_179121_F();
    }

    private void interceptButtons() {
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            if (this.field_146292_n.get(i) == null) continue;
            GuiButton btn = (GuiButton)this.field_146292_n.get(i);
            if (i == 0 && (ChocoConfig.chocobo.ExpCostSprint > ExperienceHandler.getExperience(this.player) || this.chocobo.canSprint())) {
                btn.field_146124_l = false;
            }
            if (i == 1 && (ChocoConfig.chocobo.ExpCostGlide > ExperienceHandler.getExperience(this.player) || this.chocobo.canGlide())) {
                btn.field_146124_l = false;
            }
            if (i == 2 && (ChocoConfig.chocobo.ExpCostDive > ExperienceHandler.getExperience(this.player) || this.chocobo.canDive())) {
                btn.field_146124_l = false;
            }
            if (i == 3 && (ChocoConfig.chocobo.ExpCostFly > ExperienceHandler.getExperience(this.player) || this.chocobo.canFly())) {
                btn.field_146124_l = false;
            }
            if (!btn.func_146115_a() || this.canUseAbility(i)) continue;
            String tooltip = I18n.func_135052_a((String)"gui.chocoinfo.button.ability", (Object[])new Object[]{ExperienceHandler.getExperience(this.player), this.getAbilityXPCost(i), I18n.func_135052_a((String)this.getAbilityFromButton(i), (Object[])new Object[0])});
            int width = this.field_146289_q.func_78256_a(tooltip);
            this.field_146289_q.func_175065_a(tooltip, (float)(88 - width / 2), 93.0f, -1, true);
        }
    }

    private void drawGenderInfo() {
        this.func_73729_b(26, 18, 176, this.chocobo.isMale() ? 16 : 0, 16, 16);
    }

    private void drawHealthInfo() {
        String value = String.valueOf((int)this.chocobo.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b());
        int width = this.field_146289_q.func_78256_a(value);
        this.field_146289_q.func_175063_a(value, (float)(70 - width / 2), 36.0f, -1);
    }

    private void drawSpeedInfo() {
        String value = String.valueOf((int)Math.round(this.chocobo.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() * 100.0));
        int width = this.field_146289_q.func_78256_a(value);
        this.field_146289_q.func_175063_a(value, (float)(106 - width / 2), 36.0f, -1);
    }

    private void drawStaminaInfo() {
        String value = String.valueOf((int)this.chocobo.func_110148_a(ChocoboAttributes.MAX_STAMINA).func_111125_b());
        int width = this.field_146289_q.func_78256_a(value);
        this.field_146289_q.func_175063_a(value, (float)(142 - width / 2), 36.0f, -1);
    }

    private void drawAbilityInfo() {
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        if (!this.chocobo.canSprint()) {
            this.func_73729_b(26, 54, 176, 32, 16, 16);
        }
        if (!this.chocobo.canGlide()) {
            this.func_73729_b(62, 54, 176, 32, 16, 16);
        }
        if (!this.chocobo.canDive()) {
            this.func_73729_b(98, 54, 176, 32, 16, 16);
        }
        if (!this.chocobo.canFly()) {
            this.func_73729_b(134, 54, 176, 32, 16, 16);
        }
    }

    private boolean canUseAbility(int i) {
        switch (i) {
            case 0: {
                return this.chocobo.canSprint();
            }
            case 1: {
                return this.chocobo.canGlide();
            }
            case 2: {
                return this.chocobo.canDive();
            }
            case 3: {
                return this.chocobo.canFly();
            }
        }
        return false;
    }

    private String getAbilityFromButton(int i) {
        String key = "gui.chocoinfo.button.";
        switch (i) {
            case 0: {
                return key + "sprint";
            }
            case 1: {
                return key + "glide";
            }
            case 2: {
                return key + "dive";
            }
            case 3: {
                return key + "fly";
            }
        }
        return key + "";
    }

    private int getAbilityXPCost(int i) {
        switch (i) {
            case 0: {
                return ChocoConfig.chocobo.ExpCostSprint;
            }
            case 1: {
                return ChocoConfig.chocobo.ExpCostGlide;
            }
            case 2: {
                return ChocoConfig.chocobo.ExpCostDive;
            }
            case 3: {
                return ChocoConfig.chocobo.ExpCostFly;
            }
        }
        return 0;
    }
}

