/*
 * Decompiled with CFR 0.152.
 */
package net.slayer5934.chococraft.common.entities.breeding;

import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.world.World;
import net.slayer5934.chococraft.common.ChocoConfig;
import net.slayer5934.chococraft.common.entities.EntityChocobo;
import net.slayer5934.chococraft.common.entities.breeding.ChocoboBreedInfo;
import net.slayer5934.chococraft.common.entities.breeding.ChocoboStatSnapshot;
import net.slayer5934.chococraft.common.entities.properties.ChocoboAttributes;
import net.slayer5934.chococraft.common.entities.properties.ChocoboColor;

public class BreedingHelper {
    public static ChocoboBreedInfo getBreedInfo(EntityChocobo mother, EntityChocobo father) {
        return new ChocoboBreedInfo(new ChocoboStatSnapshot(mother), new ChocoboStatSnapshot(father));
    }

    public static EntityChocobo createChild(ChocoboBreedInfo breedInfo, World world) {
        EntityChocobo chocobo = new EntityChocobo(world);
        ChocoboStatSnapshot mother = breedInfo.getMother();
        ChocoboStatSnapshot father = breedInfo.getFather();
        chocobo.setLevel(1);
        chocobo.setGeneration((mother.generation + father.generation) / 2 + 1);
        float health = Math.round((mother.health + father.health) / 2.0f * (ChocoConfig.breeding.poslossHealth + (float)Math.random() * ChocoConfig.breeding.posgainHealth));
        chocobo.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)Math.min(health, (float)ChocoConfig.breeding.maxHealth));
        float speed = (mother.speed + father.speed) / 2.0f * (ChocoConfig.breeding.poslossSpeed + (float)Math.random() * ChocoConfig.breeding.posgainSpeed);
        chocobo.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)Math.min(speed, (float)ChocoConfig.breeding.maxSpeed / 100.0f));
        float stamina = (float)Math.round((mother.stamina + father.stamina) / 2.0f) * (ChocoConfig.breeding.poslossStamina + (float)Math.random() * ChocoConfig.breeding.posgainStamina);
        chocobo.func_110148_a(ChocoboAttributes.MAX_STAMINA).func_111128_a((double)Math.min(stamina, ChocoConfig.breeding.maxStamina));
        float canFlyChance = BreedingHelper.calculateChance(0.005f, 0.15f, 0.35f, mother.canFly, father.canFly);
        float canflychancerandom = (float)Math.random();
        chocobo.setCanFly(canFlyChance > canflychancerandom);
        float canDiveChance = BreedingHelper.calculateChance(0.01f, 0.2f, 0.4f, mother.canDive, father.canDive);
        float candivechancerandom = (float)Math.random();
        chocobo.setCanDive(canDiveChance > candivechancerandom);
        float canGlideChance = BreedingHelper.calculateChance(0.01f, 0.2f, 0.45f, mother.canGlide, father.canGlide);
        float canglidechancerandom = (float)Math.random();
        chocobo.setCanGlide(canGlideChance > canglidechancerandom);
        float canSprintChance = BreedingHelper.calculateChance(0.03f, 0.25f, 0.5f, mother.canSprint, father.canSprint);
        float cansprintchancerandom = (float)Math.random();
        chocobo.setCanSprint(canSprintChance > cansprintchancerandom);
        chocobo.setMale(0.5f > (float)Math.random());
        if (0.02f > (float)Math.random()) {
            chocobo.setChocoboColor(ChocoboColor.FLAME);
        } else if (canFlyChance > canflychancerandom) {
            chocobo.setChocoboColor(ChocoboColor.GOLD);
        } else if (canDiveChance > candivechancerandom) {
            chocobo.setChocoboColor(ChocoboColor.BLUE);
        } else if (canGlideChance > canglidechancerandom) {
            chocobo.setChocoboColor(ChocoboColor.WHITE);
        } else if (canSprintChance > cansprintchancerandom) {
            chocobo.setChocoboColor(ChocoboColor.GREEN);
        } else {
            chocobo.setChocoboColor(ChocoboColor.YELLOW);
        }
        chocobo.func_70873_a(-24000);
        return chocobo;
    }

    private static float calculateChance(float baseChance, float perParentChance, float bothParentsChance, boolean motherHasAbility, boolean fatherHasAbility) {
        return baseChance + (motherHasAbility || fatherHasAbility ? perParentChance : 0.0f) + (motherHasAbility && fatherHasAbility ? bothParentsChance : 0.0f);
    }
}

