/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.biomes;

import java.util.Random;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;
import net.minecraft.world.gen.feature.WorldGenMegaPineTree;
import net.minecraft.world.gen.feature.WorldGenTaiga1;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenTallGrass;
import net.minecraft.world.gen.feature.WorldGenerator;
import twilightforest.TFFeature;
import twilightforest.TwilightForestMod;
import twilightforest.biomes.TFBiomeBase;
import twilightforest.block.BlockTFPlant;
import twilightforest.block.TFBlocks;
import twilightforest.entity.EntityTFTroll;
import twilightforest.enums.PlantVariant;
import twilightforest.world.feature.TFGenTallGrass;
import twilightforest.world.feature.TFGenTrollRoots;

public class TFBiomeHighlands
extends TFBiomeBase {
    private final WorldGenAbstractTree taigaGen1 = new WorldGenTaiga1();
    private final WorldGenAbstractTree taigaGen2 = new WorldGenTaiga2(false);
    private final WorldGenAbstractTree megaPineGen1 = new WorldGenMegaPineTree(false, false);
    private final WorldGenAbstractTree megaPineGen2 = new WorldGenMegaPineTree(false, true);
    private final WorldGenerator genBoulder = new WorldGenBlockBlob(Blocks.field_150341_Y, 0);
    private final WorldGenerator genTrollRoots = new TFGenTrollRoots();
    private final WorldGenerator worldGenMushgloom = new TFGenTallGrass(TFBlocks.twilight_plant.func_176223_P().func_177226_a(BlockTFPlant.VARIANT, (Comparable)((Object)PlantVariant.MUSHGLOOM)));

    public TFBiomeHighlands(Biome.BiomeProperties props) {
        super(props);
        this.getTFBiomeDecorator().hasCanopy = false;
        this.field_76760_I.field_76803_B = 7;
        this.field_76760_I.field_76804_C = 1;
        this.field_76760_I.field_76808_K = false;
        this.undergroundMonsterList.clear();
        this.undergroundMonsterList.add(new Biome.SpawnListEntry(EntitySkeleton.class, 10, 4, 4));
        this.undergroundMonsterList.add(new Biome.SpawnListEntry(EntityCreeper.class, 1, 4, 4));
        this.undergroundMonsterList.add(new Biome.SpawnListEntry(EntitySlime.class, 10, 4, 4));
        this.undergroundMonsterList.add(new Biome.SpawnListEntry(EntityTFTroll.class, 10, 4, 4));
    }

    @Override
    public WorldGenAbstractTree func_150567_a(Random random) {
        if (random.nextInt(4) == 0) {
            return this.taigaGen1;
        }
        if (random.nextInt(10) == 0) {
            return this.taigaGen2;
        }
        if (random.nextInt(3) == 0) {
            return this.megaPineGen1;
        }
        if (random.nextInt(13) == 0) {
            return this.megaPineGen2;
        }
        return this.birchGen;
    }

    @Override
    public WorldGenerator func_76730_b(Random random) {
        return random.nextInt(5) > 0 ? new WorldGenTallGrass(BlockTallGrass.EnumType.FERN) : new WorldGenTallGrass(BlockTallGrass.EnumType.GRASS);
    }

    @Override
    public void func_180622_a(World world, Random rand, ChunkPrimer primer, int x, int z, double noiseVal) {
        this.field_76752_A = Blocks.field_150349_c.func_176223_P();
        this.field_76753_B = Blocks.field_150346_d.func_176223_P();
        if (noiseVal > 1.75) {
            this.field_76752_A = Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT);
        } else if (noiseVal > -0.95) {
            this.field_76752_A = Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL);
        }
        this.genTwilightBiomeTerrain(world, rand, primer, x, z, noiseVal);
    }

    public void func_180624_a(World world, Random rand, BlockPos pos) {
        int rx;
        int dy;
        int dz;
        int dx;
        int i;
        int maxBoulders = rand.nextInt(2);
        for (i = 0; i < maxBoulders; ++i) {
            dx = pos.func_177958_n() + rand.nextInt(16) + 8;
            dz = pos.func_177952_p() + rand.nextInt(16) + 8;
            dy = world.func_189649_b(dx, dz);
            this.genBoulder.func_180709_b(world, rand, new BlockPos(dx, dy, dz));
        }
        field_180280_ag.func_180710_a(BlockDoublePlant.EnumPlantType.FERN);
        for (i = 0; i < 7; ++i) {
            dx = pos.func_177958_n() + rand.nextInt(16) + 8;
            dz = pos.func_177952_p() + rand.nextInt(16) + 8;
            dy = rand.nextInt(world.func_189649_b(dx, dz) + 32);
            field_180280_ag.func_180709_b(world, rand, new BlockPos(dx, dy, dz));
        }
        for (i = 0; i < 1; ++i) {
            rx = pos.func_177958_n() + rand.nextInt(16) + 8;
            int rz = pos.func_177952_p() + rand.nextInt(16) + 8;
            int ry = rand.nextInt(64);
            this.worldGenMushgloom.func_180709_b(world, rand, new BlockPos(rx, ry, rz));
        }
        for (i = 0; i < 24; ++i) {
            rx = pos.func_177958_n() + rand.nextInt(16) + 8;
            int ry = 64;
            int rz = pos.func_177952_p() + rand.nextInt(16) + 8;
            this.genTrollRoots.func_180709_b(world, rand, new BlockPos(rx, ry, rz));
        }
        super.func_180624_a(world, rand, pos);
    }

    @Override
    protected ResourceLocation[] getRequiredAdvancements() {
        return new ResourceLocation[]{TwilightForestMod.prefix("progress_merge")};
    }

    @Override
    public void enforceProgression(EntityPlayer player, World world) {
        if (!world.field_72995_K && player.field_70173_aa % 5 == 0) {
            player.func_70097_a(DamageSource.field_76376_m, 0.5f);
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187541_bC, SoundCategory.PLAYERS, 1.0f, 1.0f);
            this.trySpawnHintMonster(player, world);
        }
    }

    @Override
    protected TFFeature getContainedFeature() {
        return TFFeature.TROLL_CAVE;
    }
}

