/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.random;

import ivorius.ivtoolkit.random.WeightedSelector;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.ToDoubleFunction;

public class WeightedShuffler {
    public static <T> Iterator<T> iterateShuffled(final Random rand, final List<T> items, final ToDoubleFunction<T> weightFunction) {
        return new Iterator<T>(){
            double totalWeight;
            {
                this.totalWeight = WeightedSelector.totalWeight(items, weightFunction);
            }

            @Override
            public boolean hasNext() {
                return items.size() > 0;
            }

            @Override
            public T next() {
                Object next = this.totalWeight > 1.0E-7 ? WeightedSelector.select(rand, items, weightFunction, this.totalWeight, true) : items.remove(rand.nextInt(items.size()));
                this.totalWeight -= weightFunction.applyAsDouble(next);
                return next;
            }
        };
    }

    public static <T> Iterator<T> iterateShuffled(Random rand, List<WeightedSelector.SimpleItem<T>> items) {
        final Iterator<WeightedSelector.SimpleItem> iterator2 = WeightedShuffler.iterateShuffled(rand, items, WeightedSelector.Item::getWeight);
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public T next() {
                return ((WeightedSelector.SimpleItem)iterator2.next()).getItem();
            }
        };
    }

    public static <T extends WeightedSelector.Item> Iterator<T> iterateShuffledItems(Random rand, List<T> items) {
        return WeightedShuffler.iterateShuffled(rand, items, WeightedSelector.Item::getWeight);
    }

    public static <T extends WeightedSelector.Item> void shuffleItems(Random rand, List<T> items) {
        WeightedShuffler.shuffleItems(rand, items, WeightedSelector.totalWeight(items));
    }

    public static <T extends WeightedSelector.Item> void shuffleItems(Random rand, List<T> items, double totalWeight) {
        int size = items.size();
        for (int shuffled = 0; shuffled < size - 1; ++shuffled) {
            List<T> subList = items.subList(shuffled, size);
            T selected = totalWeight > 0.0 ? WeightedSelector.selectItem(rand, subList, totalWeight, true) : (WeightedSelector.Item)subList.get(rand.nextInt(subList.size()));
            totalWeight -= selected.getWeight();
            subList.add(0, selected);
        }
    }

    public static <T> void shuffle(Random rand, List<T> items, ToDoubleFunction<T> weightFunction) {
        WeightedShuffler.shuffle(rand, items, weightFunction, WeightedSelector.totalWeight(items, weightFunction));
    }

    public static <T> void shuffle(Random rand, List<T> items, ToDoubleFunction<T> weightFunction, double totalWeight) {
        int size = items.size();
        for (int shuffled = 0; shuffled < size - 1; ++shuffled) {
            List<T> subList = items.subList(shuffled, size);
            T selected = totalWeight > 0.0 ? WeightedSelector.select(rand, subList, weightFunction, totalWeight, true) : subList.get(rand.nextInt(subList.size()));
            totalWeight -= weightFunction.applyAsDouble(selected);
            subList.add(0, selected);
        }
    }
}

