/*
 * Decompiled with CFR 0.152.
 */
package ivorius.reccomplex.utils.expression;

import com.google.common.primitives.Ints;
import ivorius.reccomplex.RecurrentComplex;
import ivorius.reccomplex.files.saving.FileSaver;
import ivorius.reccomplex.utils.algebra.BoolFunctionExpressionCache;
import ivorius.reccomplex.utils.algebra.FunctionExpressionCache;
import ivorius.reccomplex.utils.algebra.RCBoolAlgebra;
import ivorius.reccomplex.utils.algebra.SupplierCache;
import ivorius.reccomplex.utils.expression.BiomeExpression;
import ivorius.reccomplex.utils.expression.DelegatingVariableType;
import ivorius.reccomplex.utils.expression.DependencyExpression;
import ivorius.reccomplex.utils.expression.DimensionExpression;
import ivorius.reccomplex.utils.expression.GenerationTypeExpression;
import ivorius.reccomplex.world.gen.feature.structure.Environment;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;

public class EnvironmentExpression
extends BoolFunctionExpressionCache<Environment, Object> {
    public static final String BIOME_PREFIX = "biome.";
    public static final String DIMENSION_PREFIX = "dimension.";
    public static final String DEPENDENCY_PREFIX = "dependency.";
    public static final String VILLAGE_TYPE_PREFIX = "villagetype=";
    public static final String GENERATION_INFO_PREFIX = "generation.";
    public static final String VARIABLE_PREFIX = "variable.";

    public EnvironmentExpression() {
        super(RCBoolAlgebra.algebra(), true, TextFormatting.GREEN + "Always");
        this.addType(new BiomeVariableType(BIOME_PREFIX, ""));
        this.addTypes(new DimensionVariableType(DIMENSION_PREFIX, ""), t -> t.alias("dim.", ""));
        this.addTypes(new DependencyVariableType(DEPENDENCY_PREFIX, ""), t -> t.alias("dep.", ""));
        this.addTypes(new VillageTypeType(VILLAGE_TYPE_PREFIX, ""), t -> t.alias("vtype.", ""));
        this.addTypes(new GenerationType(GENERATION_INFO_PREFIX, ""), t -> t.alias("gen.", ""));
        this.addTypes(new VariableDomainType(VARIABLE_PREFIX, ""), t -> t.alias("var.", ""));
    }

    protected static class VariableDomainType
    extends FunctionExpressionCache.VariableType<Boolean, Environment, Object> {
        public VariableDomainType(String prefix, String suffix) {
            super(prefix, suffix);
        }

        @Override
        public Function<SupplierCache<Environment>, Boolean> parse(String var) {
            return environment -> ((Environment)environment.get()).variables.get(var);
        }

        @Override
        public FunctionExpressionCache.Validity validity(String var, Object args) {
            return FunctionExpressionCache.Validity.KNOWN;
        }
    }

    protected static class GenerationType
    extends DelegatingVariableType<Boolean, Environment, Object, ivorius.reccomplex.world.gen.feature.structure.generic.generation.GenerationType, Object, GenerationTypeExpression> {
        public GenerationType(String prefix, String suffix) {
            super(prefix, suffix);
        }

        @Override
        public ivorius.reccomplex.world.gen.feature.structure.generic.generation.GenerationType convertEvaluateArgument(String var, Environment environment) {
            return environment.generationType;
        }

        @Override
        public GenerationTypeExpression createCache() {
            return new GenerationTypeExpression();
        }
    }

    protected static class VillageTypeType
    extends FunctionExpressionCache.VariableType<Boolean, Environment, Object> {
        public VillageTypeType(String prefix, String suffix) {
            super(prefix, suffix);
        }

        @Override
        public Function<SupplierCache<Environment>, Boolean> parse(String var) {
            Integer villageType = this.parseVillageType(var);
            return environment -> Objects.equals(villageType, ((Environment)environment.get()).villageType);
        }

        public Integer parseVillageType(String var) {
            Integer integer = Ints.tryParse((String)var);
            return integer != null && integer >= 0 && integer < 4 ? integer : null;
        }

        @Override
        public FunctionExpressionCache.Validity validity(String var, Object args) {
            return this.parseVillageType(var) != null ? FunctionExpressionCache.Validity.KNOWN : FunctionExpressionCache.Validity.ERROR;
        }
    }

    public static class DependencyVariableType
    extends DelegatingVariableType<Boolean, Environment, Object, FileSaver, FileSaver, DependencyExpression> {
        public DependencyVariableType(String prefix, String suffix) {
            super(prefix, suffix);
        }

        @Override
        public FileSaver convertArgument(String var, Environment environment) {
            return RecurrentComplex.saver;
        }

        @Override
        public DependencyExpression createCache() {
            return new DependencyExpression();
        }
    }

    public static class DimensionVariableType
    extends DelegatingVariableType<Boolean, Environment, Object, WorldProvider, Object, DimensionExpression> {
        public DimensionVariableType(String prefix, String suffix) {
            super(prefix, suffix);
        }

        @Override
        public WorldProvider convertEvaluateArgument(String var, Environment argument) {
            return argument.world.field_73011_w;
        }

        @Override
        public DimensionExpression createCache() {
            return new DimensionExpression();
        }
    }

    public static class BiomeVariableType
    extends DelegatingVariableType<Boolean, Environment, Object, Biome, Object, BiomeExpression> {
        public BiomeVariableType(String prefix, String suffix) {
            super(prefix, suffix);
        }

        @Override
        public Biome convertEvaluateArgument(String var, Environment argument) {
            return argument.biome;
        }

        @Override
        public BiomeExpression createCache() {
            return new BiomeExpression();
        }
    }
}

