/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.recipe;

import com.creativemd.creativecore.common.recipe.Recipe;
import com.creativemd.creativecore.common.utils.stack.InfoStack;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class GridRecipe
extends Recipe {
    public int width;
    public int height;

    public GridRecipe(ItemStack[] output, int width, int height, Object ... input) {
        super(output, input);
        this.width = width;
        this.height = height;
    }

    public GridRecipe(ItemStack[] output, int width, int height, InfoStack ... input) {
        super(output, input);
        this.width = width;
        this.height = height;
    }

    public void consumeRecipe(IInventory inventory, int width, int heigt) {
        this.consumeRecipe(inventory, width, heigt, 1);
    }

    public void consumeRecipe(IInventory inventory, int width, int heigt, int amount) {
        ItemStack[] inv = this.getObjectInValidOrder(inventory, width, heigt);
        for (int i = 0; i < inv.length; ++i) {
            ItemStack stack;
            int index;
            if (inv[i].func_190926_b() || (index = GridRecipe.indexOf(inventory, stack = inv[i])) == -1 || !this.input[i].isInstance(stack)) continue;
            stack.func_190918_g(this.input[i].stackSize * amount);
            if (!stack.func_190926_b()) continue;
            inventory.func_70299_a(index, ItemStack.field_190927_a);
        }
    }

    public int getNumberofResults(IInventory inventory, int InvWidth, int InvHeigt) {
        ItemStack[] inv = this.getObjectInValidOrder(inventory, InvWidth, InvHeigt);
        if (this.isValidRecipe(inv)) {
            int number = Integer.MAX_VALUE;
            for (int i = 0; i < this.input.length; ++i) {
                int uses = inv[i].func_190916_E() / this.input[i].stackSize;
                number = Math.min(uses, number);
            }
            return number;
        }
        return 0;
    }

    protected ItemStack[] getObjectInValidOrder(IInventory inventory, int InvWidth, int InvHeigt) {
        int y;
        if (InvWidth < this.width || InvHeigt < this.height) {
            return null;
        }
        int posX = 0;
        int posY = 0;
        int posX2 = -1;
        int posY2 = -1;
        boolean foundX = false;
        for (int x = 0; x < InvWidth; ++x) {
            for (y = 0; y < InvHeigt; ++y) {
                if (inventory.func_70301_a(x + y * InvHeigt).func_190926_b()) continue;
                foundX = true;
                posX2 = x;
            }
            if (foundX) continue;
            ++posX;
        }
        boolean foundY = false;
        for (y = 0; y < InvHeigt; ++y) {
            for (int x = 0; x < InvWidth; ++x) {
                if (inventory.func_70301_a(x + y * InvHeigt).func_190926_b()) continue;
                foundY = true;
                posY2 = y;
            }
            if (foundY) continue;
            ++posY;
        }
        if (posX2 < 0 || posY2 < 0) {
            return null;
        }
        int gridWidth = posX2 - posX + 1;
        int gridHeight = posY2 - posY + 1;
        if (gridWidth != this.width || gridHeight != this.height) {
            return null;
        }
        ItemStack[] inv = new ItemStack[this.input.length];
        for (int y2 = 0; y2 < this.height; ++y2) {
            for (int x = 0; x < this.width; ++x) {
                inv[y2 * this.width + x] = inventory.func_70301_a(x + y2 * InvWidth);
            }
        }
        return inv;
    }

    public boolean isValidRecipe(IInventory inventory, int InvWidth, int InvHeigt) {
        ItemStack[] inv = this.getObjectInValidOrder(inventory, InvWidth, InvHeigt);
        if (inv == null) {
            return false;
        }
        return this.isValidRecipe(inv);
    }

    protected boolean isStackValid(ItemStack stack, InfoStack input) {
        if (stack.func_190926_b() && input == null) {
            return true;
        }
        if (input != null) {
            return input.isInstance(stack);
        }
        return false;
    }

    protected boolean isValidRecipe(ItemStack[] inv) {
        for (int i = 0; i < this.input.length; ++i) {
            if (this.isStackValid(inv[i], this.input[i])) continue;
            return false;
        }
        return true;
    }
}

