/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.decoration.feature;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.init.Bootstrap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import vazkii.arl.recipe.RecipeHandler;
import vazkii.arl.util.ProxyRegistry;
import vazkii.quark.base.module.Feature;
import vazkii.quark.decoration.block.BlockRope;

public class Rope
extends Feature {
    public static Block rope;
    public static boolean forceEnableMoveTEs;
    public static int recipeCount;
    public static boolean enableDispenser;

    @Override
    public void setupConfig() {
        forceEnableMoveTEs = this.loadPropBool("Force Enable Move TEs", "Set to true to allow ropes to move Tile Entities even if Pistons Push TEs is disabled.\nNote that ropes will still use the same blacklist.", false);
        recipeCount = this.loadPropInt("Recipe Output", "", 2);
        enableDispenser = this.loadPropBool("Enable Dispenser", "", true);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        rope = new BlockRope();
        RecipeHandler.addOreDictRecipe((ItemStack)ProxyRegistry.newStack((Block)rope, (int)recipeCount), (Object[])new Object[]{"SSS", "S S", "SSS", Character.valueOf('S'), "string"});
    }

    @Override
    public void init() {
        if (enableDispenser) {
            BlockDispenser.field_149943_a.func_82595_a((Object)Item.func_150898_a((Block)rope), (Object)new BehaviourRope());
        }
    }

    @Override
    public boolean requiresMinecraftRestartToEnable() {
        return true;
    }

    public static class BehaviourRope
    extends Bootstrap.BehaviorDispenseOptional {
        @Nonnull
        protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            EnumFacing facing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
            BlockPos pos = source.func_180699_d().func_177972_a(facing);
            World world = source.func_82618_k();
            this.field_190911_b = false;
            IBlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() == rope) {
                if (((BlockRope)rope).pullDown(world, pos)) {
                    this.field_190911_b = true;
                    stack.func_190918_g(1);
                    return stack;
                }
            } else if (world.func_175623_d(pos) && rope.func_176196_c(world, pos)) {
                SoundType soundtype = rope.getSoundType(state, world, pos, null);
                world.func_175656_a(pos, rope.func_176223_P());
                world.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                this.field_190911_b = true;
                stack.func_190918_g(1);
                return stack;
            }
            return stack;
        }
    }
}

