/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.google.common.collect.Lists;
import com.mrcrayfish.furniture.blocks.BlockFurniture;
import com.mrcrayfish.furniture.util.Bounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockModernStair
extends BlockFurniture {
    public static final PropertyEnum<Type> TYPE = PropertyEnum.func_177709_a((String)"type", Type.class);
    private static final AxisAlignedBB[] BOTTOM_COLLISION_BOXES = new Bounds(0, 0, 0, 16, 8, 16).getRotatedBounds();
    private static final AxisAlignedBB[] TOP_COLLISION_BOXES = new Bounds(8, 0, 0, 16, 16, 16).getRotatedBounds();

    public BlockModernStair() {
        super(Material.field_151575_d);
        this.func_149711_c(1.0f);
        this.func_149663_c("modern_stair");
        this.setRegistryName("modern_stair");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a(TYPE, (Comparable)((Object)Type.NONE)));
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOTTOM_COLLISION_BOXES[facing.func_176736_b()]);
        Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)TOP_COLLISION_BOXES[facing.func_176736_b()]);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState downState;
        boolean up = false;
        boolean down = false;
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        IBlockState upState = worldIn.func_180495_p(pos.func_177984_a().func_177972_a(facing));
        if (upState.func_177230_c() == this && upState.func_177229_b((IProperty)FACING) == facing) {
            up = true;
        }
        if ((downState = worldIn.func_180495_p(pos.func_177977_b().func_177972_a(facing.func_176734_d()))).func_177230_c() == this && downState.func_177229_b((IProperty)FACING) == facing) {
            down = true;
        }
        state = up && down ? state.func_177226_a(TYPE, (Comparable)((Object)Type.BOTH)) : (up ? state.func_177226_a(TYPE, (Comparable)((Object)Type.DOWN)) : (down ? state.func_177226_a(TYPE, (Comparable)((Object)Type.UP)) : state.func_177226_a(TYPE, (Comparable)((Object)Type.NONE))));
        return state;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, TYPE});
    }

    protected List<AxisAlignedBB> getCollisionBoxList(IBlockState state, World world, BlockPos pos) {
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        boxes.add(BOTTOM_COLLISION_BOXES[facing.func_176736_b()]);
        boxes.add(TOP_COLLISION_BOXES[facing.func_176736_b()]);
        return boxes;
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : this.getCollisionBoxList(blockState, world, pos)) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult result = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            result = raytraceresult;
            d1 = d0;
        }
        return result;
    }

    public static enum Type implements IStringSerializable
    {
        NONE,
        UP,
        DOWN,
        BOTH;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.US);
        }
    }
}

