/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.render.tileentity;

import com.mrcrayfish.furniture.blocks.BlockFurnitureTile;
import com.mrcrayfish.furniture.client.ImageCache;
import com.mrcrayfish.furniture.client.ImageDownloadThread;
import com.mrcrayfish.furniture.client.Texture;
import com.mrcrayfish.furniture.tileentity.TileEntityPhotoFrame;
import java.util.List;
import java.util.Random;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.lwjgl.opengl.GL11;

public class PhotoFrameRenderer
extends TileEntitySpecialRenderer<TileEntityPhotoFrame> {
    private static final ResourceLocation NOISE = new ResourceLocation("cfm:textures/noise.png");
    private static final Random RAND = new Random();

    public void render(TileEntityPhotoFrame te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (te.getPhoto() == null) {
            return;
        }
        BlockPos pos = te.func_174877_v();
        IBlockState state = te.func_145831_w().func_180495_p(pos);
        if (!state.func_177227_a().contains(BlockFurnitureTile.FACING)) {
            return;
        }
        GlStateManager.func_179094_E();
        double frameWidth = 14.0;
        double frameHeight = 14.0;
        double frameYOffset = 1.0;
        double frameZOffset = 7.49;
        ImageDownloadThread.ImageDownloadResult result = te.getResult();
        if (result != null && result != ImageDownloadThread.ImageDownloadResult.SUCCESS) {
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179137_b((double)0.5, (double)(frameYOffset * 0.0625), (double)0.5);
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockFurnitureTile.FACING);
            GlStateManager.func_179114_b((float)((float)facing.func_176736_b() * -90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)(-frameWidth / 2.0 * 0.0625), (double)0.0, (double)0.0);
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(frameZOffset * 0.0625));
            GlStateManager.func_179137_b((double)(frameWidth * 0.0625 - 0.0625), (double)(frameHeight * 0.0625 - 0.0625), (double)0.0);
            GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
            GlStateManager.func_179152_a((float)0.01f, (float)0.01f, (float)0.01f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            String message = I18n.func_135052_a((String)result.getKey(), (Object[])new Object[0]);
            FontRenderer renderer = this.func_147498_b();
            List lines = renderer.func_78271_c(message, (int)((frameWidth - 2.0) * 6.3));
            for (int i = 0; i < lines.size(); ++i) {
                renderer.func_78276_b((String)lines.get(i), 0, renderer.field_78288_b * i, 0xFFFFFF);
            }
        } else {
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)0.65f, (float)0.65f, (float)0.65f, (float)1.0f);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179140_f();
            double startX = 0.0;
            double startY = 0.0;
            if (te.isLoading()) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(NOISE);
                GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
                GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                GlStateManager.func_179137_b((double)0.5, (double)(frameYOffset * 0.0625), (double)0.5);
                EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockFurnitureTile.FACING);
                GlStateManager.func_179114_b((float)((float)facing.func_176736_b() * -90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)(-frameWidth / 2.0 * 0.0625), (double)0.0, (double)0.0);
                GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(frameZOffset * 0.0625));
                double pixelScale = 0.00390625;
                double scaledWidth = frameWidth * 4.0;
                double scaledHeight = frameHeight * 4.0;
                double u = (double)((int)((256.0 - scaledWidth) * RAND.nextDouble())) * pixelScale;
                double v = (double)((int)((256.0 - scaledHeight) * RAND.nextDouble())) * pixelScale;
                startX *= 0.0625;
                startY *= 0.0625;
                frameWidth *= 0.0625;
                frameHeight *= 0.0625;
                GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-6.25E-4);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder buffer = tessellator.func_178180_c();
                buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                buffer.func_181662_b(startX, startY, 0.0).func_187315_a(u, v).func_181675_d();
                buffer.func_181662_b(startX, startY + frameHeight, 0.0).func_187315_a(u, v + scaledHeight * pixelScale).func_181675_d();
                buffer.func_181662_b(startX + frameWidth, startY + frameHeight, 0.0).func_187315_a(u + scaledWidth * pixelScale, v + scaledHeight * pixelScale).func_181675_d();
                buffer.func_181662_b(startX + frameWidth, startY, 0.0).func_187315_a(u + scaledWidth * pixelScale, v).func_181675_d();
                tessellator.func_78381_a();
            } else if (te.isLoaded()) {
                Texture texture = ImageCache.INSTANCE.get(te.getPhoto());
                if (texture != null) {
                    texture.bind();
                    GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                    double imageWidth = frameWidth;
                    double imageHeight = frameHeight;
                    if (!te.isStretched()) {
                        double scaleWidth = frameWidth / (double)texture.getWidth();
                        double scaleHeight = frameWidth / (double)texture.getHeight();
                        double scale = Math.min(scaleWidth, scaleHeight);
                        imageWidth = (double)texture.getWidth() * scale;
                        imageHeight = (double)texture.getHeight() * scale;
                        startX = (frameWidth - imageWidth) / 2.0;
                        startY = (frameHeight - imageHeight) / 2.0;
                    }
                    startX *= 0.0625;
                    startY *= 0.0625;
                    imageWidth *= 0.0625;
                    imageHeight *= 0.0625;
                    GlStateManager.func_179137_b((double)0.5, (double)(frameYOffset * 0.0625), (double)0.5);
                    EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)BlockFurnitureTile.FACING);
                    GlStateManager.func_179114_b((float)((float)facing.func_176736_b() * -90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179137_b((double)(-frameWidth / 2.0 * 0.0625), (double)0.0, (double)0.0);
                    GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(frameZOffset * 0.0625));
                    Tessellator tessellator = Tessellator.func_178181_a();
                    BufferBuilder buffer = tessellator.func_178180_c();
                    buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                    buffer.func_181662_b(0.0, 0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                    buffer.func_181662_b(0.0, imageHeight * 0.0625, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                    buffer.func_181662_b(imageWidth * 0.0625, imageHeight * 0.0625, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                    buffer.func_181662_b(imageWidth * 0.0625, 0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
                    tessellator.func_78381_a();
                    GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-6.25E-4);
                    buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    buffer.func_181662_b(startX, startY, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                    buffer.func_181662_b(startX, startY + imageHeight, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
                    buffer.func_181662_b(startX + imageWidth, startY + imageHeight, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
                    buffer.func_181662_b(startX + imageWidth, startY, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                    tessellator.func_78381_a();
                } else {
                    String photo = te.getPhoto();
                    if (photo != null) {
                        te.loadUrl(photo);
                    }
                }
            }
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
        }
        GlStateManager.func_179121_F();
    }
}

