/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.engine;

import buildcraft.api.enums.EnumPowerStage;
import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.mj.MjCapabilityHelper;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.lib.block.VanillaRotationHandlers;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.collect.OrderedEnumMap;
import buildcraft.lib.misc.data.ModelVariableData;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.tile.TileBC_Neptune;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEngineBase_BC8
extends TileBC_Neptune
implements ITickable,
IDebuggable {
    public static final double HEAT_PER_MJ = 0.0023;
    public static final double MIN_HEAT = 20.0;
    public static final double IDEAL_HEAT = 100.0;
    public static final double MAX_HEAT = 250.0;
    @Nonnull
    public final IMjConnector mjConnector = this.createConnector();
    private final MjCapabilityHelper mjCaps = new MjCapabilityHelper(this.mjConnector);
    protected double heat = 20.0;
    protected long power = 0L;
    private long lastPower = 0L;
    private float progress;
    private float lastProgress;
    private int progressPart = 0;
    protected EnumPowerStage powerStage = EnumPowerStage.BLUE;
    protected EnumFacing currentDirection = EnumFacing.UP;
    public long currentOutput;
    public boolean isRedstonePowered = false;
    protected boolean isPumping = false;
    public final ModelVariableData clientModelData = new ModelVariableData();

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.currentDirection = NBTUtilBC.readEnum(nbt.func_74781_a("currentDirection"), EnumFacing.class);
        if (this.currentDirection == null) {
            this.currentDirection = EnumFacing.UP;
        }
        this.isRedstonePowered = nbt.func_74767_n("isRedstonePowered");
        this.heat = nbt.func_74769_h("heat");
        this.power = nbt.func_74763_f("power");
        this.progress = nbt.func_74760_g("progress");
        this.progressPart = nbt.func_74762_e("progressPart");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("currentDirection", NBTUtilBC.writeEnum(this.currentDirection));
        nbt.func_74757_a("isRedstonePowered", this.isRedstonePowered);
        nbt.func_74780_a("heat", this.heat);
        nbt.func_74772_a("power", this.power);
        nbt.func_74776_a("progress", this.progress);
        nbt.func_74768_a("progressPart", this.progressPart);
        return nbt;
    }

    @Override
    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (side == Side.CLIENT) {
            if (id == NET_RENDER_DATA) {
                this.isPumping = buffer.readBoolean();
                this.currentDirection = buffer.func_179257_a(EnumFacing.class);
                this.powerStage = buffer.func_179257_a(EnumPowerStage.class);
                this.progress = buffer.readFloat();
            } else if (id == NET_GUI_DATA) {
                this.heat = buffer.readFloat();
                this.currentOutput = buffer.readLong();
                this.power = buffer.readLong();
            } else if (id == NET_GUI_TICK) {
                this.heat = buffer.readFloat();
                this.currentOutput = buffer.readLong();
                this.power = buffer.readLong();
            }
        }
    }

    @Override
    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER) {
            if (id == NET_RENDER_DATA) {
                buffer.writeBoolean(this.isPumping);
                buffer.writeEnumValue((Enum<?>)this.currentDirection);
                buffer.writeEnumValue(this.powerStage);
                buffer.writeFloat(this.progress);
            } else if (id == NET_GUI_DATA) {
                buffer.writeFloat((float)this.heat);
                buffer.writeLong(this.currentOutput);
                buffer.writeLong(this.power);
            } else if (id == NET_GUI_TICK) {
                buffer.writeFloat((float)this.heat);
                buffer.writeLong(this.currentOutput);
                buffer.writeLong(this.power);
            }
        }
    }

    public EnumActionResult attemptRotation() {
        OrderedEnumMap<EnumFacing> possible = VanillaRotationHandlers.ROTATE_FACING;
        EnumFacing current = this.currentDirection;
        for (int i = 0; i < 6; ++i) {
            if (!this.isFacingReceiver(current = possible.next(current))) continue;
            if (this.currentDirection != current) {
                this.currentDirection = current;
                this.sendNetworkUpdate(NET_RENDER_DATA);
                this.redrawBlock();
                this.field_145850_b.func_175722_b(this.func_174877_v(), this.func_145838_q(), true);
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.FAIL;
    }

    private boolean isFacingReceiver(EnumFacing dir) {
        TileEntity neighbour = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(dir));
        if (neighbour == null) {
            return false;
        }
        IMjConnector other = (IMjConnector)neighbour.getCapability(MjAPI.CAP_CONNECTOR, dir.func_176734_d());
        if (other == null) {
            return false;
        }
        return this.mjConnector.canConnect(other) && other.canConnect(this.mjConnector);
    }

    public void rotateIfInvalid() {
        if (this.currentDirection != null && this.isFacingReceiver(this.currentDirection)) {
            return;
        }
        this.attemptRotation();
        if (this.currentDirection == null) {
            this.currentDirection = EnumFacing.UP;
        }
    }

    @Override
    public void onPlacedBy(EntityLivingBase placer, ItemStack stack) {
        super.onPlacedBy(placer, stack);
        this.currentDirection = null;
        this.rotateIfInvalid();
    }

    protected Biome getBiome() {
        return this.field_145850_b.func_180494_b(this.func_174877_v());
    }

    protected float getBiomeHeat() {
        Biome biome = this.getBiome();
        float temp = biome.func_180626_a(this.func_174877_v());
        return Math.max(0.0f, Math.min(30.0f, temp * 15.0f));
    }

    public double getPowerLevel() {
        return (double)this.power / (double)this.getMaxPower();
    }

    protected EnumPowerStage computePowerStage() {
        double heatLevel = this.getHeatLevel();
        if (heatLevel < 0.25) {
            return EnumPowerStage.BLUE;
        }
        if (heatLevel < 0.5) {
            return EnumPowerStage.GREEN;
        }
        if (heatLevel < 0.75) {
            return EnumPowerStage.YELLOW;
        }
        if (heatLevel < (double)0.85f) {
            return EnumPowerStage.RED;
        }
        return EnumPowerStage.OVERHEAT;
    }

    public final EnumPowerStage getPowerStage() {
        EnumPowerStage newStage;
        if (!this.field_145850_b.field_72995_K && this.powerStage != (newStage = this.computePowerStage())) {
            this.powerStage = newStage;
            this.sendNetworkUpdate(NET_RENDER_DATA);
        }
        return this.powerStage;
    }

    public void updateHeatLevel() {
        this.heat = 230.0 * this.getPowerLevel() + 20.0;
    }

    public double getHeatLevel() {
        return (this.heat - 20.0) / 230.0;
    }

    public double getIdealHeatLevel() {
        return this.heat / 100.0;
    }

    public double getHeat() {
        return this.heat;
    }

    public double getPistonSpeed() {
        switch (this.getPowerStage()) {
            case BLUE: {
                return 0.02;
            }
            case GREEN: {
                return 0.04;
            }
            case YELLOW: {
                return 0.08;
            }
            case RED: {
                return 0.12;
            }
        }
        return 0.0;
    }

    @Nonnull
    protected abstract IMjConnector createConnector();

    @Override
    public void onNeighbourBlockChanged(Block block, BlockPos nehighbour) {
        super.onNeighbourBlockChanged(block, nehighbour);
        this.isRedstonePowered = this.field_145850_b.func_175687_A(this.func_174877_v()) > 0;
    }

    public void func_73660_a() {
        boolean overheat;
        this.deltaManager.tick();
        if (this.cannotUpdate()) {
            return;
        }
        boolean bl = overheat = this.getPowerStage() == EnumPowerStage.OVERHEAT;
        if (this.field_145850_b.field_72995_K) {
            this.lastProgress = this.progress;
            if (this.isPumping) {
                this.progress = (float)((double)this.progress + this.getPistonSpeed());
                if (this.progress >= 1.0f) {
                    this.progress = 0.0f;
                }
            } else if (this.progress > 0.0f) {
                this.progress -= 0.01f;
            }
            this.clientModelData.tick();
            return;
        }
        this.lastPower = 0L;
        if (!this.isRedstonePowered) {
            if (this.power > MjAPI.MJ) {
                this.power -= MjAPI.MJ;
            } else if (this.power > 0L) {
                this.power = 0L;
            }
        }
        this.updateHeatLevel();
        this.getPowerStage();
        this.engineUpdate();
        if (this.progressPart != 0) {
            this.progress = (float)((double)this.progress + this.getPistonSpeed());
            if ((double)this.progress > 0.5 && this.progressPart == 1) {
                this.progressPart = 2;
                this.sendPower();
            } else if (this.progress >= 1.0f) {
                this.progress = 0.0f;
                this.progressPart = 0;
            }
        } else if (this.isRedstonePowered && this.isActive()) {
            if (this.getPowerToExtract(false) > 0L) {
                this.progressPart = 1;
                this.setPumping(true);
            } else {
                this.setPumping(false);
            }
        } else {
            this.setPumping(false);
        }
        if (!overheat) {
            this.burn();
        }
        this.markChunkDirty();
    }

    private long getPowerToExtract(boolean doExtract) {
        TileEntity tile = this.getTileBuffer(this.currentDirection).getTile();
        if (tile == null) {
            return 0L;
        }
        if (tile.getClass() == this.getClass()) {
            TileEngineBase_BC8 other = (TileEngineBase_BC8)tile;
            return other.getMaxPower() - this.power;
        }
        IMjReceiver receiver = this.getReceiverToPower(tile, this.currentDirection);
        if (receiver == null) {
            return 0L;
        }
        return this.extractPower(0L, receiver.getPowerRequested(), doExtract);
    }

    private void sendPower() {
        long extracted;
        TileEntity tile = this.getTileBuffer(this.currentDirection).getTile();
        if (tile == null) {
            return;
        }
        if (this.getClass() == tile.getClass()) {
            TileEngineBase_BC8 other = (TileEngineBase_BC8)tile;
            if (this.currentDirection == other.currentDirection) {
                other.power += this.extractPower(0L, this.power, true);
            }
            return;
        }
        IMjReceiver receiver = this.getReceiverToPower(tile, this.currentDirection);
        if (receiver != null && (extracted = this.getPowerToExtract(true)) > 0L) {
            long excess = receiver.receivePower(extracted, false);
            this.extractPower(extracted - excess, extracted - excess, true);
        }
    }

    protected void burn() {
    }

    protected void engineUpdate() {
        if (!this.isRedstonePowered) {
            if (this.power >= 1L) {
                --this.power;
            } else if (this.power < 1L) {
                this.power = 0L;
            }
        }
    }

    public boolean isActive() {
        return true;
    }

    protected final void setPumping(boolean isActive) {
        if (this.isPumping == isActive) {
            return;
        }
        this.isPumping = isActive;
        this.sendNetworkUpdate(NET_RENDER_DATA);
    }

    public ITileBuffer getTileBuffer(EnumFacing side) {
        TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(side));
        return () -> tile;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
    }

    @Override
    public void func_145829_t() {
        super.func_145829_t();
    }

    public abstract boolean isBurning();

    public void addPower(long microJoules) {
        this.power += microJoules;
        this.lastPower += microJoules;
        if (this.getPowerStage() == EnumPowerStage.OVERHEAT) {
            // empty if block
        }
        if (this.power > this.getMaxPower()) {
            this.power = this.getMaxPower();
        }
    }

    public long extractPower(long min, long max, boolean doExtract) {
        long extracted;
        if (this.power < min) {
            return 0L;
        }
        long actualMax = max > this.maxPowerExtracted() ? this.maxPowerExtracted() : max;
        if (actualMax < min) {
            return 0L;
        }
        if (this.power >= actualMax) {
            extracted = actualMax;
            if (doExtract) {
                this.power -= actualMax;
            }
        } else {
            extracted = this.power;
            if (doExtract) {
                this.power = 0L;
            }
        }
        return extracted;
    }

    public final boolean isPoweredTile(TileEntity tile, EnumFacing side) {
        if (tile == null) {
            return false;
        }
        if (tile.getClass() == this.getClass()) {
            TileEngineBase_BC8 other = (TileEngineBase_BC8)tile;
            return other.currentDirection == this.currentDirection;
        }
        return this.getReceiverToPower(tile, side) != null;
    }

    public IMjReceiver getReceiverToPower(TileEntity tile, EnumFacing side) {
        if (tile == null) {
            return null;
        }
        IMjReceiver rec = (IMjReceiver)tile.getCapability(MjAPI.CAP_RECEIVER, side.func_176734_d());
        if (rec != null && rec.canConnect(this.mjConnector) && this.mjConnector.canConnect(rec)) {
            return rec;
        }
        return null;
    }

    @Override
    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (facing == this.currentDirection) {
            return this.mjCaps.getCapability(capability, facing);
        }
        return super.getCapability(capability, facing);
    }

    public abstract long getMaxPower();

    public long minPowerReceived() {
        return 2L * MjAPI.MJ;
    }

    public abstract long maxPowerReceived();

    public abstract long maxPowerExtracted();

    public abstract float explosionRange();

    public long getEnergyStored() {
        return this.power;
    }

    public abstract long getCurrentOutput();

    public boolean isEngineOn() {
        return this.isPumping;
    }

    @SideOnly(value=Side.CLIENT)
    public float getProgressClient(float partialTicks) {
        float last = this.lastProgress;
        float now = this.progress;
        if ((double)last > 0.5 && (double)now < 0.5) {
            now += 1.0f;
        }
        float interp = last * (1.0f - partialTicks) + now * partialTicks;
        return interp % 1.0f;
    }

    public EnumFacing getCurrentFacing() {
        return this.currentDirection;
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("facing = " + this.currentDirection);
        left.add("heat = " + LocaleUtil.localizeHeat(this.heat) + " -- " + String.format("%.2f %%", this.getHeatLevel()));
        left.add("power = " + LocaleUtil.localizeMj(this.power));
        left.add("stage = " + (Object)((Object)this.powerStage));
        left.add("progress = " + this.progress);
        left.add("last = " + LocaleUtil.localizeMjFlow(this.lastPower));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getClientDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        left.add("Current Model Variables:");
        this.clientModelData.addDebugInfo(left);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasFastRenderer() {
        return true;
    }

    @FunctionalInterface
    public static interface ITileBuffer {
        public TileEntity getTile();
    }
}

