/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui;

import buildcraft.lib.gui.IGuiElement;
import buildcraft.lib.gui.IInteractionElement;
import buildcraft.lib.gui.elem.ToolTip;
import buildcraft.lib.gui.help.ElementHelpInfo;
import buildcraft.lib.gui.pos.IGuiPosition;
import java.util.ArrayList;
import java.util.List;

public interface IContainingElement
extends IInteractionElement {
    public List<IGuiElement> getChildElements();

    default public IGuiPosition getChildElementPosition() {
        return this;
    }

    default public void calculateSizes() {
    }

    @Override
    default public void addToolTips(List<ToolTip> tooltips) {
        for (IGuiElement elem : this.getChildElements()) {
            elem.addToolTips(tooltips);
        }
    }

    @Override
    default public void addHelpElements(List<ElementHelpInfo.HelpPosition> elements) {
        for (IGuiElement elem : this.getChildElements()) {
            elem.addHelpElements(elements);
        }
    }

    @Override
    default public List<IGuiElement> getThisAndChildrenAt(double x, double y) {
        ArrayList<IGuiElement> list = new ArrayList<IGuiElement>();
        if (this.contains(x, y)) {
            list.add(this);
            for (IGuiElement elem : this.getChildElements()) {
                list.addAll(elem.getThisAndChildrenAt(x, y));
            }
        }
        return list;
    }

    @Override
    default public void onMouseClicked(int button) {
        for (IGuiElement elem : this.getChildElements()) {
            if (!(elem instanceof IInteractionElement)) continue;
            ((IInteractionElement)elem).onMouseClicked(button);
        }
    }

    @Override
    default public void onMouseReleased(int button) {
        for (IGuiElement elem : this.getChildElements()) {
            if (!(elem instanceof IInteractionElement)) continue;
            ((IInteractionElement)elem).onMouseReleased(button);
        }
    }

    @Override
    default public void onMouseDragged(int button, long ticksSinceClick) {
        for (IGuiElement elem : this.getChildElements()) {
            if (!(elem instanceof IInteractionElement)) continue;
            ((IInteractionElement)elem).onMouseDragged(button, ticksSinceClick);
        }
    }

    @Override
    default public boolean onKeyPress(char typedChar, int keyCode) {
        boolean action = false;
        for (IGuiElement elem : this.getChildElements()) {
            if (!(elem instanceof IInteractionElement)) continue;
            action |= ((IInteractionElement)elem).onKeyPress(typedChar, keyCode);
        }
        return action;
    }
}

