/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.recipe;

import buildcraft.api.recipes.IRefineryRecipeManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;

public enum RefineryRecipeRegistry implements IRefineryRecipeManager
{
    INSTANCE;

    public final IRefineryRecipeManager.IRefineryRegistry<IRefineryRecipeManager.IDistillationRecipe> distillationRegistry = new SingleRegistry<IRefineryRecipeManager.IDistillationRecipe>();
    public final IRefineryRecipeManager.IRefineryRegistry<IRefineryRecipeManager.IHeatableRecipe> heatableRegistry = new SingleRegistry<IRefineryRecipeManager.IHeatableRecipe>();
    public final IRefineryRecipeManager.IRefineryRegistry<IRefineryRecipeManager.ICoolableRecipe> coolableRegistry = new SingleRegistry<IRefineryRecipeManager.ICoolableRecipe>();

    @Override
    public IRefineryRecipeManager.IHeatableRecipe createHeatingRecipe(FluidStack in, FluidStack out, int heatFrom, int heatTo) {
        return new HeatableRecipe(in, out, heatFrom, heatTo);
    }

    @Override
    public IRefineryRecipeManager.ICoolableRecipe createCoolableRecipe(FluidStack in, FluidStack out, int heatFrom, int heatTo) {
        return new CoolableRecipe(in, out, heatFrom, heatTo);
    }

    @Override
    public IRefineryRecipeManager.IDistillationRecipe createDistillationRecipe(FluidStack in, FluidStack outGas, FluidStack outLiquid, long powerRequired) {
        return new DistillationRecipe(powerRequired, in, outGas, outLiquid);
    }

    @Override
    public IRefineryRecipeManager.IRefineryRegistry<IRefineryRecipeManager.IHeatableRecipe> getHeatableRegistry() {
        return this.heatableRegistry;
    }

    @Override
    public IRefineryRecipeManager.IRefineryRegistry<IRefineryRecipeManager.ICoolableRecipe> getCoolableRegistry() {
        return this.coolableRegistry;
    }

    @Override
    public IRefineryRecipeManager.IRefineryRegistry<IRefineryRecipeManager.IDistillationRecipe> getDistillationRegistry() {
        return this.distillationRegistry;
    }

    public static class CoolableRecipe
    extends HeatExchangeRecipe
    implements IRefineryRecipeManager.ICoolableRecipe {
        public CoolableRecipe(FluidStack in, FluidStack out, int heatFrom, int heatTo) {
            super(in, out, heatFrom, heatTo);
        }
    }

    public static class HeatableRecipe
    extends HeatExchangeRecipe
    implements IRefineryRecipeManager.IHeatableRecipe {
        public HeatableRecipe(FluidStack in, FluidStack out, int heatFrom, int heatTo) {
            super(in, out, heatFrom, heatTo);
        }
    }

    public static abstract class HeatExchangeRecipe
    extends RefineryRecipe
    implements IRefineryRecipeManager.IHeatExchangerRecipe {
        private final FluidStack out;
        private final int heatFrom;
        private final int heatTo;

        public HeatExchangeRecipe(FluidStack in, FluidStack out, int heatFrom, int heatTo) {
            super(in);
            this.out = out;
            this.heatFrom = heatFrom;
            this.heatTo = heatTo;
        }

        @Override
        public FluidStack out() {
            return this.out;
        }

        @Override
        public int heatFrom() {
            return this.heatFrom;
        }

        @Override
        public int heatTo() {
            return this.heatTo;
        }
    }

    public static class DistillationRecipe
    extends RefineryRecipe
    implements IRefineryRecipeManager.IDistillationRecipe {
        private final FluidStack outGas;
        private final FluidStack outLiquid;
        private final long powerRequired;

        public DistillationRecipe(long powerRequired, FluidStack in, FluidStack outGas, FluidStack outLiquid) {
            super(in);
            this.powerRequired = powerRequired;
            this.outGas = outGas;
            this.outLiquid = outLiquid;
        }

        @Override
        public FluidStack outGas() {
            return this.outGas;
        }

        @Override
        public FluidStack outLiquid() {
            return this.outLiquid;
        }

        @Override
        public long powerRequired() {
            return this.powerRequired;
        }
    }

    public static abstract class RefineryRecipe
    implements IRefineryRecipeManager.IRefineryRecipe {
        private final FluidStack in;

        public RefineryRecipe(FluidStack in) {
            this.in = in;
        }

        @Override
        public FluidStack in() {
            return this.in;
        }
    }

    private static class SingleRegistry<R extends IRefineryRecipeManager.IRefineryRecipe>
    implements IRefineryRecipeManager.IRefineryRegistry<R> {
        private final List<R> allRecipes = new LinkedList<R>();

        private SingleRegistry() {
        }

        @Override
        public Stream<R> getRecipes(Predicate<R> filter) {
            return this.allRecipes.stream().filter(filter);
        }

        @Override
        public Collection<R> getAllRecipes() {
            return this.allRecipes;
        }

        @Override
        @Nullable
        public R getRecipeForInput(@Nullable FluidStack fluid) {
            if (fluid == null) {
                return null;
            }
            for (IRefineryRecipeManager.IRefineryRecipe recipe : this.allRecipes) {
                if (!recipe.in().isFluidEqual(fluid)) continue;
                return (R)recipe;
            }
            return null;
        }

        @Override
        public Collection<R> removeRecipes(Predicate<R> toRemove) {
            ArrayList<IRefineryRecipeManager.IRefineryRecipe> removed = new ArrayList<IRefineryRecipeManager.IRefineryRecipe>();
            Iterator<R> iter = this.allRecipes.iterator();
            while (iter.hasNext()) {
                IRefineryRecipeManager.IRefineryRecipe recipe = (IRefineryRecipeManager.IRefineryRecipe)iter.next();
                if (!toRemove.test(recipe)) continue;
                iter.remove();
                removed.add(recipe);
            }
            return removed;
        }

        @Override
        public R addRecipe(R recipe) {
            if (recipe == null) {
                throw new NullPointerException("recipe");
            }
            ListIterator<R> iter = this.allRecipes.listIterator();
            while (iter.hasNext()) {
                IRefineryRecipeManager.IRefineryRecipe existing = (IRefineryRecipeManager.IRefineryRecipe)iter.next();
                if (!existing.in().isFluidEqual(recipe.in())) continue;
                iter.set(recipe);
                return recipe;
            }
            this.allRecipes.add(recipe);
            return recipe;
        }
    }
}

