/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.statement;

import buildcraft.api.core.InvalidInputDataException;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementManager;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.statement.StatementType;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;

public class StatementTypeParam
extends StatementType<IStatementParameter> {
    public static final StatementTypeParam INSTANCE = new StatementTypeParam();

    public StatementTypeParam() {
        super(IStatementParameter.class, null);
    }

    @Override
    public IStatementParameter convertToType(Object value) {
        return value instanceof IStatementParameter ? (IStatementParameter)value : null;
    }

    @Override
    public IStatementParameter readFromNbt(NBTTagCompound nbt) {
        String kind = nbt.func_74779_i("kind");
        StatementManager.IParameterReader reader = StatementManager.getParameterReader(kind);
        if (reader == null) {
            return null;
        }
        return reader.readFromNbt(nbt);
    }

    @Override
    public NBTTagCompound writeToNbt(IStatementParameter slot) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (slot != null) {
            slot.writeToNbt(nbt);
            nbt.func_74778_a("kind", slot.getUniqueTag());
        }
        return nbt;
    }

    @Override
    public IStatementParameter readFromBuffer(PacketBufferBC buffer) throws IOException {
        if (buffer.readBoolean()) {
            String tag = buffer.readString();
            StatementManager.IParamReaderBuf reader = StatementManager.paramsBuf.get(tag);
            if (reader == null) {
                throw new InvalidInputDataException("Unknown paramater type " + tag);
            }
            return reader.readFromBuf(buffer);
        }
        return null;
    }

    @Override
    public void writeToBuffer(PacketBufferBC buffer, IStatementParameter slot) {
        if (slot == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.func_180714_a(slot.getUniqueTag());
            slot.writeToBuf(buffer);
        }
    }
}

