/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipe;

import buildcraft.api.core.InvalidInputDataException;
import buildcraft.api.transport.pipe.IItemPipe;
import buildcraft.api.transport.pipe.IPipeRegistry;
import buildcraft.api.transport.pipe.PipeDefinition;
import buildcraft.lib.registry.RegistrationHelper;
import buildcraft.transport.item.ItemPipeHolder;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;

public enum PipeRegistry implements IPipeRegistry
{
    INSTANCE;

    private final RegistrationHelper helper = new RegistrationHelper();
    private final Map<ResourceLocation, PipeDefinition> definitions = new HashMap<ResourceLocation, PipeDefinition>();
    private final Map<PipeDefinition, IItemPipe> pipeItems = new IdentityHashMap<PipeDefinition, IItemPipe>();

    @Override
    public void registerPipe(PipeDefinition definition) {
        this.definitions.put(definition.identifier, definition);
    }

    @Override
    public void setItemForPipe(PipeDefinition definition, @Nullable IItemPipe item) {
        if (definition == null) {
            throw new NullPointerException("definition");
        }
        if (item == null) {
            this.pipeItems.remove(definition);
        } else {
            this.pipeItems.put(definition, item);
        }
    }

    @Override
    public ItemPipeHolder createItemForPipe(PipeDefinition definition) {
        ItemPipeHolder item = ItemPipeHolder.createAndTag(definition);
        this.helper.addForcedItem(item);
        if (this.definitions.values().contains(definition)) {
            this.setItemForPipe(definition, item);
        }
        return item;
    }

    @Override
    public IItemPipe createUnnamedItemForPipe(PipeDefinition definition, Consumer<Item> postCreate) {
        ItemPipeHolder item = ItemPipeHolder.create(definition);
        postCreate.accept((Item)item);
        this.helper.addForcedItem(item);
        if (this.definitions.values().contains(definition)) {
            this.setItemForPipe(definition, item);
        }
        return item;
    }

    @Override
    public IItemPipe getItemForPipe(PipeDefinition definition) {
        return this.pipeItems.get(definition);
    }

    @Override
    @Nullable
    public PipeDefinition getDefinition(ResourceLocation identifier) {
        return this.definitions.get(identifier);
    }

    @Nonnull
    public PipeDefinition loadDefinition(String identifier) throws InvalidInputDataException {
        PipeDefinition def = this.getDefinition(new ResourceLocation(identifier));
        if (def == null) {
            throw new InvalidInputDataException("Unknown pipe definition " + identifier);
        }
        return def;
    }

    @Override
    public Iterable<PipeDefinition> getAllRegisteredPipes() {
        return ImmutableList.copyOf(this.definitions.values());
    }
}

