/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractConditional;
import crazypants.enderio.base.config.recipes.xml.Fluid;
import crazypants.enderio.base.fluid.FluidFuelRegister;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;

public class Fuel
extends AbstractConditional {
    private Optional<Fluid> fluid = this.empty();
    private Optional<Integer> perTick = this.empty();
    private Optional<Integer> ticks = this.empty();

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        try {
            super.readResolve();
            if (!this.fluid.isPresent()) {
                throw new InvalidRecipeConfigException("Missing attribute 'fluid'");
            }
            if (!this.perTick.isPresent() || this.perTick.get() < 1) {
                throw new InvalidRecipeConfigException("Missing attribute 'perTick'");
            }
            if (!this.ticks.isPresent() || this.ticks.get() < 1) {
                throw new InvalidRecipeConfigException("Missing attribute 'ticks'");
            }
            this.valid = this.fluid.get().isValid();
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <fuel>");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        this.fluid.get().enforceValidity();
    }

    @Override
    public void register(@Nonnull String recipeName) {
        if (this.isValid() && this.isActive()) {
            FluidFuelRegister.instance.addFuel(this.fluid.get().getFluid(), (int)this.perTick.get(), (int)this.ticks.get());
        }
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("fluid".equals(name)) {
            this.fluid = this.of(new Fluid());
            this.fluid.get().setAttribute(factory, "name", value);
            this.fluid.get().readResolve();
            return true;
        }
        if ("pertick".equals(name)) {
            try {
                this.perTick = this.of(Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                throw new InvalidRecipeConfigException("Invalid value in 'pertick': Not a number");
            }
            return true;
        }
        if ("ticks".equals(name)) {
            try {
                this.ticks = this.of(Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                throw new InvalidRecipeConfigException("Invalid value in 'ticks': Not a number");
            }
            return true;
        }
        return super.setAttribute(factory, name, value);
    }
}

