/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.transceiver;

import com.enderio.core.common.network.NetworkUtil;
import crazypants.enderio.base.transceiver.Channel;
import crazypants.enderio.base.transceiver.ChannelRegister;
import crazypants.enderio.base.transceiver.ClientChannelRegister;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketChannelList
implements IMessage {
    @Nonnull
    private final List<Channel> channels = new ArrayList<Channel>();

    public PacketChannelList() {
    }

    public PacketChannelList(ChannelRegister register) {
        this.channels.addAll(register.getAllChannels());
    }

    public void toBytes(ByteBuf buf) {
        NBTTagList tagList = new NBTTagList();
        for (Channel chan : this.channels) {
            NBTTagCompound tag = new NBTTagCompound();
            chan.writeToNBT(tag);
            tagList.func_74742_a((NBTBase)tag);
        }
        NBTTagCompound root = new NBTTagCompound();
        root.func_74782_a("chanList", (NBTBase)tagList);
        NetworkUtil.writeNBTTagCompound((NBTTagCompound)root, (ByteBuf)buf);
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound root = NetworkUtil.readNBTTagCompound((ByteBuf)buf);
        NBTTagList tagList = (NBTTagList)root.func_74781_a("chanList");
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            Channel chan = Channel.readFromNBT(tag);
            if (chan == null) continue;
            this.channels.add(chan);
        }
    }

    public static class Handler
    implements IMessageHandler<PacketChannelList, IMessage> {
        public IMessage onMessage(PacketChannelList message, MessageContext ctx) {
            ClientChannelRegister.instance.reset();
            for (Channel channel : message.channels) {
                ClientChannelRegister.instance.addChannel(channel);
            }
            return null;
        }
    }
}

