/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machines.machine.obelisk.xp;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.fluid.FluidWrapper;
import com.enderio.core.common.fluid.SmartTankFluidHandler;
import crazypants.enderio.base.fluid.SmartTankFluidMachineHandler;
import crazypants.enderio.base.machine.baselegacy.AbstractInventoryMachineEntity;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.base.xp.ExperienceContainer;
import crazypants.enderio.base.xp.IHaveExperience;
import crazypants.enderio.base.xp.PacketExperienceContainer;
import crazypants.enderio.base.xp.XpUtil;
import crazypants.enderio.machines.config.config.ExperienceConfig;
import crazypants.enderio.machines.config.config.XPObeliskConfig;
import crazypants.enderio.machines.init.MachineObject;
import crazypants.enderio.machines.network.PacketHandler;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Storable
public class TileExperienceObelisk
extends AbstractInventoryMachineEntity
implements IHaveExperience,
ITankAccess {
    @Store
    @Nonnull
    private final ExperienceContainer xpCont = new ExperienceContainer(XpUtil.getExperienceForLevel((Integer)XPObeliskConfig.maxLevels.get()));
    private SmartTankFluidHandler smartTankFluidHandler;

    public TileExperienceObelisk() {
        super(new SlotDefinition(0, 0, 0));
        this.xpCont.setTileEntity((TileEntity)this);
        this.addICap(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facingIn -> this.getSmartTankFluidHandler().get(facingIn));
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return MachineObject.block_experience_obelisk.getUnlocalisedName();
    }

    @Override
    public boolean isMachineItemValidForSlot(int i, @Nonnull ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    protected boolean processTasks(boolean redstoneCheck) {
        if (this.xpCont.isDirty()) {
            PacketHandler.sendToAllAround((IMessage)new PacketExperienceContainer((TileEntity)this), (TileEntity)this);
            this.xpCont.setDirty(false);
        }
        return false;
    }

    @Override
    protected boolean doPull(@Nullable EnumFacing dir) {
        if (super.doPull(dir)) {
            return true;
        }
        if (dir != null && this.xpCont.getFluidAmount() < this.xpCont.getCapacity() && FluidWrapper.transfer((IBlockAccess)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(dir), (EnumFacing)dir.func_176734_d(), (FluidTank)this.xpCont, (int)((Integer)ExperienceConfig.maxIO.get())) > 0) {
            this.setTanksDirty();
            return true;
        }
        return false;
    }

    @Override
    protected boolean doPush(@Nullable EnumFacing dir) {
        if (super.doPush(dir)) {
            return true;
        }
        if (dir != null && this.xpCont.getFluidAmount() > 0 && FluidWrapper.transfer((FluidTank)this.xpCont, (IBlockAccess)this.field_145850_b, (BlockPos)this.func_174877_v().func_177972_a(dir), (EnumFacing)dir.func_176734_d(), (int)((Integer)ExperienceConfig.maxIO.get())) > 0) {
            this.setTanksDirty();
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public ExperienceContainer getContainer() {
        return this.xpCont;
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        return this.xpCont;
    }

    @Nonnull
    public FluidTank[] getOutputTanks() {
        return new FluidTank[]{this.xpCont};
    }

    public void setTanksDirty() {
        this.xpCont.setDirty(true);
    }

    protected SmartTankFluidHandler getSmartTankFluidHandler() {
        if (this.smartTankFluidHandler == null) {
            this.smartTankFluidHandler = new SmartTankFluidMachineHandler(this, new IFluidHandler[]{this.xpCont});
        }
        return this.smartTankFluidHandler;
    }
}

