/*
 * Decompiled with CFR 0.152.
 */
package therealfarfetchd.quacklib.common.api.util.math;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import therealfarfetchd.quacklib.common.api.util.math.MathUtilsKt;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0006\u0012\u0006\u0010\u0004\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0013\u001a\u00020\bH\u00c6\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\b2\b\b\u0002\u0010\u0004\u001a\u00020\bH\u00c6\u0001J\u0011\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\bH\u0086\u0002J\u0011\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0006H\u0086\u0002J\u0011\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0002J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001J\u0011\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\bH\u0086\u0002J\u0011\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0006H\u0086\u0002J\u0011\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\bH\u0086\u0002J\u0011\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0006H\u0086\u0002J\u0011\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0002J\u0016\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0000J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\bH\u0086\u0002J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0006H\u0086\u0002J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0002J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006\""}, d2={"Ltherealfarfetchd/quacklib/common/api/util/math/Vec2;", "", "x", "", "y", "(II)V", "", "(FF)V", "", "(DD)V", "getX", "()D", "xf", "getXf", "()F", "getY", "yf", "getYf", "component1", "component2", "copy", "div", "other", "equals", "", "hashCode", "minus", "plus", "rotate", "a", "center", "times", "toString", "", "QuackLib"})
public final class Vec2 {
    private final float xf;
    private final float yf;
    private final double x;
    private final double y;

    public final float getXf() {
        return this.xf;
    }

    public final float getYf() {
        return this.yf;
    }

    @NotNull
    public final Vec2 plus(@NotNull Vec2 other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return new Vec2(this.x + other.x, this.y + other.y);
    }

    @NotNull
    public final Vec2 minus(@NotNull Vec2 other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return new Vec2(this.x - other.x, this.y - other.y);
    }

    @NotNull
    public final Vec2 div(@NotNull Vec2 other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return new Vec2(this.x / other.x, this.y / other.y);
    }

    @NotNull
    public final Vec2 times(@NotNull Vec2 other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return new Vec2(this.x * other.x, this.y * other.y);
    }

    @NotNull
    public final Vec2 plus(double other) {
        return new Vec2(this.x + other, this.y + other);
    }

    @NotNull
    public final Vec2 minus(double other) {
        return new Vec2(this.x + other, this.y + other);
    }

    @NotNull
    public final Vec2 div(double other) {
        return new Vec2(this.x / other, this.y / other);
    }

    @NotNull
    public final Vec2 times(double other) {
        return new Vec2(this.x * other, this.y * other);
    }

    @NotNull
    public final Vec2 plus(float other) {
        return new Vec2(this.x + (double)other, this.y + (double)other);
    }

    @NotNull
    public final Vec2 minus(float other) {
        return new Vec2(this.x + (double)other, this.y + (double)other);
    }

    @NotNull
    public final Vec2 div(float other) {
        return new Vec2(this.x / (double)other, this.y / (double)other);
    }

    @NotNull
    public final Vec2 times(float other) {
        return new Vec2(this.x * (double)other, this.y * (double)other);
    }

    @NotNull
    public final Vec2 plus(int other) {
        return new Vec2(this.x + (double)other, this.y + (double)other);
    }

    @NotNull
    public final Vec2 minus(int other) {
        return new Vec2(this.x + (double)other, this.y + (double)other);
    }

    @NotNull
    public final Vec2 div(int other) {
        return new Vec2(this.x / (double)other, this.y / (double)other);
    }

    @NotNull
    public final Vec2 times(int other) {
        return new Vec2(this.x * (double)other, this.y * (double)other);
    }

    @NotNull
    public final Vec2 rotate(double a, @NotNull Vec2 center) {
        Vec2 vec2;
        Intrinsics.checkParameterIsNotNull((Object)center, (String)"center");
        if (a == 0.0 || Intrinsics.areEqual((Object)center, (Object)this)) {
            vec2 = Vec2.copy$default(this, 0.0, 0.0, 3, null);
        } else {
            double x1 = this.x - center.x;
            double y1 = this.y - center.y;
            double h = MathUtilsKt.getDistance(x1, y1);
            double d = 57.29577951308232;
            double d2 = Math.PI / 180;
            double d3 = Math.atan2(y1, x1);
            double angle = d2 * (d * d3 + a);
            double nx = MathUtilsKt.cos(angle) * h;
            double ny = MathUtilsKt.sin(angle) * h;
            vec2 = new Vec2(nx + center.x, ny + center.y);
        }
        return vec2;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public Vec2(double x, double y) {
        this.x = x;
        this.y = y;
        this.xf = (float)this.x;
        this.yf = (float)this.y;
    }

    public Vec2(int x, int y) {
        this((double)x, (double)y);
    }

    public Vec2(float x, float y) {
        this((double)x, (double)y);
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    @NotNull
    public final Vec2 copy(double x, double y) {
        return new Vec2(x, y);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Vec2 copy$default(Vec2 vec2, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = vec2.x;
        }
        if ((n & 2) != 0) {
            d2 = vec2.y;
        }
        return vec2.copy(d, d2);
    }

    @NotNull
    public String toString() {
        return "Vec2(x=" + this.x + ", y=" + this.y + ")";
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.x);
        long l2 = Double.doubleToLongBits(this.y);
        return (int)(l ^ l >>> 32) * 31 + (int)(l2 ^ l2 >>> 32);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Vec2)) break block3;
                Vec2 vec2 = (Vec2)object;
                if (Double.compare(this.x, vec2.x) != 0 || Double.compare(this.y, vec2.y) != 0) break block3;
            }
            return true;
        }
        return false;
    }
}

