/*
 * Decompiled with CFR 0.152.
 */
package ic2.api.classic.tile;

import ic2.api.classic.event.MachineRecipeEvent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public abstract class MachineType {
    private static MachineType[] storage = new MachineType[256];
    public static final MachineType furnace = new IC2MachineType(0, 0);
    public static final MachineType macerator = new IC2MachineType(1, 1);
    public static final MachineType extractor = new IC2MachineType(2, 2);
    public static final MachineType compressed = new IC2MachineType(3, 3);
    public static final MachineType recylced = new IC2MachineType(4, 4);
    public static final MachineType massFabricated = new IC2MachineType(5, 5);
    public static final MachineType sawMill = new IC2MachineType(6, 6);
    int recipeID;

    public MachineType(int typeID) {
        if (storage[typeID] != null) {
            throw new RuntimeException("AlreadyUsedID");
        }
        this.recipeID = typeID;
        MachineType.storage[typeID] = this;
    }

    public int hashCode() {
        return this.getID();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MachineType) {
            return ((MachineType)obj).getID() == this.getID();
        }
        return false;
    }

    public final int getID() {
        return this.recipeID;
    }

    public abstract MachineRecipeEvent createEvent(EntityPlayer var1, ItemStack var2, boolean var3);

    public static boolean hasID(int id) {
        return storage[id] != null;
    }

    public static MachineType getFromID(int id) {
        return storage[id];
    }

    public static class IC2MachineType
    extends MachineType {
        int subType;

        public IC2MachineType(int typeID, int subID) {
            super(typeID);
            this.subType = subID;
        }

        @Override
        public MachineRecipeEvent createEvent(EntityPlayer player, ItemStack stack, boolean automated) {
            switch (this.subType) {
                case 0: {
                    return new MachineRecipeEvent.ItemSmeltedEvent(player, stack, automated);
                }
                case 1: {
                    return new MachineRecipeEvent.ItemMaceratedEvent(player, stack, automated);
                }
                case 2: {
                    return new MachineRecipeEvent.ItemExtractedEvent(player, stack, automated);
                }
                case 3: {
                    return new MachineRecipeEvent.ItemCompressedEvent(player, stack, automated);
                }
                case 4: {
                    return new MachineRecipeEvent.ItemRecycledEvent(player, stack, automated);
                }
                case 5: {
                    return new MachineRecipeEvent.MatterCreatedEvent(player, stack, automated);
                }
                case 6: {
                    return new MachineRecipeEvent.ItemSawCuttedEvent(player, stack, automated);
                }
            }
            return null;
        }
    }
}

