/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal.base.trades.builder;

import ic2.api.classic.trading.trades.IFluidTrade;
import ic2.core.block.personal.base.misc.PersonalInventory;
import ic2.core.block.personal.base.trades.builder.FluidInventory;
import ic2.core.block.personal.base.trades.builder.ItemTradeFabricator;
import ic2.core.block.personal.trades.fluids.BasicCustomFluidTrade;
import ic2.core.util.misc.FluidHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;

public class FluidTradeFabricator {
    Map<Integer, NonNullList<ItemStack>> inputs = new HashMap<Integer, NonNullList<ItemStack>>();
    Map<Integer, FluidStack[]> outputs = new HashMap<Integer, FluidStack[]>();
    Map<Integer, ItemTradeFabricator.ItemTradeRules> rules = new HashMap<Integer, ItemTradeFabricator.ItemTradeRules>();
    Set<Integer> slots = new HashSet<Integer>();

    public void pushToSlots(int slot, PersonalInventory item, FluidInventory fluid) {
        NonNullList in = this.inputs.get(slot);
        FluidStack[] out = this.outputs.get(slot);
        if (in == null || in.size() != 8) {
            in = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
        }
        if (out == null || out.length != 8) {
            out = new FluidStack[8];
        }
        for (int i = 0; i < 8; ++i) {
            item.setStackInSlot(i, ((ItemStack)in.get(i)).func_77946_l());
            fluid.setFluid(i, FluidHelper.copyFluid(out[i]));
        }
    }

    public void setItems(PersonalInventory in, FluidInventory out, int slot) {
        NonNullList item = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
        FluidStack[] fluid = new FluidStack[8];
        boolean hasAnything = false;
        for (int i = 0; i < 8; ++i) {
            item.set(i, (Object)in.getStackInSlot(i).func_77946_l());
            fluid[i] = FluidHelper.copyFluid(out.getFluid(i));
            if (hasAnything) continue;
            hasAnything = !((ItemStack)item.get(i)).func_190926_b() || fluid[i] != null;
        }
        if (hasAnything) {
            this.inputs.put(slot, (NonNullList<ItemStack>)item);
            this.outputs.put(slot, fluid);
            this.slots.add(slot);
        } else {
            this.inputs.remove(slot);
            this.outputs.remove(slot);
            this.slots.remove(slot);
        }
    }

    public boolean hasKey(int slot) {
        return this.slots.contains(slot);
    }

    public void setItems(int slot, PersonalInventory in, FluidInventory out, boolean copyInput, boolean copyOutput) {
        NonNullList input = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
        FluidStack[] output = new FluidStack[8];
        for (int i = 0; i < 8; ++i) {
            if (copyInput) {
                input.set(i, (Object)in.getStackInSlot(i));
            }
            if (!copyOutput) continue;
            output[i] = FluidHelper.copyFluid(out.getFluid(i));
        }
        this.inputs.put(slot, (NonNullList<ItemStack>)input);
        this.outputs.put(slot, output);
    }

    public IFluidTrade createTrade(UUID owner) {
        BasicCustomFluidTrade custom = new BasicCustomFluidTrade(owner);
        for (Integer slot : this.slots) {
            custom.addSlot(slot, this.inputs.get(slot), this.outputs.get(slot));
            custom.addRules(slot, this.getRules(slot));
        }
        custom.createSubTrades();
        return custom;
    }

    public void clear() {
        this.inputs.clear();
        this.outputs.clear();
        this.rules.clear();
        this.slots.clear();
    }

    public ItemTradeFabricator.ItemTradeRules getRules(int slot) {
        ItemTradeFabricator.ItemTradeRules newRules = this.rules.get(slot);
        if (newRules == null) {
            newRules = new ItemTradeFabricator.ItemTradeRules();
            this.rules.put(slot, newRules);
        }
        return newRules;
    }

    public void removeInput(int slot) {
        this.inputs.remove(slot);
    }
}

