/*
 * Decompiled with CFR 0.152.
 */
package cf.terminator.laggoggles.mixin;

import cf.terminator.laggoggles.profiler.ProfileManager;
import cf.terminator.laggoggles.util.ASMEventHandler;
import com.google.common.base.Throwables;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventBus;
import net.minecraftforge.fml.common.eventhandler.IEventExceptionHandler;
import net.minecraftforge.fml.common.eventhandler.IEventListener;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EventBus.class}, remap=false, priority=1001)
public abstract class MixinEventBus
implements IEventExceptionHandler {
    @Shadow
    private IEventExceptionHandler exceptionHandler;
    @Shadow
    @Final
    private int busID;

    private boolean postWithScan(Event event) {
        int index;
        IEventListener[] listeners = event.getListenerList().getListeners(this.busID);
        try {
            for (index = 0; index < listeners.length; ++index) {
                ModContainer mod;
                long LAGGOGGLES_START = System.nanoTime();
                listeners[index].invoke(event);
                long nanos = System.nanoTime() - LAGGOGGLES_START;
                if (!(listeners[index] instanceof ASMEventHandler) || (mod = ((ASMEventHandler)listeners[index]).getOwner()) == null) continue;
                String identifier = mod.getName() + " (" + mod.getSource().getName() + ")";
                ProfileManager.timingManager.addEventTime(identifier, event, nanos);
            }
        }
        catch (Throwable throwable) {
            this.exceptionHandler.handleException((EventBus)this, event, listeners, index, throwable);
            Throwables.propagate((Throwable)throwable);
        }
        return event.isCancelable() ? event.isCanceled() : false;
    }

    @Inject(method={"post(Lnet/minecraftforge/fml/common/eventhandler/Event;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void beforePost(Event event, CallbackInfoReturnable<Boolean> ci) {
        if (ProfileManager.PROFILE_ENABLED.get()) {
            ci.setReturnValue(this.postWithScan(event));
        }
    }
}

