/*
 * Decompiled with CFR 0.152.
 */
package cf.terminator.laggoggles.mixinhelper.extended;

import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;

public class MethodHelper {
    public static void findMethods(@Nullable String nameRegex, @Nullable String signatureRegex, ClassNode classNode, MethodHandler handler) {
        Pattern signaturePattern;
        if (nameRegex != null && nameRegex.equals("")) {
            nameRegex = null;
        }
        if (signatureRegex != null && signatureRegex.equals("")) {
            signatureRegex = null;
        }
        Pattern namePattern = nameRegex == null ? null : Pattern.compile(nameRegex);
        Pattern pattern = signaturePattern = signatureRegex == null ? null : Pattern.compile(signatureRegex);
        if (namePattern != null) {
            for (MethodNode node : classNode.methods) {
                if (!namePattern.matcher(node.name).find()) continue;
                if (signaturePattern == null) {
                    handler.onFoundMethod(node);
                    continue;
                }
                if (node.signature == null || !signaturePattern.matcher(node.signature).find()) continue;
                handler.onFoundMethod(node);
            }
        } else if (signaturePattern != null) {
            for (MethodNode node : classNode.methods) {
                if (!signaturePattern.matcher(node.signature).find()) continue;
                handler.onFoundMethod(node);
            }
        } else {
            throw new IllegalArgumentException("Namepattern and SignaturePattern cannot both be null!");
        }
    }

    public static LinkedList<MethodNode> findMethodCalls(@Nullable String nameRegex, @Nullable String signature, ClassNode classNode, InsnMethodHandler handler) {
        if (nameRegex != null && nameRegex.equals("")) {
            nameRegex = null;
        }
        Pattern namePattern = nameRegex == null ? null : Pattern.compile(nameRegex);
        LinkedList<MethodNode> changedMethods = new LinkedList<MethodNode>();
        if (namePattern != null) {
            for (MethodNode method : classNode.methods) {
                ListIterator<AbstractInsnNode> it = method.instructions.iterator();
                while (it.hasNext()) {
                    AbstractInsnNode node_raw = it.next();
                    if (!(node_raw instanceof MethodInsnNode)) continue;
                    MethodInsnNode node = (MethodInsnNode)node_raw;
                    if (!namePattern.matcher(node.name).find() || !Objects.equals(node.desc, signature)) continue;
                    handler.onFoundMethodNode(method, node);
                    if (changedMethods.contains(method)) continue;
                    changedMethods.add(method);
                }
            }
            return changedMethods;
        }
        throw new IllegalArgumentException("Namepattern and SignaturePattern cannot both be null!");
    }

    public static interface InsnMethodHandler {
        public void onFoundMethodNode(MethodNode var1, MethodInsnNode var2);
    }

    public static interface MethodHandler {
        public void onFoundMethod(MethodNode var1);
    }
}

