/*
 * Decompiled with CFR 0.152.
 */
package sct.hexxitgear.core.ability;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sct.hexxitgear.init.HexConfig;

public abstract class Ability {
    public static final List<Ability> ABILITIES = new ArrayList<Ability>();
    private static int curId = 0;
    private final String unlocName;
    private final int duration;
    private final int cooldown;
    private final boolean instant;
    private final int id;
    private final int xpCost;
    private final int hungerCost;

    public Ability(String name, String unlocalized, int duration, int cooldown, int xpCost, int hungerCost) {
        this.unlocName = unlocalized;
        this.duration = HexConfig.config.getInt(name + " Duration", name, duration, 2, Integer.MAX_VALUE, "The duration of " + name + " in ticks.");
        this.cooldown = HexConfig.config.getInt(name + " Cooldown", name, cooldown, 1, Integer.MAX_VALUE, "The cooldown of " + name + " in ticks.");
        this.instant = false;
        this.id = curId++;
        this.xpCost = HexConfig.config.getInt(name + " XP Cost", name, xpCost, 0, Integer.MAX_VALUE, "The xp cost of " + name + " in numerical xp.");
        this.hungerCost = HexConfig.config.getInt(name + " Hunger Cost", name, hungerCost, 0, Integer.MAX_VALUE, "The hunger cost of " + name + " in half-shanks.");
        ABILITIES.add(this);
    }

    public Ability(String name, String unlocalized, int cooldown, int xpCost, int hungerCost) {
        this.unlocName = unlocalized;
        this.duration = 1;
        this.cooldown = HexConfig.config.getInt(name + " Cooldown", name, cooldown, 1, Integer.MAX_VALUE, "The cooldown of " + name + " in ticks.");
        this.instant = true;
        this.id = curId++;
        this.xpCost = HexConfig.config.getInt(name + " XP Cost", name, xpCost, 0, Integer.MAX_VALUE, "The xp cost of " + name + " in numerical xp.");
        this.hungerCost = HexConfig.config.getInt(name + " Hunger Cost", name, hungerCost, 0, Integer.MAX_VALUE, "The hunger cost of " + name + " in half-shanks.");
        ABILITIES.add(this);
    }

    public String getUnlocalizedName() {
        return this.unlocName;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public boolean isInstant() {
        return this.instant;
    }

    public int getId() {
        return this.id;
    }

    public int getXpCost() {
        return this.xpCost;
    }

    public int getHungerCost() {
        return this.hungerCost;
    }

    public boolean canCast(EntityPlayer player) {
        return player.field_71106_cc >= (float)this.getXpCost() && player.func_71024_bL().func_75116_a() >= this.hungerCost;
    }

    public abstract void start(EntityPlayer var1);

    public abstract void tick(EntityPlayer var1, int var2);

    public abstract void end(EntityPlayer var1);

    @SideOnly(value=Side.CLIENT)
    public abstract void renderFirst(EntityPlayer var1);

    @SideOnly(value=Side.CLIENT)
    public abstract void renderAt(EntityPlayer var1, int var2);
}

