/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.item;

import com.creativemd.creativecore.client.rendering.RenderCubeObject;
import com.creativemd.creativecore.client.rendering.model.ICreativeRendered;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.render.cache.ItemModelCache;
import com.creativemd.littletiles.common.api.ILittleTile;
import com.creativemd.littletiles.common.item.ItemMultiTiles;
import com.creativemd.littletiles.common.structure.premade.LittleStructurePremade;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPremadeStructure
extends Item
implements ICreativeRendered,
ILittleTile {
    public ItemPremadeStructure() {
        this.func_77637_a(LittleTiles.littleTab);
        this.field_77787_bX = true;
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + ItemPremadeStructure.getPremadeID(stack);
    }

    public ArrayList<RenderCubeObject> getRenderingCubes(IBlockState state, TileEntity te, ItemStack stack) {
        return LittlePreview.getCubes(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void saveCachedModel(EnumFacing facing, BlockRenderLayer layer, List<BakedQuad> cachedQuads, IBlockState state, TileEntity te, ItemStack stack, boolean threaded) {
        if (stack != null) {
            ItemModelCache.cacheModel(stack, facing, cachedQuads);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> getCachedModel(EnumFacing facing, BlockRenderLayer layer, IBlockState state, TileEntity te, ItemStack stack, boolean threaded) {
        if (stack == null) {
            return null;
        }
        return ItemModelCache.requestCache(stack, facing);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (LittleStructurePremade.LittleStructurePremadeEntry entry : LittleStructurePremade.getPremadeStructures()) {
                list.add((Object)entry.stack);
            }
        }
    }

    @Override
    public boolean hasLittlePreview(ItemStack stack) {
        return true;
    }

    @Override
    public LittlePreviews getLittlePreview(ItemStack stack) {
        return LittlePreview.getPreview(stack, false);
    }

    @Override
    public void saveLittlePreview(ItemStack stack, LittlePreviews previews) {
        LittlePreview.savePreview(previews, stack);
    }

    @Override
    public boolean containsIngredients(ItemStack stack) {
        return true;
    }

    @Override
    public PlacementMode getPlacementMode(ItemStack stack) {
        if (!ItemMultiTiles.currentMode.canPlaceStructures()) {
            return PlacementMode.getStructureDefault();
        }
        return ItemMultiTiles.currentMode;
    }

    @Override
    public boolean snapToGridByDefault() {
        return true;
    }

    @Override
    public LittleVec getCachedSize(ItemStack stack) {
        if (stack.func_77978_p().func_74764_b("size")) {
            return LittlePreview.getSize(stack);
        }
        return null;
    }

    @Override
    public LittleVec getCachedOffset(ItemStack stack) {
        return LittlePreview.getOffset(stack);
    }

    public static String getPremadeID(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74775_l("structure").func_74779_i("id");
        }
        return null;
    }

    public static LittleStructurePremade.LittleStructurePremadeEntry getPremade(ItemStack stack) {
        if (stack.func_77942_o()) {
            return LittleStructurePremade.getStructurePremadeEntry(stack.func_77978_p().func_74775_l("structure").func_74779_i("id"));
        }
        return null;
    }
}

