/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.premade;

import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.premade.LittleExporter;
import com.creativemd.littletiles.common.structure.premade.LittleImporter;
import com.creativemd.littletiles.common.structure.premade.LittleSignalCable;
import com.creativemd.littletiles.common.structure.premade.LittleWorkbench;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.google.common.base.Charsets;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.IOUtils;

public abstract class LittleStructurePremade
extends LittleStructure {
    private static HashMap<String, LittleStructurePremadeEntry> structurePreviews = new HashMap();
    private static List<LittleStructureType.LittleStructureTypePremade> premadeStructures = new ArrayList<LittleStructureType.LittleStructureTypePremade>();
    private static JsonParser parser = new JsonParser();

    public LittleStructurePremade(LittleStructureType type) {
        super(type);
    }

    public static void reloadPremadeStructures() {
        structurePreviews.clear();
        for (LittleStructureType.LittleStructureTypePremade type : premadeStructures) {
            try {
                ItemStack stack = new ItemStack(LittleTiles.premade);
                NBTTagCompound structureNBT = new NBTTagCompound();
                structureNBT.func_74778_a("id", type.id);
                NBTTagCompound nbt = JsonToNBT.func_180713_a((String)IOUtils.toString((InputStream)LittleStructurePremade.class.getClassLoader().getResourceAsStream("assets/" + type.modid + "/premade/" + type.id + ".struct"), (Charset)Charsets.UTF_8));
                nbt.func_74782_a("structure", (NBTBase)structureNBT);
                stack.func_77982_d(nbt);
                LittlePreviews previews = LittlePreview.getPreview(stack);
                LittlePreview.savePreview(previews, stack);
                structurePreviews.put(type.id, new LittleStructurePremadeEntry(previews, stack));
                System.out.println("Loaded " + type.id + " model");
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Could not load '" + type.id + "'! Structure will not be registered");
            }
        }
    }

    public static void registerPremadeStructureType(String id, String modid, Class<? extends LittleStructurePremade> classStructure) {
        LittleStructurePremade.registerPremadeStructureType(id, modid, classStructure, 0);
    }

    public static void registerPremadeStructureType(String id, String modid, Class<? extends LittleStructurePremade> classStructure, int attribute) {
        premadeStructures.add((LittleStructureType.LittleStructureTypePremade)LittleStructureRegistry.registerStructureType(id, new LittleStructureType.LittleStructureTypePremade(id, "premade", classStructure, 4 | attribute, modid), null));
    }

    public static LittleStructurePremadeEntry getStructurePremadeEntry(String id) {
        return structurePreviews.get(id);
    }

    public static Collection<LittleStructurePremadeEntry> getPremadeStructures() {
        return structurePreviews.values();
    }

    public static Set<String> getPremadeStructureIds() {
        return structurePreviews.keySet();
    }

    public static ItemStack tryGetPremadeStack(String id) {
        LittleStructurePremadeEntry entry = structurePreviews.get(id);
        if (entry != null) {
            return entry.stack.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack getPremadeStack(String id) {
        return LittleStructurePremade.structurePreviews.get((Object)id).stack.func_77946_l();
    }

    @Override
    public ItemStack getStructureDrop() {
        return LittleStructurePremade.getPremadeStack(this.type.id).func_77946_l();
    }

    @Override
    public boolean canOnlyBePlacedByItemStack() {
        return true;
    }

    public static void initPremadeStructures() {
        LittleStructurePremade.registerPremadeStructureType("workbench", "littletiles", LittleWorkbench.class);
        LittleStructurePremade.registerPremadeStructureType("importer", "littletiles", LittleImporter.class);
        LittleStructurePremade.registerPremadeStructureType("exporter", "littletiles", LittleExporter.class);
        LittleStructurePremade.registerPremadeStructureType("cable", "littletiles", LittleSignalCable.class, 768);
    }

    public static class LittleStructurePremadeEntry {
        public final LittlePreviews previews;
        public final ItemStack stack;

        public LittleStructurePremadeEntry(LittlePreviews previews, ItemStack stack) {
            this.previews = previews;
            this.stack = stack;
        }

        public boolean arePreviewsEqual(LittlePreviews previews) {
            return this.previews.isVolumeEqual(previews);
        }
    }
}

