/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type.door;

import com.creativemd.creativecore.common.gui.CoreControl;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.controls.gui.timeline.GuiTimeline;
import com.creativemd.creativecore.common.gui.controls.gui.timeline.IAnimationHandler;
import com.creativemd.creativecore.common.gui.controls.gui.timeline.KeyControl;
import com.creativemd.creativecore.common.gui.controls.gui.timeline.TimelineChannel;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiToolTipEvent;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.utils.type.PairList;
import com.creativemd.creativecore.common.utils.type.UUIDSupplier;
import com.creativemd.littletiles.client.gui.controls.GuiLTDistance;
import com.creativemd.littletiles.client.gui.controls.GuiTileViewer;
import com.creativemd.littletiles.client.gui.dialogs.SubGuiDialogAxis;
import com.creativemd.littletiles.client.gui.dialogs.SubGuiDoorEvents;
import com.creativemd.littletiles.common.entity.DoorController;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.registry.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.relative.LTStructureAnnotation;
import com.creativemd.littletiles.common.structure.relative.StructureAbsolute;
import com.creativemd.littletiles.common.structure.relative.StructureRelative;
import com.creativemd.littletiles.common.structure.type.door.LittleDoor;
import com.creativemd.littletiles.common.structure.type.door.LittleDoorBase;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.math.vec.LittleVecContext;
import com.creativemd.littletiles.common.tile.preview.LittleAbsolutePreviewsStructure;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.util.animation.AnimationKey;
import com.creativemd.littletiles.common.util.animation.AnimationState;
import com.creativemd.littletiles.common.util.animation.AnimationTimeline;
import com.creativemd.littletiles.common.util.animation.ValueTimeline;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.vec.LittleTransformation;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleAdvancedDoor
extends LittleDoorBase {
    @LTStructureAnnotation(color=-65536)
    public StructureRelative axisCenter;
    public ValueTimeline rotX;
    public ValueTimeline rotY;
    public ValueTimeline rotZ;
    public LittleGridContext offGrid;
    public ValueTimeline offX;
    public ValueTimeline offY;
    public ValueTimeline offZ;

    public static PairList<Integer, Double> loadPairListDouble(int[] array) {
        PairList list = new PairList();
        for (int i = 0; i < array.length; i += 3) {
            list.add((Object)array[i], (Object)Double.longBitsToDouble((long)array[i + 1] << 32 | (long)array[i + 2] & 0xFFFFFFFFL));
        }
        return list;
    }

    public static PairList<Integer, Double> loadPairListInteger(int[] array) {
        PairList list = new PairList();
        for (int i = 0; i < array.length; i += 2) {
            list.add((Object)array[i], (Object)array[i + 1]);
        }
        return list;
    }

    public static PairList<Integer, Double> loadPairListDouble(int[] array, int from, int length) {
        PairList list = new PairList();
        for (int i = from; i < from + length; i += 3) {
            list.add((Object)array[i], (Object)Double.longBitsToDouble((long)array[i + 1] << 32 | (long)array[i + 2] & 0xFFFFFFFFL));
        }
        return list;
    }

    public static int[] savePairListDouble(PairList<Integer, Double> list) {
        if (list == null) {
            return null;
        }
        int[] array = new int[list.size() * 3];
        for (int i = 0; i < list.size(); ++i) {
            Pair pair = (Pair)list.get(i);
            array[i * 3] = (Integer)pair.key;
            long value = Double.doubleToLongBits((Double)pair.value);
            array[i * 3 + 1] = (int)(value >> 32);
            array[i * 3 + 2] = (int)value;
        }
        return array;
    }

    public static int[] savePairListInteger(PairList<Integer, Integer> list) {
        if (list == null) {
            return null;
        }
        int[] array = new int[list.size() * 2];
        for (int i = 0; i < list.size(); ++i) {
            Pair pair = (Pair)list.get(i);
            array[i * 2] = (Integer)pair.key;
            array[i * 2 + 1] = (Integer)pair.value;
        }
        return array;
    }

    public PairList<Integer, Double> interpolateToDouble(PairList<Integer, Integer> list) {
        if (list == null) {
            return null;
        }
        PairList converted = new PairList();
        for (Pair pair : list) {
            converted.add(pair.key, (Object)(this.offGrid.pixelSize * (double)((Integer)pair.value).intValue()));
        }
        return converted;
    }

    public PairList<Integer, Double> invert(PairList<Integer, Double> list) {
        if (list == null) {
            return null;
        }
        PairList inverted = new PairList();
        for (int i = list.size() - 1; i >= 0; --i) {
            Pair pair = (Pair)list.get(i);
            inverted.add((Object)(this.duration - (Integer)pair.key), pair.value);
        }
        return inverted;
    }

    public static boolean isAligned(AnimationKey key, ValueTimeline timeline) {
        if (timeline == null) {
            return true;
        }
        return key.isAligned(timeline.first(key));
    }

    public LittleAdvancedDoor(LittleStructureType type) {
        super(type);
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        super.writeToNBTExtra(nbt);
        NBTTagCompound animation = new NBTTagCompound();
        if (this.rotX != null) {
            animation.func_74783_a("rotX", this.rotX.write());
        }
        if (this.rotY != null) {
            animation.func_74783_a("rotY", this.rotY.write());
        }
        if (this.rotZ != null) {
            animation.func_74783_a("rotZ", this.rotZ.write());
        }
        if (this.offGrid != null) {
            animation.func_74768_a("offGrid", this.offGrid.size);
            if (this.offX != null) {
                animation.func_74783_a("offX", this.offX.write());
            }
            if (this.offY != null) {
                animation.func_74783_a("offY", this.offY.write());
            }
            if (this.offZ != null) {
                animation.func_74783_a("offZ", this.offZ.write());
            }
        }
        nbt.func_74782_a("animation", (NBTBase)animation);
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        super.loadFromNBTExtra(nbt);
        if (nbt.func_74764_b("animation")) {
            NBTTagCompound animation = nbt.func_74775_l("animation");
            if (animation.func_74764_b("rotX")) {
                this.rotX = ValueTimeline.read(animation.func_74759_k("rotX"));
            }
            if (animation.func_74764_b("rotY")) {
                this.rotY = ValueTimeline.read(animation.func_74759_k("rotY"));
            }
            if (animation.func_74764_b("rotZ")) {
                this.rotZ = ValueTimeline.read(animation.func_74759_k("rotZ"));
            }
            if (animation.func_74764_b("offGrid")) {
                this.offGrid = LittleGridContext.get(animation.func_74762_e("offGrid"));
                if (animation.func_74764_b("offX")) {
                    this.offX = ValueTimeline.read(animation.func_74759_k("offX"));
                }
                if (animation.func_74764_b("offY")) {
                    this.offY = ValueTimeline.read(animation.func_74759_k("offY"));
                }
                if (animation.func_74764_b("offZ")) {
                    this.offZ = ValueTimeline.read(animation.func_74759_k("offZ"));
                }
            }
        } else {
            if (nbt.func_74764_b("rotX")) {
                this.rotX = ValueTimeline.create(this.interpolation).addPoints(LittleAdvancedDoor.loadPairListDouble(nbt.func_74759_k("rotX")));
            }
            if (nbt.func_74764_b("rotY")) {
                this.rotY = ValueTimeline.create(this.interpolation).addPoints(LittleAdvancedDoor.loadPairListDouble(nbt.func_74759_k("rotY")));
            }
            if (nbt.func_74764_b("rotZ")) {
                this.rotZ = ValueTimeline.create(this.interpolation).addPoints(LittleAdvancedDoor.loadPairListDouble(nbt.func_74759_k("rotZ")));
            }
            if (nbt.func_74764_b("offGrid")) {
                this.offGrid = LittleGridContext.get(nbt.func_74762_e("offGrid"));
                if (nbt.func_74764_b("offX")) {
                    this.offX = ValueTimeline.create(this.interpolation).addPoints(LittleAdvancedDoor.loadPairListInteger(nbt.func_74759_k("offX")));
                }
                if (nbt.func_74764_b("offY")) {
                    this.offY = ValueTimeline.create(this.interpolation).addPoints(LittleAdvancedDoor.loadPairListInteger(nbt.func_74759_k("offY")));
                }
                if (nbt.func_74764_b("offZ")) {
                    this.offZ = ValueTimeline.create(this.interpolation).addPoints(LittleAdvancedDoor.loadPairListInteger(nbt.func_74759_k("offZ")));
                }
            }
        }
    }

    @Override
    public void onFlip(LittleGridContext context, EnumFacing.Axis axis, LittleVec doubledCenter) {
        super.onFlip(context, axis, doubledCenter);
        switch (axis) {
            case X: {
                if (this.rotY != null) {
                    this.rotY.flip();
                }
                if (this.rotZ != null) {
                    this.rotZ.flip();
                }
                if (this.offX == null) break;
                this.offX.flip();
                break;
            }
            case Y: {
                if (this.rotX != null) {
                    this.rotX.flip();
                }
                if (this.rotZ != null) {
                    this.rotZ.flip();
                }
                if (this.offY == null) break;
                this.offY.flip();
                break;
            }
            case Z: {
                if (this.rotX != null) {
                    this.rotX.flip();
                }
                if (this.rotY != null) {
                    this.rotY.flip();
                }
                if (this.offZ == null) break;
                this.offZ.flip();
            }
        }
    }

    @Override
    public void onRotate(LittleGridContext context, Rotation rotation, LittleVec doubledCenter) {
        super.onRotate(context, rotation, doubledCenter);
        ValueTimeline rotX = this.rotX;
        ValueTimeline rotY = this.rotY;
        ValueTimeline rotZ = this.rotZ;
        this.rotX = (ValueTimeline)rotation.getX((Object)rotX, (Object)rotY, (Object)rotZ);
        if (rotation.negativeX() && this.rotX != null) {
            this.rotX.flip();
        }
        this.rotY = (ValueTimeline)rotation.getY((Object)rotX, (Object)rotY, (Object)rotZ);
        if (rotation.negativeY() && this.rotY != null) {
            this.rotY.flip();
        }
        this.rotZ = (ValueTimeline)rotation.getZ((Object)rotX, (Object)rotY, (Object)rotZ);
        if (rotation.negativeZ() && this.rotZ != null) {
            this.rotZ.flip();
        }
        ValueTimeline offX = this.offX;
        ValueTimeline offY = this.offY;
        ValueTimeline offZ = this.offZ;
        this.offX = (ValueTimeline)rotation.getX((Object)offX, (Object)offY, (Object)offZ);
        if (rotation.negativeX() && this.offX != null) {
            this.offX.flip();
        }
        this.offY = (ValueTimeline)rotation.getY((Object)offX, (Object)offY, (Object)offZ);
        if (rotation.negativeY() && this.offY != null) {
            this.offY.flip();
        }
        this.offZ = (ValueTimeline)rotation.getZ((Object)offX, (Object)offY, (Object)offZ);
        if (rotation.negativeZ() && this.offZ != null) {
            this.offZ.flip();
        }
    }

    @Override
    public LittleTransformation[] getDoorTransformations(EntityPlayer player) {
        return new LittleTransformation[]{new LittleTransformation(this.getMainTile().te.func_174877_v(), 0, 0, 0, new LittleVec(0, 0, 0), new LittleVecContext())};
    }

    @Override
    public void transformDoorPreview(LittleAbsolutePreviewsStructure previews, LittleTransformation transformation) {
        LittleAdvancedDoor newDoor = (LittleAdvancedDoor)previews.getStructure();
        if (newDoor.axisCenter.getContext().size > previews.context.size) {
            previews.convertTo(newDoor.axisCenter.getContext());
        } else if (newDoor.axisCenter.getContext().size < previews.context.size) {
            newDoor.axisCenter.convertTo(previews.context);
        }
    }

    @Override
    public DoorController createController(LittleDoor.DoorOpeningResult result, UUIDSupplier supplier, LittleAbsolutePreviewsStructure previews, LittleTransformation transformation, int completeDuration) {
        LittleAdvancedDoor newDoor = (LittleAdvancedDoor)previews.getStructure();
        int duration = newDoor.duration;
        PairList open = new PairList();
        PairList close = new PairList();
        AnimationState opened = new AnimationState();
        AnimationState closed = new AnimationState();
        if (this.offX != null) {
            opened.set(AnimationKey.offX, this.offGrid.toVanillaGrid(this.offX.last(AnimationKey.offX)));
            closed.set(AnimationKey.offX, this.offGrid.toVanillaGrid(this.offX.first(AnimationKey.offX)));
            open.add((Object)AnimationKey.offX, (Object)this.offX.copy().factor(this.offGrid.pixelSize));
            close.add((Object)AnimationKey.offX, (Object)this.offX.invert(duration).factor(this.offGrid.pixelSize));
        }
        if (this.offY != null) {
            opened.set(AnimationKey.offY, this.offGrid.toVanillaGrid(this.offY.last(AnimationKey.offY)));
            closed.set(AnimationKey.offY, this.offGrid.toVanillaGrid(this.offY.first(AnimationKey.offY)));
            open.add((Object)AnimationKey.offY, (Object)this.offY.copy().factor(this.offGrid.pixelSize));
            close.add((Object)AnimationKey.offY, (Object)this.offY.invert(duration).factor(this.offGrid.pixelSize));
        }
        if (this.offZ != null) {
            opened.set(AnimationKey.offZ, this.offGrid.toVanillaGrid(this.offZ.last(AnimationKey.offZ)));
            closed.set(AnimationKey.offZ, this.offGrid.toVanillaGrid(this.offZ.first(AnimationKey.offZ)));
            open.add((Object)AnimationKey.offZ, (Object)this.offZ.copy().factor(this.offGrid.pixelSize));
            close.add((Object)AnimationKey.offZ, (Object)this.offZ.invert(duration).factor(this.offGrid.pixelSize));
        }
        if (this.rotX != null) {
            opened.set(AnimationKey.rotX, this.rotX.last(AnimationKey.rotX));
            closed.set(AnimationKey.rotX, this.rotX.first(AnimationKey.rotX));
            open.add((Object)AnimationKey.rotX, (Object)this.rotX);
            close.add((Object)AnimationKey.rotX, (Object)this.rotX.invert(duration));
        }
        if (this.rotY != null) {
            opened.set(AnimationKey.rotY, this.rotY.last(AnimationKey.rotY));
            closed.set(AnimationKey.rotY, this.rotY.first(AnimationKey.rotY));
            open.add((Object)AnimationKey.rotY, (Object)this.rotY);
            close.add((Object)AnimationKey.rotY, (Object)this.rotY.invert(duration));
        }
        if (this.rotZ != null) {
            opened.set(AnimationKey.rotZ, this.rotZ.last(AnimationKey.rotZ));
            closed.set(AnimationKey.rotZ, this.rotZ.first(AnimationKey.rotZ));
            open.add((Object)AnimationKey.rotZ, (Object)this.rotZ);
            close.add((Object)AnimationKey.rotZ, (Object)this.rotZ.invert(duration));
        }
        return new DoorController(result, supplier, closed, opened, this.stayAnimated ? null : Boolean.valueOf(false), duration, completeDuration, new AnimationTimeline(duration, (PairList<AnimationKey, ValueTimeline>)open), new AnimationTimeline(duration, (PairList<AnimationKey, ValueTimeline>)close), this.interpolation);
    }

    @Override
    public StructureAbsolute getAbsoluteAxis() {
        if (this.axisCenter == null) {
            return new StructureAbsolute(this.getMainTile().te.func_174877_v(), this.getMainTile().box, this.getMainTile().getContext());
        }
        return new StructureAbsolute(this.lastMainTileVec != null ? this.lastMainTileVec : this.getMainTile().getAbsolutePos(), this.axisCenter);
    }

    public static class LittleAdvancedDoorParser
    extends LittleStructureGuiParser {
        public LittleGridContext context;
        @SideOnly(value=Side.CLIENT)
        private KeyControl selected;

        public LittleAdvancedDoorParser(GuiParent parent, AnimationGuiHandler handler) {
            super(parent, handler);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void createControls(LittlePreviews previews, LittleStructure structure) {
            LittleAdvancedDoor door = structure instanceof LittleAdvancedDoor ? (LittleAdvancedDoor)structure : null;
            ArrayList<TimelineChannel> channels = new ArrayList<TimelineChannel>();
            channels.add(new TimelineChannel.TimelineChannelDouble("rot X").addKeys(door != null && door.rotX != null ? door.rotX.getPointsCopy() : null));
            channels.add(new TimelineChannel.TimelineChannelDouble("rot Y").addKeys(door != null && door.rotY != null ? door.rotY.getPointsCopy() : null));
            channels.add(new TimelineChannel.TimelineChannelDouble("rot Z").addKeys(door != null && door.rotZ != null ? door.rotZ.getPointsCopy() : null));
            channels.add(new TimelineChannel.TimelineChannelInteger("off X").addKeys(door != null && door.offX != null ? door.offX.getRoundedPointsCopy() : null));
            channels.add(new TimelineChannel.TimelineChannelInteger("off Y").addKeys(door != null && door.offY != null ? door.offY.getRoundedPointsCopy() : null));
            channels.add(new TimelineChannel.TimelineChannelInteger("off Z").addKeys(door != null && door.offZ != null ? door.offZ.getRoundedPointsCopy() : null));
            this.parent.controls.add(new GuiTimeline("timeline", 0, 0, 190, 67, door != null ? door.duration : 50, channels, (IAnimationHandler)this.handler).setSidebarWidth(30));
            this.parent.controls.add(new GuiLabel("tick", "0", 150, 75));
            this.context = door != null ? (door.offGrid != null ? door.offGrid : LittleGridContext.get()) : LittleGridContext.get();
            this.parent.controls.add((GuiControl)new GuiTextfield("keyValue", "", 0, 75, 40, 10).setFloatOnly().setEnabled(false));
            this.parent.controls.add(new GuiLTDistance("keyDistance", 0, 75, this.context, 0).setVisible(false));
            this.parent.controls.add(new GuiLabel("Position:", 90, 90));
            this.parent.controls.add((GuiControl)new GuiTextfield("keyPosition", "", 149, 90, 40, 10).setNumbersOnly().setEnabled(false));
            this.parent.controls.add(new SubGuiDialogAxis.GuiAxisButton("axis", "open axis", 0, 93, 50, 10, previews.context, structure instanceof LittleAdvancedDoor ? (LittleAdvancedDoor)structure : null, this.handler));
            this.parent.controls.add(new GuiCheckBox("stayAnimated", CoreControl.translate((String)"gui.door.stayAnimated"), 0, 123, structure instanceof LittleAdvancedDoor ? ((LittleDoorBase)structure).stayAnimated : false).setCustomTooltip(new String[]{CoreControl.translate((String)"gui.door.stayAnimatedTooltip")}));
            this.parent.controls.add(new GuiLabel(CoreControl.translate((String)"gui.door.duration") + ":", 90, 122));
            this.parent.controls.add(new GuiTextfield("duration_s", structure instanceof LittleAdvancedDoor ? "" + ((LittleDoorBase)structure).duration : "50", 149, 121, 40, 8).setNumbersOnly());
            this.parent.controls.add(new GuiCheckBox("rightclick", CoreControl.translate((String)"gui.door.rightclick"), 0, 108, structure instanceof LittleDoor ? !((LittleDoor)structure).disableRightClick : true));
            this.parent.controls.add(new GuiStateButton("interpolation", structure instanceof LittleDoorBase ? ((LittleDoorBase)structure).interpolation : 0, 140, 107, 40, 7, ValueTimeline.interpolationTypes));
            this.parent.controls.add(new SubGuiDoorEvents.GuiDoorEventsButton("children_activate", 93, 107, previews, structure instanceof LittleDoorBase ? (LittleDoorBase)structure : null));
            this.updateTimeline();
        }

        public void updateTimeline() {
            ValueTimeline offZ;
            ValueTimeline offY;
            ValueTimeline offX;
            ValueTimeline rotZ;
            ValueTimeline rotY;
            GuiTimeline timeline = (GuiTimeline)this.parent.get("timeline");
            SubGuiDoorEvents.GuiDoorEventsButton children = (SubGuiDoorEvents.GuiDoorEventsButton)this.parent.get("children_activate");
            AnimationTimeline animation = new AnimationTimeline(timeline.getDuration(), (PairList<AnimationKey, ValueTimeline>)new PairList());
            GuiStateButton interpolationButton = (GuiStateButton)this.parent.get("interpolation");
            int interpolation = interpolationButton.getState();
            ValueTimeline rotX = ValueTimeline.create(interpolation, ((TimelineChannel)timeline.channels.get(0)).getPairs());
            if (rotX != null) {
                animation.values.add((Object)AnimationKey.rotX, (Object)rotX);
            }
            if ((rotY = ValueTimeline.create(interpolation, ((TimelineChannel)timeline.channels.get(1)).getPairs())) != null) {
                animation.values.add((Object)AnimationKey.rotY, (Object)rotY);
            }
            if ((rotZ = ValueTimeline.create(interpolation, ((TimelineChannel)timeline.channels.get(2)).getPairs())) != null) {
                animation.values.add((Object)AnimationKey.rotZ, (Object)rotZ);
            }
            if ((offX = ValueTimeline.create(interpolation, ((TimelineChannel)timeline.channels.get(3)).getPairs())) != null) {
                animation.values.add((Object)AnimationKey.offX, (Object)offX.factor(this.context.pixelSize));
            }
            if ((offY = ValueTimeline.create(interpolation, ((TimelineChannel)timeline.channels.get(4)).getPairs())) != null) {
                animation.values.add((Object)AnimationKey.offY, (Object)offY.factor(this.context.pixelSize));
            }
            if ((offZ = ValueTimeline.create(interpolation, ((TimelineChannel)timeline.channels.get(5)).getPairs())) != null) {
                animation.values.add((Object)AnimationKey.offZ, (Object)offZ.factor(this.context.pixelSize));
            }
            this.handler.setTimeline(animation, children.events);
            GuiCheckBox stayAnimated = (GuiCheckBox)this.parent.get("stayAnimated");
            stayAnimated.enabled = animation.isFirstAligned();
        }

        @CustomEventSubscribe
        @SideOnly(value=Side.CLIENT)
        public void onKeySelected(GuiTimeline.KeySelectedEvent event) {
            GuiTextfield textfield = (GuiTextfield)this.parent.get("keyValue");
            GuiLTDistance distance = (GuiLTDistance)this.parent.get("keyDistance");
            this.selected = (KeyControl)event.source;
            if (((KeyControl)event.source).value instanceof Double) {
                distance.setVisible(false);
                textfield.setEnabled(true);
                textfield.setVisible(true);
                textfield.text = "" + this.selected.value;
            } else {
                distance.setEnabled(true);
                distance.setVisible(true);
                textfield.setVisible(false);
                distance.setDistance(this.context, (Integer)this.selected.value);
            }
            GuiTextfield position = (GuiTextfield)this.parent.get("keyPosition");
            position.setEnabled(true);
            position.text = "" + this.selected.tick;
        }

        @CustomEventSubscribe
        @SideOnly(value=Side.CLIENT)
        public void onChange(GuiControlChangedEvent event) {
            block22: {
                if (event.source.is(new String[]{"keyDistance"})) {
                    int scale;
                    if (!this.selected.modifiable) {
                        return;
                    }
                    GuiLTDistance distance = (GuiLTDistance)event.source;
                    LittleGridContext newContext = distance.getDistanceContext();
                    if (newContext.size > this.context.size) {
                        scale = newContext.size / this.context.size;
                        GuiTimeline timeline = (GuiTimeline)this.parent.get("timeline");
                        for (TimelineChannel channel : timeline.channels) {
                            if (!(channel instanceof TimelineChannel.TimelineChannelInteger)) continue;
                            for (Object control : channel.controls) {
                                KeyControl keyControl = (KeyControl)control;
                                Integer.valueOf((Integer)keyControl.value * scale);
                                keyControl.value = keyControl.value;
                            }
                        }
                        this.context = newContext;
                    }
                    scale = this.context.size / newContext.size;
                    this.selected.value = distance.getDistance();
                } else if (event.source.is(new String[]{"keyValue"})) {
                    if (!this.selected.modifiable) {
                        return;
                    }
                    try {
                        this.selected.value = Double.parseDouble(((GuiTextfield)event.source).text);
                    }
                    catch (NumberFormatException distance) {}
                } else if (event.source.is(new String[]{"keyPosition"})) {
                    if (!this.selected.modifiable) {
                        return;
                    }
                    try {
                        GuiTimeline timeline = (GuiTimeline)this.parent.get("timeline");
                        int tick = this.selected.tick;
                        int newTick = Integer.parseInt(((GuiTextfield)event.source).text);
                        if (!this.selected.channel.isSpaceFor(this.selected, newTick)) break block22;
                        this.selected.tick = newTick;
                        this.selected.channel.movedKey(this.selected);
                        if (tick != this.selected.tick) {
                            timeline.adjustKeysPositionX();
                        }
                    }
                    catch (NumberFormatException timeline) {}
                } else if (event.source.is(new String[]{"duration_s"})) {
                    try {
                        GuiTimeline timeline = (GuiTimeline)this.parent.get("timeline");
                        timeline.setDuration(Integer.parseInt(((GuiTextfield)event.source).text));
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (event.source.is(new String[]{"timeline"}) || event.source.is(new String[]{"children_activate"}) || event.source.is(new String[]{"interpolation"})) {
                    this.updateTimeline();
                }
            }
        }

        @CustomEventSubscribe
        @SideOnly(value=Side.CLIENT)
        public void onKeyDeselected(GuiTimeline.KeyDeselectedEvent event) {
            this.selected = null;
            GuiTextfield textfield = (GuiTextfield)this.parent.get("keyValue");
            textfield.setEnabled(false);
            textfield.text = "";
            textfield.setCursorPositionZero();
            textfield = (GuiTextfield)this.parent.get("keyPosition");
            textfield.setEnabled(false);
            textfield.text = "";
            textfield.setCursorPositionZero();
            GuiLTDistance distance = (GuiLTDistance)this.parent.get("keyDistance");
            distance.setEnabled(false);
            distance.resetTextfield();
            this.updateTimeline();
        }

        @CustomEventSubscribe
        @SideOnly(value=Side.CLIENT)
        public void toolTip(GuiToolTipEvent event) {
            if (event.source.is(new String[]{"timeline"})) {
                ((GuiLabel)this.parent.get((String)"tick")).caption = (String)event.tooltip.get(0);
                event.CancelEvent();
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public LittleStructure parseStructure(LittlePreviews previews) {
            LittleAdvancedDoor door = this.createStructure(LittleAdvancedDoor.class);
            GuiTileViewer viewer = ((SubGuiDialogAxis.GuiAxisButton)this.parent.get((String)"axis")).viewer;
            SubGuiDoorEvents.GuiDoorEventsButton button = (SubGuiDoorEvents.GuiDoorEventsButton)this.parent.get("children_activate");
            door.axisCenter = new StructureRelative(viewer.getBox(), viewer.getAxisContext());
            GuiTimeline timeline = (GuiTimeline)this.parent.get("timeline");
            door.duration = timeline.getDuration();
            GuiCheckBox checkBox = (GuiCheckBox)this.parent.get("stayAnimated");
            GuiCheckBox rightclick = (GuiCheckBox)this.parent.get("rightclick");
            GuiStateButton interpolationButton = (GuiStateButton)this.parent.get("interpolation");
            door.events = button.events;
            door.disableRightClick = !rightclick.value;
            door.interpolation = interpolationButton.getState();
            door.rotX = ValueTimeline.create(door.interpolation, ((TimelineChannel)timeline.channels.get(0)).getPairs());
            door.rotY = ValueTimeline.create(door.interpolation, ((TimelineChannel)timeline.channels.get(1)).getPairs());
            door.rotZ = ValueTimeline.create(door.interpolation, ((TimelineChannel)timeline.channels.get(2)).getPairs());
            door.offX = ValueTimeline.create(door.interpolation, ((TimelineChannel)timeline.channels.get(3)).getPairs());
            door.offY = ValueTimeline.create(door.interpolation, ((TimelineChannel)timeline.channels.get(4)).getPairs());
            door.offZ = ValueTimeline.create(door.interpolation, ((TimelineChannel)timeline.channels.get(5)).getPairs());
            door.stayAnimated = !LittleAdvancedDoor.isAligned(AnimationKey.offX, door.offX) || !LittleAdvancedDoor.isAligned(AnimationKey.offY, door.offY) || !LittleAdvancedDoor.isAligned(AnimationKey.offZ, door.offZ) || !LittleAdvancedDoor.isAligned(AnimationKey.rotX, door.rotX) || !LittleAdvancedDoor.isAligned(AnimationKey.rotY, door.rotY) || !LittleAdvancedDoor.isAligned(AnimationKey.rotZ, door.rotZ) ? true : checkBox.value;
            door.offGrid = this.context;
            return door;
        }
    }
}

