/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.place;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.api.ILittleTile;
import com.creativemd.littletiles.common.block.BlockTile;
import com.creativemd.littletiles.common.mod.chiselsandbits.ChiselsAndBitsManager;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleAbsoluteVec;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.place.PlacePreview;
import com.creativemd.littletiles.common.tile.place.fixed.FixedHandler;
import com.creativemd.littletiles.common.tile.place.fixed.InsideFixedHandler;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PlacementHelper {
    private static boolean lastLowResolution;
    private static NBTTagCompound lastCached;
    private static LittlePreviews lastPreviews;

    public static ILittleTile getLittleInterface(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.func_77973_b() instanceof ILittleTile) {
            return (ILittleTile)stack.func_77973_b();
        }
        if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof ILittleTile) {
            return (ILittleTile)Block.func_149634_a((Item)stack.func_77973_b());
        }
        return null;
    }

    public static boolean isLittleBlock(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() instanceof ILittleTile) {
            return ((ILittleTile)stack.func_77973_b()).hasLittlePreview(stack);
        }
        if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof ILittleTile) {
            return ((ILittleTile)Block.func_149634_a((Item)stack.func_77973_b())).hasLittlePreview(stack);
        }
        return false;
    }

    public static LittleVec getInternalOffset(ILittleTile iTile, ItemStack stack, LittlePreviews tiles, LittleGridContext original) {
        LittleVec offset = iTile.getCachedOffset(stack);
        if (offset != null) {
            if (tiles.context != original) {
                offset.convertTo(original, tiles.context);
            }
            return offset;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        for (LittlePreview preview : tiles.allPreviews()) {
            if (preview.box == null) continue;
            minX = Math.min(minX, preview.box.minX);
            minY = Math.min(minY, preview.box.minY);
            minZ = Math.min(minZ, preview.box.minZ);
        }
        return new LittleVec(minX, minY, minZ);
    }

    public static LittleVec getSize(ILittleTile iTile, ItemStack stack, LittlePreviews tiles, boolean allowLowResolution, LittleGridContext original) {
        LittleVec cached = iTile.getCachedSize(stack);
        if (cached != null) {
            if (tiles.context != original) {
                cached.convertTo(original, tiles.context);
            }
            return cached;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        LittleVec size = new LittleVec(0, 0, 0);
        for (LittlePreview preview : tiles.allPreviews()) {
            minX = Math.min(minX, preview.box.minX);
            minY = Math.min(minY, preview.box.minY);
            minZ = Math.min(minZ, preview.box.minZ);
            maxX = Math.max(maxX, preview.box.maxX);
            maxY = Math.max(maxY, preview.box.maxY);
            maxZ = Math.max(maxZ, preview.box.maxZ);
        }
        return new LittleVec(maxX - minX, maxY - minY, maxZ - minZ).max(size);
    }

    public static void removeCache() {
        lastCached = null;
        lastPreviews = null;
        lastLowResolution = false;
    }

    public static PositionResult getPosition(World world, RayTraceResult moving, LittleGridContext context) {
        PositionResult result = new PositionResult();
        int x = moving.func_178782_a().func_177958_n();
        int y = moving.func_178782_a().func_177956_o();
        int z = moving.func_178782_a().func_177952_p();
        boolean canBePlacedInsideBlock = true;
        if (!PlacementHelper.canBePlacedInside(world, moving.func_178782_a(), moving.field_72307_f, moving.field_178784_b)) {
            switch (moving.field_178784_b) {
                case EAST: {
                    ++x;
                    break;
                }
                case WEST: {
                    --x;
                    break;
                }
                case UP: {
                    ++y;
                    break;
                }
                case DOWN: {
                    --y;
                    break;
                }
                case SOUTH: {
                    ++z;
                    break;
                }
                case NORTH: {
                    --z;
                    break;
                }
            }
            canBePlacedInsideBlock = false;
        }
        result.facing = moving.field_178784_b;
        result.assign(PlacementHelper.getHitVec(moving, context, canBePlacedInsideBlock));
        result.setPos(new BlockPos(x, y, z));
        return result;
    }

    public static PreviewResult getPreviews(World world, ItemStack stack, PositionResult position, boolean centered, boolean fixed, boolean allowLowResolution, boolean marked, PlacementMode mode) {
        PreviewResult result;
        LittlePreviews tiles;
        ILittleTile iTile = PlacementHelper.getLittleInterface(stack);
        LittlePreviews littlePreviews = tiles = allowLowResolution == lastLowResolution && iTile.shouldCache() && lastCached != null && lastCached.equals((Object)stack.func_77978_p()) ? lastPreviews.copy() : null;
        if (tiles == null && iTile != null) {
            tiles = iTile.getLittlePreview(stack, allowLowResolution, marked);
        }
        if ((result = PlacementHelper.getPreviews(world, tiles, iTile.getPreviewsContext(stack), stack, position, centered, fixed, allowLowResolution, mode)) != null) {
            if (stack.func_77978_p() == null) {
                lastCached = null;
                lastPreviews = null;
            } else {
                lastLowResolution = allowLowResolution;
                lastCached = stack.func_77978_p().func_74737_b();
                lastPreviews = tiles.copy();
            }
        }
        return result;
    }

    public static PreviewResult getPreviews(World world, @Nullable LittlePreviews tiles, LittleGridContext original, ItemStack stack, PositionResult position, boolean centered, boolean fixed, boolean allowLowResolution, PlacementMode mode) {
        PreviewResult result = new PreviewResult();
        ILittleTile iTile = PlacementHelper.getLittleInterface(stack);
        if (tiles != null && (!tiles.isEmpty() || tiles.hasChildren())) {
            LittleGridContext context;
            if (tiles.isAbsolute()) {
                result.context = tiles.context;
                result.previews = tiles;
                result.singleMode = false;
                result.placedFixed = false;
                result.offset = new LittleAbsoluteVec(tiles.getBlockPos(), result.context, LittleVec.ZERO);
                position.assign(result.offset);
                result.placePreviews = new ArrayList<PlacePreview>();
                tiles.getPlacePreviews(result.placePreviews, null, true, null);
                return result;
            }
            if (tiles.hasStructure()) {
                LittleGridContext structureContext = tiles.getMinContext();
                if (structureContext.size > position.getContext().size) {
                    position.convertTo(structureContext);
                }
            }
            tiles.forceContext(position);
            result.context = context = tiles.context;
            result.previews = tiles;
            result.size = PlacementHelper.getSize(iTile, stack, tiles, allowLowResolution, original);
            ArrayList<InsideFixedHandler> shifthandlers = new ArrayList<InsideFixedHandler>();
            if (tiles.size() == 1) {
                shifthandlers.add(new InsideFixedHandler());
                result.singleMode = true;
                centered = true;
            }
            result.box = PlacementHelper.getTilesBox(position, result.size, centered, position.facing, mode);
            boolean canBePlaceFixed = false;
            if (fixed) {
                Block block;
                if (!result.singleMode && ((block = world.func_180495_p(position.getPos()).func_177230_c()).func_176200_f((IBlockAccess)world, position.getPos()) || block instanceof BlockTile)) {
                    TileEntity te;
                    canBePlaceFixed = true;
                    if (!mode.placeInside && (te = world.func_175625_s(position.getPos())) instanceof TileEntityLittleTiles) {
                        TileEntityLittleTiles teTiles = (TileEntityLittleTiles)te;
                        for (LittlePreview preview : tiles.allPreviews()) {
                            if (teTiles.isSpaceForLittleTile(preview.box)) continue;
                            canBePlaceFixed = false;
                            break;
                        }
                    }
                }
                if (!canBePlaceFixed) {
                    for (int i = 0; i < shifthandlers.size(); ++i) {
                        ((FixedHandler)shifthandlers.get(i)).init(world, position.getPos());
                    }
                    FixedHandler handler = null;
                    double distance = 2.0;
                    for (int i = 0; i < shifthandlers.size(); ++i) {
                        double tempDistance = ((FixedHandler)shifthandlers.get(i)).getDistance(position);
                        if (!(tempDistance < distance)) continue;
                        distance = tempDistance;
                        handler = (FixedHandler)shifthandlers.get(i);
                    }
                    if (handler != null) {
                        result.box = handler.getNewPosition(world, position.getPos(), context, result.box);
                    }
                }
            }
            LittleAbsoluteVec offset = new LittleAbsoluteVec(position.getPos(), context, result.box.getMinVec());
            LittleVec internalOffset = PlacementHelper.getInternalOffset(iTile, stack, tiles, original);
            internalOffset.invert();
            offset.getVec().add(internalOffset);
            result.offset = offset;
            result.placedFixed = canBePlaceFixed;
            if ((canBePlaceFixed || fixed && result.singleMode) && mode.placeInside && position.getVec().get(position.facing.func_176740_k()) % context.size == 0) {
                offset.getVec().add(position.facing.func_176734_d());
            }
            tiles.getPlacePreviews(result.placePreviews, result.box, canBePlaceFixed, offset.getVec());
            return result;
        }
        return null;
    }

    public static LittleBox getTilesBox(LittleAbsoluteVec pos, LittleVec size, boolean centered, @Nullable EnumFacing facing, PlacementMode mode) {
        LittleVec temp = pos.getVec().copy();
        if (centered) {
            LittleVec center = size.calculateCenter();
            LittleVec centerInv = size.calculateInvertedCenter();
            if (mode.placeInside) {
                facing = facing.func_176734_d();
            }
            switch (facing) {
                case EAST: {
                    temp.x += center.x;
                    break;
                }
                case WEST: {
                    temp.x -= centerInv.x;
                    break;
                }
                case UP: {
                    temp.y += center.y;
                    break;
                }
                case DOWN: {
                    temp.y -= centerInv.y;
                    break;
                }
                case SOUTH: {
                    temp.z += center.z;
                    break;
                }
                case NORTH: {
                    temp.z -= centerInv.z;
                    break;
                }
            }
        }
        return new LittleBox(temp, size.x, size.y, size.z);
    }

    public static boolean canBlockBeUsed(World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityLittleTiles) {
            return true;
        }
        return ChiselsAndBitsManager.isChiselsAndBitsStructure(tileEntity);
    }

    public static boolean canBePlacedInside(World world, BlockPos pos, Vec3d hitVec, EnumFacing side) {
        if (PlacementHelper.canBlockBeUsed(world, pos)) {
            switch (side) {
                case EAST: 
                case WEST: {
                    return (double)((int)hitVec.field_72450_a) != hitVec.field_72450_a;
                }
                case UP: 
                case DOWN: {
                    return (double)((int)hitVec.field_72448_b) != hitVec.field_72448_b;
                }
                case SOUTH: 
                case NORTH: {
                    return (double)((int)hitVec.field_72449_c) != hitVec.field_72449_c;
                }
            }
            return false;
        }
        return false;
    }

    public static LittleAbsoluteVec getHitVec(RayTraceResult result, LittleGridContext context, boolean isInsideOfBlock) {
        LittleAbsoluteVec pos = new LittleAbsoluteVec(result, context);
        if (!isInsideOfBlock) {
            pos.getVec().set(result.field_178784_b.func_176740_k(), result.field_178784_b.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 0 : context.size);
        }
        return pos;
    }

    public static class PreviewResult {
        public List<PlacePreview> placePreviews = new ArrayList<PlacePreview>();
        public LittlePreviews previews = null;
        public LittleGridContext context;
        public LittleBox box;
        public LittleVec size;
        public boolean singleMode = false;
        public boolean placedFixed = false;
        public LittleAbsoluteVec offset;

        public boolean isAbsolute() {
            return this.previews.isAbsolute();
        }
    }

    public static class PositionResult
    extends LittleAbsoluteVec {
        public EnumFacing facing;

        public PositionResult() {
            super((BlockPos)null, (LittleGridContext)null);
        }

        public PositionResult(BlockPos pos, LittleGridContext context, LittleVec vec, EnumFacing facing) {
            super(pos, context, vec);
            this.facing = facing;
        }

        public static PositionResult readFromBytes(ByteBuf buf) {
            PositionResult result = new PositionResult();
            result.pos = LittleAction.readPos((ByteBuf)buf);
            result.contextVec = LittleAction.readLittleVecContext(buf);
            result.facing = CreativeCorePacket.readFacing((ByteBuf)buf);
            return result;
        }

        public void assign(LittleAbsoluteVec pos) {
            this.pos = pos.getPos();
            this.contextVec = pos.getVecContext();
        }

        public AxisAlignedBB getBox() {
            double x = this.getPosX();
            double y = this.getPosY();
            double z = this.getPosZ();
            return new AxisAlignedBB(x, y, z, x + this.getContext().pixelSize, y + this.getContext().pixelSize, z + this.getContext().pixelSize);
        }

        public void subVec(LittleVec vec) {
            this.getVec().add(vec);
            this.removeInternalBlockOffset();
        }

        public void addVec(LittleVec vec) {
            this.getVec().sub(vec);
            this.removeInternalBlockOffset();
        }

        public void writeToBytes(ByteBuf buf) {
            LittleAction.writePos((ByteBuf)buf, (BlockPos)this.pos);
            LittleAction.writeLittleVecContext(this.contextVec, buf);
            CreativeCorePacket.writeFacing((ByteBuf)buf, (EnumFacing)this.facing);
        }

        @Override
        public PositionResult copy() {
            PositionResult result = new PositionResult();
            result.facing = this.facing;
            result.contextVec = this.contextVec.copy();
            result.pos = this.pos;
            return result;
        }
    }
}

