/*
 * Decompiled with CFR 0.152.
 */
package kaptainwutax.memorytester.data;

import kaptainwutax.memorytester.data.DataConfig;
import kaptainwutax.memorytester.data.DataUnit;
import kaptainwutax.memorytester.thread.ThreadMain;

public class DataGeneral
extends DataConfig {
    public static String directory = "config/MemoryTester/";
    public static String location = "General.txt";
    public DataUnit memoryTesterVersion;
    public DataUnit recommendedMemoryAllocation;
    public DataUnit useMenuGui;
    public DataUnit useCrashGui;
    public DataUnit windowIconDirectory;

    public DataGeneral(ThreadMain threadInstance) {
        super(threadInstance, directory, location);
    }

    @Override
    public void populateFields() {
        this.memoryTesterVersion = new DataUnit<String>("MemoryTesterVersion", "string", "0.4.2");
        this.recommendedMemoryAllocation = new DataUnit<Integer>("RecommendedMemoryAllocation", "int", 1024);
        this.useMenuGui = new DataUnit<Boolean>("UseMenu", "bool", true);
        this.useCrashGui = new DataUnit<Boolean>("CrashWhenNotEnoughMemory", "bool", false);
        this.windowIconDirectory = new DataUnit<String>("WindowIconDir", "string", "resources/windowIcon.png");
        super.populateFields();
    }

    @Override
    public void populateConfig() {
        this.addEntry(this.memoryTesterVersion);
        this.addEntry(this.recommendedMemoryAllocation);
        this.addEntry(this.useMenuGui);
        this.addEntry(this.useCrashGui);
        this.addEntry(this.windowIconDirectory);
        super.populateConfig();
    }

    @Override
    public void updateThread() {
        if (!this.memoryTesterVersion.getValue().toString().equals("0.4.2")) {
            this.threadInstance.inGuiErrorCrash("Configs need update.");
        }
        this.threadInstance.recommendedMemoryAllocation = (Integer)this.recommendedMemoryAllocation.getValue();
        this.threadInstance.useMenuGui = Boolean.parseBoolean(this.useMenuGui.getValue().toString());
        this.threadInstance.useCrashGui = Boolean.parseBoolean(this.useCrashGui.getValue().toString());
        this.threadInstance.windowIconDirectory = this.windowIconDirectory.getValue().toString();
    }
}

