/*
 * Decompiled with CFR 0.152.
 */
package kaptainwutax.memorytester.gui;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import kaptainwutax.memorytester.thread.ThreadMain;

public class GuiMenu
extends JFrame {
    private ThreadMain threadInstance;
    public JFrame frame;
    public JLabel memoryAllocatedText;
    public JLabel memoryAllocatedRecommendedText;
    public JButton startButton;
    public JButton quitButton;

    public GuiMenu(ThreadMain threadInstance) {
        this.threadInstance = threadInstance;
        this.initialize();
    }

    private void initialize() {
        this.frame = new JFrame();
        int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        this.frame.setBounds(0, 0, screenWidth / 2, screenHeight / 2);
        this.frame.setTitle("Memory Tester");
        this.frame.setDefaultCloseOperation(2);
        this.frame.getContentPane().setLayout(null);
        this.frame.setResizable(false);
        this.frame.setIconImage(new ImageIcon("config/MemoryTester/" + this.threadInstance.windowIconDirectory).getImage());
        this.frame.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent arg0) {
            }

            @Override
            public void windowClosed(WindowEvent arg0) {
                ((GuiMenu)GuiMenu.this).threadInstance.shouldGameStart = false;
                GuiMenu.this.frame.setEnabled(false);
                GuiMenu.this.frame.setVisible(false);
            }

            @Override
            public void windowClosing(WindowEvent arg0) {
            }

            @Override
            public void windowDeactivated(WindowEvent arg0) {
            }

            @Override
            public void windowDeiconified(WindowEvent arg0) {
            }

            @Override
            public void windowIconified(WindowEvent arg0) {
            }

            @Override
            public void windowOpened(WindowEvent arg0) {
            }
        });
        int textWidth = 1000;
        int textCenterX = this.frame.getWidth() / 2 - textWidth / 2;
        int textOffsetX = 0;
        int textHeight = 40;
        int textCenterY = this.frame.getHeight() / 2 - textHeight / 2;
        int textOffsetY = -150;
        this.memoryAllocatedText = new JLabel("loading...");
        this.memoryAllocatedText.setFont(new Font("Yu Gothic UI Light", 0, 30));
        this.memoryAllocatedText.setHorizontalAlignment(0);
        this.memoryAllocatedText.setBounds(textCenterX + textOffsetX, textCenterY + textOffsetY, textWidth, textHeight);
        this.frame.getContentPane().add(this.memoryAllocatedText);
        this.memoryAllocatedRecommendedText = new JLabel("loading...");
        this.memoryAllocatedRecommendedText.setFont(new Font("Yu Gothic UI Light", 0, 30));
        this.memoryAllocatedRecommendedText.setHorizontalAlignment(0);
        this.memoryAllocatedRecommendedText.setBounds(textCenterX + textOffsetX, textCenterY + textOffsetY + 40, textWidth, textHeight);
        this.frame.getContentPane().add(this.memoryAllocatedRecommendedText);
        int buttonWidth = 120;
        int buttonCenterX = this.frame.getWidth() / 2 - buttonWidth / 2;
        boolean buttonOffsetX = false;
        int buttonHeight = 40;
        int buttonCenterY = this.frame.getHeight() / 2 - buttonHeight / 2;
        boolean buttonOffsetY = false;
        this.startButton = new JButton("loading...");
        this.startButton.setEnabled(true);
        this.startButton.setBounds(screenWidth / 2 - 160, screenHeight / 2 - 90, buttonWidth, buttonHeight);
        this.startButton.setFocusPainted(false);
        this.frame.getContentPane().add(this.startButton);
        this.quitButton = new JButton("loading...");
        this.quitButton.setEnabled(true);
        this.quitButton.setBounds(40, screenHeight / 2 - 90, buttonWidth, buttonHeight);
        this.quitButton.setFocusPainted(false);
        this.frame.getContentPane().add(this.quitButton);
        JLabel backgroundImage = new JLabel("BackgroundImage");
        backgroundImage.setIcon(new ImageIcon(this.getScaledImage(new ImageIcon("config/MemoryTester/" + this.threadInstance.menuBackgroundImageDirectory).getImage(), screenWidth / 2, screenHeight / 2)));
        backgroundImage.setBounds(0, 0, screenWidth / 2, screenHeight / 2);
        backgroundImage.setHorizontalAlignment(2);
        backgroundImage.setVerticalAlignment(1);
        this.frame.getContentPane().add(backgroundImage);
        this.startButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                ((GuiMenu)GuiMenu.this).threadInstance.isInMenu = false;
                GuiMenu.this.frame.setEnabled(false);
                GuiMenu.this.frame.setVisible(false);
                GuiMenu.this.frame.dispose();
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        this.quitButton.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                ((GuiMenu)GuiMenu.this).threadInstance.shouldGameStart = false;
                GuiMenu.this.frame.setEnabled(false);
                GuiMenu.this.frame.setVisible(false);
                GuiMenu.this.frame.dispose();
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
    }

    private Image getScaledImage(Image rawImage, int imageWidth, int imageHeight) {
        BufferedImage resizedImage = new BufferedImage(imageWidth, imageHeight, 2);
        Graphics2D graphics = resizedImage.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics.drawImage(rawImage, 0, 0, imageWidth, imageHeight, null);
        graphics.dispose();
        return resizedImage;
    }
}

