/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.redwoods.block;

import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.coderbot.redwoods.world.WorldGenConifer;
import net.coderbot.redwoods.world.WorldGenMegaConifer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.terraingen.TerrainGen;

@ParametersAreNonnullByDefault
public class BlockConiferSapling
extends BlockBush
implements IGrowable {
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)1);
    protected static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.8, 0.9);
    private WorldGenConifer generator;
    private WorldGenMegaConifer generatorMega;

    public BlockConiferSapling(TreeDefinition tree) {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.0f);
        this.generator = new WorldGenConifer(true, tree.wood, tree.leaves);
        this.generatorMega = new WorldGenMegaConifer(true, tree.woodSW, tree.woodNW, tree.woodNE, tree.woodSE, tree.leaves);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            super.func_180650_b(worldIn, pos, state, rand);
            if (!worldIn.func_175697_a(pos, 1)) {
                return;
            }
            if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(7) == 0) {
                this.grow(worldIn, pos, state, rand);
            }
        }
    }

    public void grow(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if ((Integer)state.func_177229_b((IProperty)STAGE) == 0) {
            worldIn.func_180501_a(pos, state.func_177231_a((IProperty)STAGE), 4);
        } else {
            this.generateTree(worldIn, pos, state, rand);
        }
    }

    public void generateTree(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int dZ;
        if (!TerrainGen.saplingGrowTree((World)worldIn, (Random)rand, (BlockPos)pos)) {
            return;
        }
        int dX = 0;
        boolean mega = false;
        block0: for (dZ = 0; dZ >= -1; --dZ) {
            for (dX = 0; dX >= -1; --dX) {
                if (!this.isTwoByTwoOfType(worldIn, pos, dX, dZ)) continue;
                mega = true;
                break block0;
            }
        }
        if (!mega) {
            worldIn.func_175698_g(pos);
            if (!this.generator.func_180709_b(worldIn, rand, pos)) {
                worldIn.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(1)));
            }
        } else {
            BlockPos sapling;
            IBlockState[][] oldStates = new IBlockState[2][2];
            BlockPos generatePos = pos.func_177982_a(dX, 0, dZ);
            for (dZ = 0; dZ < 2; ++dZ) {
                for (dX = 0; dX < 2; ++dX) {
                    sapling = generatePos.func_177982_a(dX, 0, dZ);
                    oldStates[dZ][dX] = worldIn.func_180495_p(sapling);
                    worldIn.func_175698_g(sapling);
                }
            }
            if (!this.generatorMega.func_180709_b(worldIn, rand, generatePos)) {
                for (dZ = 0; dZ < 2; ++dZ) {
                    for (dX = 0; dX < 2; ++dX) {
                        sapling = generatePos.func_177982_a(dX, 0, dZ);
                        worldIn.func_175656_a(sapling, oldStates[dZ][dX]);
                    }
                }
            }
        }
    }

    private boolean isTwoByTwoOfType(World worldIn, BlockPos pos, int dX, int dZ) {
        return this.isTypeAt(worldIn, pos.func_177982_a(dX, 0, dZ)) && this.isTypeAt(worldIn, pos.func_177982_a(dX + 1, 0, dZ)) && this.isTypeAt(worldIn, pos.func_177982_a(dX, 0, dZ + 1)) && this.isTypeAt(worldIn, pos.func_177982_a(dX + 1, 0, dZ + 1));
    }

    private boolean isTypeAt(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_177230_c() == this;
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return (double)worldIn.field_73012_v.nextFloat() < 0.45;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        this.grow(worldIn, pos, state, rand);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf((meta & 8) >> 3));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)STAGE) << 3;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STAGE});
    }

    public static class TreeDefinition {
        public IBlockState wood;
        public IBlockState woodSW;
        public IBlockState woodNW;
        public IBlockState woodNE;
        public IBlockState woodSE;
        public IBlockState leaves;
    }
}

