/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.redwoods.block;

import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@MethodsReturnNonnullByDefault
public class BlockQuarterLog
extends BlockLog {
    public static final PropertyEnum<BarkSide> BARK_SIDE = PropertyEnum.func_177709_a((String)"bark_side", BarkSide.class);

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return MapColor.field_151654_J;
    }

    public IBlockState func_176203_a(int meta) {
        BarkSide side;
        BlockLog.EnumAxis axis;
        switch (meta >> 2) {
            case 0: {
                axis = BlockLog.EnumAxis.X;
                break;
            }
            case 1: {
                axis = BlockLog.EnumAxis.Y;
                break;
            }
            case 2: {
                axis = BlockLog.EnumAxis.Z;
                break;
            }
            default: {
                axis = BlockLog.EnumAxis.NONE;
            }
        }
        switch (meta & 3) {
            case 0: {
                side = BarkSide.SOUTHWEST;
                break;
            }
            case 1: {
                side = BarkSide.NORTHWEST;
                break;
            }
            case 2: {
                side = BarkSide.NORTHEAST;
                break;
            }
            default: {
                side = BarkSide.SOUTHEAST;
            }
        }
        return this.func_176223_P().func_177226_a((IProperty)field_176299_a, (Comparable)axis).func_177226_a(BARK_SIDE, (Comparable)((Object)side));
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockLog.EnumAxis)state.func_177229_b((IProperty)field_176299_a)).ordinal() << 2 | ((BarkSide)((Object)state.func_177229_b(BARK_SIDE))).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176299_a, BARK_SIDE});
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        BarkSide side = BarkSide.fromHit(BlockLog.EnumAxis.func_176870_a((EnumFacing.Axis)facing.func_176740_k()), hitX, hitY, hitZ);
        return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a(BARK_SIDE, (Comparable)((Object)side));
    }

    public static enum BarkSide implements IStringSerializable
    {
        SOUTHWEST("southwest"),
        NORTHWEST("northwest"),
        NORTHEAST("northeast"),
        SOUTHEAST("southeast");

        final String name;

        private BarkSide(String name) {
            this.name = name;
        }

        public static BarkSide fromHit(BlockLog.EnumAxis axis, float hitX, float hitY, float hitZ) {
            boolean hitSouth;
            boolean hitEast;
            switch (axis) {
                case Y: {
                    hitEast = (double)hitX >= 0.5;
                    hitSouth = (double)hitZ >= 0.5;
                    break;
                }
                case X: {
                    hitEast = (double)hitY <= 0.5;
                    hitSouth = (double)hitZ >= 0.5;
                    break;
                }
                default: {
                    hitEast = (double)hitX >= 0.5;
                    hitSouth = (double)hitY >= 0.5;
                }
            }
            return BarkSide.fromHalves(!hitEast, !hitSouth);
        }

        public static BarkSide fromHalves(boolean east, boolean south) {
            if (east) {
                if (south) {
                    return SOUTHEAST;
                }
                return NORTHEAST;
            }
            if (south) {
                return SOUTHWEST;
            }
            return NORTHWEST;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

