/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.redwoods.world;

import java.util.Random;
import net.coderbot.redwoods.block.BlockConiferLeaves;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class WorldGenMegaConifer
extends WorldGenAbstractTree {
    private IBlockState woodSW;
    private IBlockState woodNW;
    private IBlockState woodNE;
    private IBlockState woodSE;
    private IBlockState leaves;
    private boolean doBlockNotify;
    private static final int EXTRA_LEAVES_HEIGHT = 2;

    public WorldGenMegaConifer(boolean notify, IBlockState woodSW, IBlockState woodNW, IBlockState woodNE, IBlockState woodSE, IBlockState leaves) {
        super(notify);
        this.doBlockNotify = notify;
        this.woodSW = woodSW;
        this.woodNW = woodNW;
        this.woodNE = woodNE;
        this.woodSE = woodSE;
        this.leaves = leaves;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos origin) {
        BlockPos below;
        int dX;
        int dZ;
        int height = rand.nextInt(16) + 32;
        int bareTrunkHeight = 1 + rand.nextInt(12);
        int maxRadius = 2 + rand.nextInt(6);
        if (origin.func_177956_o() + height + 1 + 2 > world.func_72800_K() || origin.func_177956_o() < 1) {
            return false;
        }
        for (dZ = 0; dZ < 2; ++dZ) {
            for (dX = 0; dX < 2; ++dX) {
                below = origin.func_177982_a(dX, -1, dZ);
                IBlockState soil = world.func_180495_p(below);
                if (soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)world, below, EnumFacing.UP, (IPlantable)Blocks.field_150345_g)) continue;
                return false;
            }
        }
        if (!this.checkForObstructions(world, origin, height, bareTrunkHeight, maxRadius)) {
            return false;
        }
        for (dZ = 0; dZ < 2; ++dZ) {
            for (dX = 0; dX < 2; ++dX) {
                below = origin.func_177982_a(dX, -1, dZ);
                this.func_175903_a(world, below, Blocks.field_150346_d.func_176223_P());
            }
        }
        boolean oldAllowLeavesDecay = BlockConiferLeaves.allowLeavesDecay;
        if (!this.doBlockNotify) {
            BlockConiferLeaves.allowLeavesDecay = false;
        }
        this.growLeaves(world, origin, height, bareTrunkHeight, maxRadius);
        this.growTrunk(world, origin, height);
        if (!this.doBlockNotify) {
            BlockConiferLeaves.allowLeavesDecay = oldAllowLeavesDecay;
        }
        return true;
    }

    private boolean checkForObstructions(World world, BlockPos origin, int height, int bareTrunkHeight, int radius) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(origin);
        for (int i = 0; i < bareTrunkHeight; ++i) {
            boolean canReplaceAll;
            boolean bl = canReplaceAll = WorldGenMegaConifer.canReplaceBlock(world, world.func_180495_p((BlockPos)pos.func_181079_c(origin.func_177958_n(), origin.func_177956_o() + i, origin.func_177952_p())), (BlockPos)pos) && WorldGenMegaConifer.canReplaceBlock(world, world.func_180495_p((BlockPos)pos.func_181079_c(origin.func_177958_n() + 1, origin.func_177956_o() + i, origin.func_177952_p())), (BlockPos)pos) && WorldGenMegaConifer.canReplaceBlock(world, world.func_180495_p((BlockPos)pos.func_181079_c(origin.func_177958_n(), origin.func_177956_o() + i, origin.func_177952_p() + 1)), (BlockPos)pos) && WorldGenMegaConifer.canReplaceBlock(world, world.func_180495_p((BlockPos)pos.func_181079_c(origin.func_177958_n() + 1, origin.func_177956_o() + i, origin.func_177952_p() + 1)), (BlockPos)pos);
            if (canReplaceAll) continue;
            return false;
        }
        for (int dY = bareTrunkHeight; dY < height + 2; ++dY) {
            for (int dZ = -radius; dZ <= radius + 1; ++dZ) {
                for (int dX = -radius; dX <= radius + 1; ++dX) {
                    pos.func_181079_c(origin.func_177958_n() + dX, origin.func_177956_o() + dY, origin.func_177952_p() + dZ);
                    IBlockState state = world.func_180495_p((BlockPos)pos);
                    if (WorldGenMegaConifer.canReplaceBlock(world, state, (BlockPos)pos)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void growLeaves(World world, BlockPos origin, int height, int bareTrunkHeight, int maxRadius) {
        int radius = 0;
        int radiusTarget = 1;
        boolean topCone = true;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(origin);
        for (int dY = height + 2; dY >= bareTrunkHeight; --dY) {
            for (int dZ = -radius; dZ <= radius + 1; ++dZ) {
                for (int dX = -radius; dX <= radius + 1; ++dX) {
                    if (!(radius <= 0 || dZ != -radius && dZ != radius + 1 || dX != -radius && dX != radius + 1)) continue;
                    pos.func_181079_c(origin.func_177958_n() + dX, origin.func_177956_o() + dY, origin.func_177952_p() + dZ);
                    IBlockState existing = world.func_180495_p((BlockPos)pos);
                    if (!existing.func_177230_c().canBeReplacedByLeaves(existing, (IBlockAccess)world, (BlockPos)pos)) continue;
                    this.func_175903_a(world, (BlockPos)pos, this.leaves);
                }
            }
            if (++radius <= radiusTarget) continue;
            if (topCone) {
                radius = 0;
                radiusTarget = Math.min(2, maxRadius);
                topCone = false;
                continue;
            }
            radius = 1;
            radiusTarget = Math.min(radiusTarget + 1, maxRadius);
        }
    }

    private void growTrunk(World world, BlockPos origin, int height) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(origin);
        for (int i = 0; i < height; ++i) {
            this.func_175903_a(world, (BlockPos)pos.func_181079_c(origin.func_177958_n(), origin.func_177956_o() + i, origin.func_177952_p()), this.woodNW);
            this.func_175903_a(world, (BlockPos)pos.func_181079_c(origin.func_177958_n() + 1, origin.func_177956_o() + i, origin.func_177952_p()), this.woodNE);
            this.func_175903_a(world, (BlockPos)pos.func_181079_c(origin.func_177958_n(), origin.func_177956_o() + i, origin.func_177952_p() + 1), this.woodSW);
            this.func_175903_a(world, (BlockPos)pos.func_181079_c(origin.func_177958_n() + 1, origin.func_177956_o() + i, origin.func_177952_p() + 1), this.woodSE);
        }
    }

    private static boolean canReplaceBlock(World world, IBlockState state, BlockPos pos) {
        Block block = state.func_177230_c();
        if (block.isAir(state, (IBlockAccess)world, pos) || block.isLeaves(state, (IBlockAccess)world, pos) || block.isWood((IBlockAccess)world, pos)) {
            return true;
        }
        Material material = state.func_185904_a();
        if (material == Material.field_151579_a || material == Material.field_151584_j) {
            return true;
        }
        return block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150364_r || block == Blocks.field_150363_s || block == Blocks.field_150345_g || block == Blocks.field_150395_bd;
    }

    protected void func_175903_a(World worldIn, BlockPos pos, IBlockState state) {
        if (this.doBlockNotify) {
            worldIn.func_180501_a(pos, state, 3);
        } else {
            worldIn.func_180501_a(pos, state, 18);
        }
    }
}

