/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.blocks;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockMagma;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pegbeard.dungeontactics.blocks.DTBlockGeneric;
import pegbeard.dungeontactics.blocks.DTFlamerBlock;
import pegbeard.dungeontactics.blocks.DTFlower;
import pegbeard.dungeontactics.blocks.tileentities.DTFlamerTile;
import pegbeard.dungeontactics.handlers.DTBlocks;
import pegbeard.dungeontactics.handlers.DTEffects;
import pegbeard.dungeontactics.handlers.DTItems;

public class DTCauldron
extends DTBlockGeneric {
    public static final PropertyInteger WATERLEVEL = PropertyInteger.func_177719_a((String)"waterlevel", (int)0, (int)3);
    public static final PropertyInteger LAVALEVEL = PropertyInteger.func_177719_a((String)"lavalevel", (int)0, (int)3);
    protected static final AxisAlignedBB AABB_LEGS = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0);
    protected static final AxisAlignedBB AABB_WALL_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    protected static final AxisAlignedBB AABB_WALL_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_WALL_EAST = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_WALL_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);

    public DTCauldron(String name, Material material, float hardness, float resistance) {
        super(name, material, hardness, resistance, MapColor.field_151665_m);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)WATERLEVEL, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)LAVALEVEL, (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185852_e);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean isActualState) {
        DTCauldron.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_LEGS);
        DTCauldron.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_WEST);
        DTCauldron.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_NORTH);
        DTCauldron.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_EAST);
        DTCauldron.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_SOUTH);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_149738_a(World world) {
        return 30;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        this.spawnParticles(world, pos, rand);
    }

    private void spawnParticles(World world, BlockPos pos, Random rand) {
        if (DTCauldron.getWaterLevel(world.func_180495_p(pos)) > 0 && DTCauldron.getHeatSource(world, pos.func_177977_b())) {
            float f1 = 0.5f;
            float f2 = 0.6543f;
            if (DTCauldron.getWaterLevel(world.func_180495_p(pos)) == 2) {
                f2 += 0.13f;
            }
            if (DTCauldron.getWaterLevel(world.func_180495_p(pos)) == 3) {
                f2 += 0.16f;
            }
            for (int i = 0; i < 3; ++i) {
                float r1 = rand.nextFloat() - rand.nextFloat();
                float r2 = Float.valueOf(MathHelper.func_76131_a((float)r1, (float)-0.3f, (float)0.3f)).floatValue();
                double d1 = (double)((float)pos.func_177958_n() + f1) + (double)r2;
                double d2 = (float)pos.func_177956_o() + f2;
                double d3 = (double)((float)pos.func_177952_p() + f1) + (double)r2;
                world.func_175688_a(EnumParticleTypes.WATER_SPLASH, d1, d2, d3, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        int w = DTCauldron.getWaterLevel(state);
        float f = (float)pos.func_177956_o() + (6.0f + (float)(3 * w)) / 16.0f;
        int l = this.getLavaLevel(state);
        float b = (float)pos.func_177956_o() + (6.0f + (float)(3 * l)) / 16.0f;
        if (entity instanceof EntityLivingBase) {
            if (!world.field_72995_K && entity.func_70027_ad() && w > 0 && l == 0 && entity.func_174813_aQ().field_72338_b <= (double)f) {
                entity.func_70066_B();
                DTCauldron.setWaterLevel(world, pos, state, w - 1);
            }
            if (!world.field_72995_K && !entity.func_70027_ad() && l > 0 && w == 0 && entity.func_174813_aQ().field_72338_b <= (double)b) {
                entity.func_70015_d(9);
                DTCauldron.setLavaLevel(world, pos, state, l - 1);
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemArmor itemarmor;
        int w = DTCauldron.getWaterLevel(state);
        int l = this.getLavaLevel(state);
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_190926_b()) {
            if (w > 0 && l > 0 && !world.field_72995_K) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)WATERLEVEL, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)0, (int)0, (int)3))).func_177226_a((IProperty)LAVALEVEL, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)0, (int)0, (int)3))), 2);
                EntityItem obsidian = new EntityItem(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), new ItemStack(Item.func_150898_a((Block)Blocks.field_150343_Z)));
                world.func_72838_d((Entity)obsidian);
            }
            return true;
        }
        Item item = stack.func_77973_b();
        if (item == Items.field_151131_as) {
            if (w < 3 && !world.field_72995_K) {
                if (!player.field_71075_bZ.field_75098_d) {
                    player.func_184611_a(hand, new ItemStack(Items.field_151133_ar));
                }
                player.func_71029_a(StatList.field_188077_K);
                DTCauldron.setWaterLevel(world, pos, state, 3);
                world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return true;
        }
        if (item == Items.field_151129_at) {
            if (l < 3 && !world.field_72995_K) {
                if (!player.field_71075_bZ.field_75098_d) {
                    player.func_184611_a(hand, new ItemStack(Items.field_151133_ar));
                }
                player.func_71029_a(StatList.field_188077_K);
                DTCauldron.setLavaLevel(world, pos, state, 3);
                world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return true;
        }
        if (item == Items.field_151133_ar) {
            if (w > 0 && l > 0) {
                return true;
            }
            if (w == 3 && !world.field_72995_K) {
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                    if (stack.func_190926_b()) {
                        player.func_184611_a(hand, new ItemStack(Items.field_151131_as));
                    } else if (!player.field_71071_by.func_70441_a(new ItemStack(Items.field_151131_as))) {
                        player.func_71019_a(new ItemStack(Items.field_151131_as), false);
                    }
                }
                player.func_71029_a(StatList.field_188078_L);
                DTCauldron.setWaterLevel(world, pos, state, 0);
                world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else if (l == 3 && !world.field_72995_K) {
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                    if (stack.func_190926_b()) {
                        player.func_184611_a(hand, new ItemStack(Items.field_151129_at));
                    } else if (!player.field_71071_by.func_70441_a(new ItemStack(Items.field_151129_at))) {
                        player.func_71019_a(new ItemStack(Items.field_151129_at), false);
                    }
                }
                player.func_71029_a(StatList.field_188078_L);
                DTCauldron.setLavaLevel(world, pos, state, 0);
                world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return true;
        }
        if (item == Items.field_151069_bo) {
            if (w > 0 && !world.field_72995_K) {
                if (!player.field_71075_bZ.field_75098_d) {
                    ItemStack itemstack3 = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b);
                    player.func_71029_a(StatList.field_188078_L);
                    stack.func_190918_g(1);
                    if (stack.func_190926_b()) {
                        player.func_184611_a(hand, itemstack3);
                    } else if (!player.field_71071_by.func_70441_a(itemstack3)) {
                        player.func_71019_a(itemstack3, false);
                    } else if (player instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
                    }
                }
                world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187615_H, SoundCategory.BLOCKS, 1.0f, 1.0f);
                DTCauldron.setWaterLevel(world, pos, state, w - 1);
            }
            return true;
        }
        if (item == Items.field_151068_bn && PotionUtils.func_185191_c((ItemStack)stack) == PotionTypes.field_185230_b) {
            if (w < 3 && !world.field_72995_K) {
                if (!player.field_71075_bZ.field_75098_d) {
                    ItemStack itemstack2 = new ItemStack(Items.field_151069_bo);
                    player.func_71029_a(StatList.field_188078_L);
                    player.func_184611_a(hand, itemstack2);
                    if (player instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
                    }
                }
                world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_191241_J, SoundCategory.BLOCKS, 1.0f, 1.0f);
                DTCauldron.setWaterLevel(world, pos, state, w + 1);
            }
            return true;
        }
        if (w > 0 && item instanceof ItemArmor && (itemarmor = (ItemArmor)item).func_82812_d() == ItemArmor.ArmorMaterial.LEATHER && itemarmor.func_82816_b_(stack) && !world.field_72995_K) {
            itemarmor.func_82815_c(stack);
            DTCauldron.setWaterLevel(world, pos, state, w - 1);
            player.func_71029_a(StatList.field_188079_M);
            return true;
        }
        if (w > 0 && item instanceof ItemBanner) {
            if (TileEntityBanner.func_175113_c((ItemStack)stack) > 0 && !world.field_72995_K) {
                ItemStack itemstack1 = stack.func_77946_l();
                itemstack1.func_190920_e(1);
                TileEntityBanner.func_175117_e((ItemStack)itemstack1);
                player.func_71029_a(StatList.field_188080_N);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                    DTCauldron.setWaterLevel(world, pos, state, w - 1);
                }
                if (stack.func_190926_b()) {
                    player.func_184611_a(hand, itemstack1);
                } else if (!player.field_71071_by.func_70441_a(itemstack1)) {
                    player.func_71019_a(itemstack1, false);
                } else if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
                }
            }
            return true;
        }
        if (stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemAxe) {
            int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185304_p, (ItemStack)stack);
            if (DTCauldron.getHeatSource(world, pos.func_177977_b()) && DTCauldron.imbue(world, player, stack, state, pos, fortune)) {
                return true;
            }
        }
        if (stack.func_77973_b() instanceof ItemSpade) {
            int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
            if (DTCauldron.getHeatSource(world, pos.func_177977_b()) && DTCauldron.cook(world, player, stack, state, pos, fortune)) {
                return true;
            }
        }
        return false;
    }

    public static int getWaterLevel(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)WATERLEVEL);
    }

    public static void setWaterLevel(World world, BlockPos pos, IBlockState state, int level) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)WATERLEVEL, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)level, (int)0, (int)3))), 2);
        world.func_175666_e(pos, state.func_177230_c());
    }

    public int getLavaLevel(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LAVALEVEL);
    }

    public static void setLavaLevel(World world, BlockPos pos, IBlockState state, int level) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)LAVALEVEL, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)level, (int)0, (int)3))), 2);
        world.func_175666_e(pos, state.func_177230_c());
    }

    public void func_176224_k(World world, BlockPos pos) {
        if (world.field_73012_v.nextInt(20) == 1) {
            IBlockState iblockstate;
            float f = world.func_180494_b(pos).func_180626_a(pos);
            if (world.func_72959_q().func_76939_a(f, pos.func_177956_o()) >= 0.15f && (Integer)(iblockstate = world.func_180495_p(pos)).func_177229_b((IProperty)WATERLEVEL) < 3 && (Integer)iblockstate.func_177229_b((IProperty)LAVALEVEL) == 0) {
                world.func_180501_a(pos, iblockstate.func_177231_a((IProperty)WATERLEVEL), 2);
            }
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        int w = DTCauldron.getWaterLevel(state);
        int l = this.getLavaLevel(state);
        if (w > 0) {
            return w;
        }
        if (l > 0) {
            return l;
        }
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)WATERLEVEL, (Comparable)Integer.valueOf(meta & 3)).func_177226_a((IProperty)LAVALEVEL, (Comparable)Integer.valueOf((meta & 0xF) >> 2));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((Integer)state.func_177229_b((IProperty)WATERLEVEL)).intValue();
        return i |= (Integer)state.func_177229_b((IProperty)LAVALEVEL) << 2;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{WATERLEVEL, LAVALEVEL});
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.UP) {
            return BlockFaceShape.BOWL;
        }
        return face == EnumFacing.DOWN ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
    }

    public static boolean cook(World world, EntityPlayer player, ItemStack spoon, IBlockState state, BlockPos pos, int fortune) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)pos.func_177956_o() + 1.3, (double)(pos.func_177952_p() + 1));
        List list = world.func_72872_a(EntityItem.class, axisalignedbb);
        ItemStack base = ItemStack.field_190927_a;
        int i = 4;
        ItemStack catalyst = ItemStack.field_190927_a;
        int j = 4;
        ItemStack additional = ItemStack.field_190927_a;
        int k = 1;
        ItemStack result = ItemStack.field_190927_a;
        int l = 1;
        ItemStack byproduct = ItemStack.field_190927_a;
        boolean m = true;
        if (spoon.func_77973_b() instanceof ItemSpade) {
            EntityItem drop;
            if (DTCauldron.getWaterLevel(state) > 0 && DTCauldron.getHeatSource(world, pos.func_177977_b())) {
                if (!list.isEmpty()) {
                    for (EntityItem ingrediant : list) {
                        if (ingrediant.func_92059_d().func_77973_b() == DTItems.CHERRYBOMB && ingrediant.func_92059_d().func_190916_E() >= 4) {
                            base = ingrediant.func_92059_d();
                            i = 4;
                            for (EntityItem ingrediant2 : list) {
                                if (ingrediant2.func_92059_d().func_77973_b() == Items.field_151137_ax && ingrediant2.func_92059_d().func_190916_E() >= 4) {
                                    catalyst = ingrediant2.func_92059_d();
                                    j = 4;
                                }
                                if (ingrediant2.func_92059_d().func_77973_b() != Items.field_151145_ak || ingrediant2.func_92059_d().func_190916_E() < 1) continue;
                                additional = ingrediant2.func_92059_d();
                                k = 1;
                            }
                        }
                        if (!(base.func_190926_b() || base.func_77973_b() != DTItems.CHERRYBOMB || catalyst.func_190926_b() || catalyst.func_77973_b() != Items.field_151137_ax || additional.func_190926_b() || additional.func_77973_b() != Items.field_151145_ak)) {
                            result = new ItemStack(Items.field_151016_H, 1 + fortune);
                            break;
                        }
                        if (ingrediant.func_92059_d().func_77973_b() == DTItems.GLOWCURRENT && ingrediant.func_92059_d().func_190916_E() >= 4) {
                            base = ingrediant.func_92059_d();
                            i = 4;
                            for (EntityItem ingrediant2 : list) {
                                if (ingrediant2.func_92059_d().func_77973_b() == Items.field_151137_ax && ingrediant2.func_92059_d().func_190916_E() >= 4) {
                                    catalyst = ingrediant2.func_92059_d();
                                    j = 4;
                                }
                                if (ingrediant2.func_92059_d().func_77973_b() != Items.field_151065_br || ingrediant2.func_92059_d().func_190916_E() < 1) continue;
                                additional = ingrediant2.func_92059_d();
                                k = 1;
                            }
                        }
                        if (!(base.func_190926_b() || base.func_77973_b() != DTItems.GLOWCURRENT || catalyst.func_190926_b() || catalyst.func_77973_b() != Items.field_151137_ax || additional.func_190926_b() || additional.func_77973_b() != Items.field_151065_br)) {
                            result = new ItemStack(Items.field_151114_aO, 1 + fortune);
                            break;
                        }
                        if (ingrediant.func_92059_d().func_77973_b() == DTItems.INCINDIBERRY && ingrediant.func_92059_d().func_190916_E() >= 4) {
                            base = ingrediant.func_92059_d();
                            i = 4;
                            for (EntityItem ingrediant2 : list) {
                                if (ingrediant2.func_92059_d().func_77973_b() == Items.field_151137_ax && ingrediant2.func_92059_d().func_190916_E() >= 4) {
                                    catalyst = ingrediant2.func_92059_d();
                                    j = 4;
                                }
                                if (ingrediant2.func_92059_d().func_77973_b() != Items.field_151044_h || ingrediant2.func_92059_d().func_190916_E() < 1) continue;
                                additional = ingrediant2.func_92059_d();
                                k = 1;
                            }
                        }
                        if (!(base.func_190926_b() || base.func_77973_b() != DTItems.INCINDIBERRY || catalyst.func_190926_b() || catalyst.func_77973_b() != Items.field_151137_ax || additional.func_190926_b() || additional.func_77973_b() != Items.field_151044_h)) {
                            result = new ItemStack(Items.field_151065_br, 1 + fortune);
                            break;
                        }
                        if (ingrediant.func_92059_d().func_77973_b() == Items.field_151114_aO && ingrediant.func_92059_d().func_190916_E() >= 1) {
                            base = ingrediant.func_92059_d();
                            i = 1;
                            for (EntityItem ingrediant2 : list) {
                                if (ingrediant2.func_92059_d().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150337_Q) && ingrediant2.func_92059_d().func_190916_E() >= 1) {
                                    catalyst = ingrediant2.func_92059_d();
                                    j = 1;
                                }
                                if (ingrediant2.func_92059_d().func_77973_b() != Item.func_150898_a((Block)Blocks.field_150338_P) || ingrediant2.func_92059_d().func_190916_E() < 1) continue;
                                additional = ingrediant2.func_92059_d();
                                k = 1;
                            }
                        }
                        if (!(base.func_190926_b() || base.func_77973_b() != Items.field_151114_aO || catalyst.func_190926_b() || catalyst.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150337_Q) || additional.func_190926_b() || additional.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150338_P))) {
                            result = new ItemStack(DTItems.MAGIC_POWDER, 1 + world.field_73012_v.nextInt(3) + fortune);
                            break;
                        }
                        if (ingrediant.func_92059_d().func_77973_b() == Items.field_151123_aH && ingrediant.func_92059_d().func_190916_E() >= 3) {
                            base = ingrediant.func_92059_d();
                            i = 3;
                            for (EntityItem ingrediant2 : list) {
                                if (ingrediant2.func_92059_d().func_77973_b() != Item.func_150898_a((Block)Blocks.field_150354_m) || ingrediant2.func_92059_d().func_190916_E() < 1) continue;
                                catalyst = ingrediant2.func_92059_d();
                                j = 1;
                            }
                        }
                        if (!base.func_190926_b() && base.func_77973_b() == Items.field_151123_aH && !catalyst.func_190926_b() && catalyst.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150354_m) && additional.func_190926_b()) {
                            result = new ItemStack(Items.field_151119_aD, 4 + fortune);
                            break;
                        }
                        if (ingrediant.func_92059_d().func_77973_b() == Items.field_151078_bh && ingrediant.func_92059_d().func_190916_E() >= 3) {
                            base = ingrediant.func_92059_d();
                            i = 3;
                            for (EntityItem ingrediant2 : list) {
                                if (ingrediant2.func_92059_d().func_77973_b() != Items.field_151102_aT || ingrediant2.func_92059_d().func_190916_E() < 2) continue;
                                catalyst = ingrediant2.func_92059_d();
                                j = 2;
                            }
                        }
                        if (!base.func_190926_b() && base.func_77973_b() == Items.field_151078_bh && !catalyst.func_190926_b() && catalyst.func_77973_b() == Items.field_151102_aT && additional.func_190926_b()) {
                            result = new ItemStack(Items.field_151116_aA, 1 + fortune);
                            byproduct = new ItemStack(Items.field_151123_aH, 1 + fortune);
                            break;
                        }
                        if (ingrediant.func_92059_d().func_77973_b() == Items.field_151119_aD && ingrediant.func_92059_d().func_190916_E() >= 1) {
                            base = ingrediant.func_92059_d();
                            i = 1;
                            for (EntityItem ingrediant2 : list) {
                                if ((ingrediant2.func_92059_d().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150362_t) || ingrediant2.func_92059_d().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150361_u)) && ingrediant2.func_92059_d().func_190916_E() >= 2) {
                                    catalyst = ingrediant2.func_92059_d();
                                    j = 2;
                                }
                                if (ingrediant2.func_92059_d().func_77973_b() != Item.func_150898_a((Block)Blocks.field_150354_m) || ingrediant2.func_92059_d().func_190916_E() < 1) continue;
                                additional = ingrediant2.func_92059_d();
                                k = 1;
                            }
                        }
                        if (!(base.func_190926_b() || base.func_77973_b() != Items.field_151119_aD || catalyst.func_190926_b() || catalyst.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150362_t) && catalyst.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150361_u) || additional.func_190926_b() || additional.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150354_m))) {
                            result = new ItemStack(Item.func_150898_a((Block)Blocks.field_150346_d), 1);
                            break;
                        }
                        if (ingrediant.func_92059_d().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150346_d) && ingrediant.func_92059_d().func_190916_E() >= 1) {
                            base = ingrediant.func_92059_d();
                            i = 1;
                            for (EntityItem ingrediant2 : list) {
                                if (ingrediant2.func_92059_d().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150337_Q) && ingrediant2.func_92059_d().func_190916_E() >= 2) {
                                    catalyst = ingrediant2.func_92059_d();
                                    j = 2;
                                }
                                if (ingrediant2.func_92059_d().func_77973_b() != Item.func_150898_a((Block)Blocks.field_150338_P) || ingrediant2.func_92059_d().func_190916_E() < 2) continue;
                                additional = ingrediant2.func_92059_d();
                                k = 2;
                            }
                        }
                        if (base.func_190926_b() || base.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150346_d) || catalyst.func_190926_b() || catalyst.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150337_Q) || additional.func_190926_b() || additional.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150338_P)) continue;
                        result = new ItemStack(Item.func_150898_a((Block)Blocks.field_150391_bh), 1);
                        break;
                    }
                }
                if (!result.func_190926_b()) {
                    if (!world.field_72995_K) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            DTCauldron.setWaterLevel(world, pos, state, DTCauldron.getWaterLevel(state) - l);
                            if (!base.func_190926_b()) {
                                base.func_190918_g(i);
                            }
                            if (!catalyst.func_190926_b()) {
                                catalyst.func_190918_g(j);
                            }
                            if (!additional.func_190926_b()) {
                                additional.func_190918_g(k);
                            }
                            spoon.func_77972_a(1, (EntityLivingBase)player);
                        }
                        drop = new EntityItem(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), result);
                        drop.func_174869_p();
                        world.func_72838_d((Entity)drop);
                        if (!byproduct.func_190926_b()) {
                            drop = new EntityItem(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), byproduct);
                            drop.func_174869_p();
                            world.func_72838_d((Entity)drop);
                        }
                        world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187547_bF, SoundCategory.BLOCKS, 0.3f, 1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.4f);
                    }
                    return true;
                }
            }
            if (DTCauldron.getWaterLevel(state) == 0 && DTCauldron.getHeatSource(world, pos.func_177977_b())) {
                if (!list.isEmpty()) {
                    for (EntityItem ingrediant : list) {
                        if (ingrediant.func_92059_d().func_77973_b() == DTItems.HEART_JAR && ingrediant.func_92059_d().func_190916_E() >= 1) {
                            base = ingrediant.func_92059_d();
                            i = 1;
                            for (EntityItem ingrediant2 : list) {
                                if (ingrediant2.func_92059_d().func_77973_b() == Items.field_151074_bl && ingrediant2.func_92059_d().func_190916_E() >= 2) {
                                    catalyst = ingrediant2.func_92059_d();
                                    j = 2;
                                }
                                if (ingrediant2.func_92059_d().func_77973_b() != Items.field_151114_aO || ingrediant2.func_92059_d().func_190916_E() < 2) continue;
                                additional = ingrediant2.func_92059_d();
                                k = 2;
                            }
                        }
                        if (base.func_190926_b() || base.func_77973_b() != DTItems.HEART_JAR || catalyst.func_190926_b() || catalyst.func_77973_b() != Items.field_151074_bl || additional.func_190926_b() || additional.func_77973_b() != Items.field_151114_aO) continue;
                        result = new ItemStack(DTItems.HEART_GOLDEN, 1);
                        break;
                    }
                }
                if (!result.func_190926_b()) {
                    if (!world.field_72995_K) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            if (!base.func_190926_b()) {
                                base.func_190918_g(i);
                            }
                            if (!catalyst.func_190926_b()) {
                                catalyst.func_190918_g(j);
                            }
                            if (!additional.func_190926_b()) {
                                additional.func_190918_g(k);
                            }
                            spoon.func_77972_a(1, (EntityLivingBase)player);
                        }
                        drop = new EntityItem(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), result);
                        drop.func_174869_p();
                        world.func_72838_d((Entity)drop);
                        if (!byproduct.func_190926_b()) {
                            drop = new EntityItem(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), byproduct);
                            drop.func_174869_p();
                            world.func_72838_d((Entity)drop);
                        }
                        world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.3f, 1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.4f);
                    }
                    return true;
                }
            }
            if (DTCauldron.getHeatSource(world, pos.func_177977_b()) && !list.isEmpty()) {
                for (EntityItem ingrediant : list) {
                    if (ingrediant.func_92059_d().func_77973_b() == DTItems.INCINDIBERRY && ingrediant.func_92059_d().func_190916_E() >= 7) {
                        base = ingrediant.func_92059_d();
                        i = 7;
                        for (EntityItem ingrediant2 : list) {
                            if (ingrediant2.func_92059_d().func_77973_b() != Item.func_150898_a((Block)Blocks.field_189877_df) || ingrediant2.func_92059_d().func_190916_E() < 1) continue;
                            catalyst = ingrediant2.func_92059_d();
                            j = 1;
                        }
                    }
                    if (base.func_190926_b() || base.func_77973_b() != DTItems.INCINDIBERRY || catalyst.func_190926_b() || catalyst.func_77973_b() != Item.func_150898_a((Block)Blocks.field_189877_df)) continue;
                    if (world.field_72995_K) break;
                    if (!player.field_71075_bZ.field_75098_d) {
                        if (!base.func_190926_b()) {
                            base.func_190918_g(i);
                        }
                        if (!catalyst.func_190926_b()) {
                            catalyst.func_190918_g(j);
                        }
                        if (!additional.func_190926_b()) {
                            additional.func_190918_g(k);
                        }
                        spoon.func_77972_a(1, (EntityLivingBase)player);
                    }
                    DTCauldron.setLavaLevel(world, pos, state, 3);
                    world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.3f, 1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.4f);
                    break;
                }
                return true;
            }
        }
        return false;
    }

    public static boolean imbue(World world, EntityPlayer player, ItemStack weapon, IBlockState state, BlockPos pos, int fortune) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)pos.func_177956_o() + 1.3, (double)(pos.func_177952_p() + 1));
        List list = world.func_72872_a(EntityItem.class, axisalignedbb);
        ItemStack base = ItemStack.field_190927_a;
        ItemStack catalyst = ItemStack.field_190927_a;
        int j = 4;
        if (DTCauldron.getWaterLevel(state) > 0 && DTCauldron.getHeatSource(world, pos.func_177977_b()) && !list.isEmpty()) {
            Block flower;
            for (EntityItem ingrediant : list) {
                base = weapon;
                for (EntityItem ingrediant2 : list) {
                    if (!(Block.func_149634_a((Item)ingrediant2.func_92059_d().func_77973_b()) instanceof DTFlower)) continue;
                    catalyst = ingrediant2.func_92059_d();
                }
                if (catalyst.func_190926_b() || !(Block.func_149634_a((Item)catalyst.func_77973_b()) instanceof DTFlower)) continue;
                break;
            }
            if ((flower = Block.func_149634_a((Item)catalyst.func_77973_b())) instanceof DTFlower) {
                if (weapon.func_77948_v()) {
                    boolean flag;
                    boolean bl = flag = EnchantmentHelper.func_77506_a((Enchantment)DTEffects.POISONSANGUINE, (ItemStack)weapon) > 0 && flower == DTBlocks.FLOWER_SANGUINE || EnchantmentHelper.func_77506_a((Enchantment)DTEffects.POISONBRAMBLE, (ItemStack)weapon) > 0 && flower == DTBlocks.FLOWER_BRAMBLE || EnchantmentHelper.func_77506_a((Enchantment)DTEffects.POISONBARK, (ItemStack)weapon) > 0 && flower == DTBlocks.FLOWER_BARK || EnchantmentHelper.func_77506_a((Enchantment)DTEffects.POISONCINDER, (ItemStack)weapon) > 0 && flower == DTBlocks.FLOWER_CINDER || EnchantmentHelper.func_77506_a((Enchantment)DTEffects.POISONTANGLE, (ItemStack)weapon) > 0 && flower == DTBlocks.FLOWER_TANGLE || EnchantmentHelper.func_77506_a((Enchantment)DTEffects.POISONAILMENT, (ItemStack)weapon) > 0 && flower == DTBlocks.FLOWER_AILMENT || EnchantmentHelper.func_77506_a((Enchantment)DTEffects.POISONFADE, (ItemStack)weapon) > 0 && flower == DTBlocks.FLOWER_FADE || EnchantmentHelper.func_77506_a((Enchantment)DTEffects.POISONFEATHER, (ItemStack)weapon) > 0 && flower == DTBlocks.FLOWER_FEATHER || flower == DTBlocks.FLOWER_XP;
                    if (flag) {
                        return false;
                    }
                }
                int level = world.field_73012_v.nextInt(1 + fortune);
                if (flower == DTBlocks.FLOWER_SANGUINE) {
                    weapon.func_77966_a(DTEffects.POISONSANGUINE, 1 + level);
                }
                if (flower == DTBlocks.FLOWER_BRAMBLE) {
                    weapon.func_77966_a(DTEffects.POISONBRAMBLE, 1 + level);
                }
                if (flower == DTBlocks.FLOWER_BARK) {
                    weapon.func_77966_a(DTEffects.POISONBARK, 1 + level);
                }
                if (flower == DTBlocks.FLOWER_CINDER) {
                    weapon.func_77966_a(DTEffects.POISONCINDER, 1 + level);
                }
                if (flower == DTBlocks.FLOWER_TANGLE) {
                    weapon.func_77966_a(DTEffects.POISONTANGLE, 1 + level);
                }
                if (flower == DTBlocks.FLOWER_AILMENT) {
                    weapon.func_77966_a(DTEffects.POISONAILMENT, 1 + level);
                }
                if (flower == DTBlocks.FLOWER_FADE) {
                    weapon.func_77966_a(DTEffects.POISONFADE, 1 + level);
                }
                if (flower == DTBlocks.FLOWER_FEATHER) {
                    weapon.func_77966_a(DTEffects.POISONFEATHER, 1 + level);
                }
                if (!world.field_72995_K) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        DTCauldron.setWaterLevel(world, pos, state, DTCauldron.getWaterLevel(state) - 1);
                        if (!catalyst.func_190926_b()) {
                            catalyst.func_190918_g(j);
                        }
                    }
                    world.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187547_bF, SoundCategory.BLOCKS, 0.3f, 1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.4f);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean getHeatSource(World world, BlockPos pos) {
        TileEntityFurnace furnace;
        IBlockState heatSource = world.func_180495_p(pos);
        if (heatSource.func_177230_c() instanceof BlockFire || heatSource.func_185904_a() == Material.field_151587_i || heatSource.func_177230_c() instanceof BlockMagma) {
            return true;
        }
        if (heatSource.func_177230_c() instanceof BlockFurnace && (furnace = (TileEntityFurnace)world.func_175625_s(pos)).func_145950_i()) {
            return true;
        }
        if (heatSource.func_177230_c() instanceof DTFlamerBlock) {
            DTFlamerTile flamer = (DTFlamerTile)world.func_175625_s(pos);
            if (heatSource.func_177229_b((IProperty)DTFlamerBlock.FACING) == EnumFacing.UP && flamer.getPowered()) {
                return true;
            }
        }
        return false;
    }
}

