/*
 * Decompiled with CFR 0.152.
 */
package pegbeard.dungeontactics.items;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import pegbeard.dungeontactics.handlers.DTCreativeTab;
import pegbeard.dungeontactics.handlers.client.DTKeyRegister;
import pegbeard.dungeontactics.proxy.network.DTMessageShieldBash;
import pegbeard.dungeontactics.proxy.network.DTShieldBashHandler;
import pegbeard.dungeontactics.proxy.network.NetworkHandler;

public class DTShield
extends ItemShield {
    protected final Item.ToolMaterial baseMaterial;

    public DTShield(String name, Item.ToolMaterial material) {
        this.setRegistryName("dungeontactics", name);
        this.func_77655_b(this.getRegistryName().toString());
        this.func_77637_a(DTCreativeTab.DT_WEAPONS_TAB);
        this.baseMaterial = material;
        this.func_77656_e(100 + material.func_77997_a());
        this.func_185043_a(new ResourceLocation("blocking"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public String func_77653_i(ItemStack stack) {
        return I18n.func_74838_a((String)(this.func_77657_g(stack) + ".name")).trim();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack mat = this.baseMaterial.getRepairItemStack();
        if (!mat.func_190926_b() && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public boolean isShield(ItemStack stack, @Nullable EntityLivingBase entity) {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        EntityPlayer player;
        if (world.field_72995_K && entity instanceof EntityPlayer && !(player = (EntityPlayer)entity).func_184592_cb().func_190926_b() && player.func_184592_cb().func_77973_b() instanceof DTShield) {
            KeyBinding[] keyBindings = DTKeyRegister.keyBindings;
            if (keyBindings[1].func_151468_f()) {
                EntityLivingBase target;
                Minecraft mc = FMLClientHandler.instance().getClient();
                if ((!player.func_184811_cZ().func_185141_a(stack.func_77973_b()) || player.field_71075_bZ.field_75098_d) && (target = (EntityLivingBase)DTShieldBashHandler.getMouseOver()) != null && target != player) {
                    DTShield.shieldBash(world, target, player, stack, this.getBashDamage());
                    NetworkHandler.INSTANCE.sendToServer((IMessage)new DTMessageShieldBash(target.func_145782_y(), this.getBashDamage()));
                }
            }
        }
    }

    public float getBashDamage() {
        return this.baseMaterial.func_78000_c();
    }

    public static void shieldBash(World world, EntityLivingBase target, EntityPlayer player, ItemStack stack, float bashDamage) {
        if (world.field_72995_K) {
            player.func_184609_a(EnumHand.OFF_HAND);
        }
        int i = 2;
        if (player.func_70660_b(MobEffects.field_76420_g) != null) {
            i += 1 + player.func_70660_b(MobEffects.field_76420_g).func_76458_c();
        }
        if (player.func_70051_ag()) {
            ++i;
        }
        float d = 2.0f + bashDamage;
        target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), d);
        target.func_70653_a((Entity)player, (float)i * 0.3f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
        player.field_70159_w *= 0.6;
        player.field_70179_y *= 0.6;
        player.func_70031_b(false);
        player.func_184602_cy();
        if (!player.field_71075_bZ.field_75098_d && !world.field_72995_K) {
            player.func_71020_j(0.3f);
            stack.func_77972_a(1, (EntityLivingBase)player);
            player.func_184811_cZ().func_185145_a(stack.func_77973_b(), 40);
        }
    }
}

