/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import xaero.deallocator.ByteBufferDeallocator;
import xaero.map.MapLimiter;
import xaero.map.MapProcessor;
import xaero.map.MapWriter;
import xaero.map.biome.MapBiomes;
import xaero.map.capabilities.ServerWorldCapabilities;
import xaero.map.controls.ControlsHandler;
import xaero.map.events.Events;
import xaero.map.events.FMLEvents;
import xaero.map.file.MapSaveLoad;
import xaero.map.file.PNGExporter;
import xaero.map.file.worldsave.WorldDataHandler;
import xaero.map.file.worldsave.WorldDataReader;
import xaero.map.graphics.TextureUploadBenchmark;
import xaero.map.graphics.TextureUploader;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.WaypointSymbolCreator;
import xaero.map.pool.MapTilePool;
import xaero.map.pool.TextureUploadPool;
import xaero.map.region.OverlayManager;
import xaero.map.settings.ModSettings;
import xaero.patreon.Patreon4;
import xaero.patreon.PatreonMod2;

@Mod(modid="xaeroworldmap", name="Xaero's World Map", version="1.5.6", clientSideOnly=true, acceptedMinecraftVersions="[1.12,1.12.2]")
public class WorldMap {
    @Mod.Instance(value="xaeroworldmap")
    public static WorldMap instance;
    public static final String versionID = "1.12_1.5.6";
    public static int newestUpdateID;
    public static boolean isOutdated;
    public static String fileLayout;
    public static String fileLayoutID;
    public static String latestVersion;
    public static Events events;
    public static FMLEvents fmlEvents;
    public static ControlsHandler ch;
    public static WaypointSymbolCreator waypointSymbolCreator;
    public static final ResourceLocation guiTextures;
    public static File oldOptionsFile;
    public static File oldSaveFolder;
    public static File oldSaveFolder2;
    public static ModSettings settings;
    public static int globalVersion;
    public static File modJAR;
    public static File configFolder;
    public static File optionsFile;
    public static File saveFolder;
    public static Thread mapProcessorThread;
    public static Thread mapWriterThread;

    public static PatreonMod2 getPatreon() {
        return Patreon4.mods.get(fileLayoutID);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) throws IOException {
        if (event.getSourceFile().getName().endsWith(".jar")) {
            modJAR = event.getSourceFile();
        }
        Path gameDir = new File("./").toPath().toAbsolutePath();
        configFolder = event.getModConfigurationDirectory();
        optionsFile = configFolder.toPath().resolve("xaeroworldmap.txt").toFile();
        saveFolder = gameDir.resolve("XaeroWorldMap").toFile();
        Path oldSaveFolder3 = configFolder.toPath().getParent().resolve("XaeroWorldMap");
        if (oldOptionsFile.exists() && !optionsFile.exists()) {
            Files.move(oldOptionsFile.toPath(), optionsFile.toPath(), new CopyOption[0]);
        }
        if (oldSaveFolder.exists() && !saveFolder.exists()) {
            Files.move(oldSaveFolder.toPath(), saveFolder.toPath(), new CopyOption[0]);
        }
        if (oldSaveFolder2.exists() && !saveFolder.exists()) {
            Files.move(oldSaveFolder2.toPath(), saveFolder.toPath(), new CopyOption[0]);
        }
        if (oldSaveFolder3.toFile().exists() && !saveFolder.exists()) {
            Files.move(oldSaveFolder3, saveFolder.toPath(), new CopyOption[0]);
        }
        if (!saveFolder.exists()) {
            Files.createDirectories(saveFolder.toPath(), new FileAttribute[0]);
        }
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) throws IOException, ClassNotFoundException, NoSuchMethodException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Patreon4.checkPatreon();
        Patreon4.rendersCapes = fileLayoutID;
        settings = new ModSettings();
        settings.loadSettings();
        this.checkModVersion();
        if (Patreon4.patronPledge >= 5 && isOutdated) {
            WorldMap.getPatreon().modJar = modJAR;
            WorldMap.getPatreon().currentVersion = versionID;
            WorldMap.getPatreon().latestVersion = latestVersion;
            Patreon4.addOutdatedMod(WorldMap.getPatreon());
        }
        waypointSymbolCreator = new WaypointSymbolCreator();
        ch = new ControlsHandler();
        events = new Events();
        fmlEvents = new FMLEvents();
        MinecraftForge.EVENT_BUS.register((Object)events);
        MinecraftForge.EVENT_BUS.register((Object)fmlEvents);
        ServerWorldCapabilities.registerCapabilities();
        ByteBufferDeallocator bufferDeallocator = new ByteBufferDeallocator();
        MapTilePool tilePool = new MapTilePool();
        OverlayManager overlayManager = new OverlayManager();
        PNGExporter pngExporter = new PNGExporter(configFolder.toPath().getParent().resolve("map exports"));
        MapSaveLoad mapSaveLoad = new MapSaveLoad(overlayManager, pngExporter);
        MapWriter mapWriter = new MapWriter(overlayManager);
        MapLimiter mapLimiter = new MapLimiter();
        TextureUploadPool.Normal normalTextureUploadPool = new TextureUploadPool.Normal(256);
        TextureUploadPool.NormalWithDownload normalWithDownloadTextureUploadPool = new TextureUploadPool.NormalWithDownload(256);
        TextureUploadPool.Compressed compressedTextureUploadPool = new TextureUploadPool.Compressed(256);
        TextureUploadBenchmark textureUploadBenchmark = new TextureUploadBenchmark(512, 512, 512);
        TextureUploader textureUploader = new TextureUploader(normalTextureUploadPool, normalWithDownloadTextureUploadPool, compressedTextureUploadPool, textureUploadBenchmark);
        WorldDataHandler worldDataHandler = new WorldDataHandler(new WorldDataReader(overlayManager));
        MapProcessor mapProcessor = new MapProcessor(mapSaveLoad, mapWriter, mapLimiter, bufferDeallocator, tilePool, overlayManager, textureUploader, worldDataHandler, new MapBiomes());
        mapProcessorThread = new Thread(mapProcessor);
        mapProcessorThread.start();
        mapWriterThread = new Thread(mapWriter);
        mapWriterThread.start();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        SupportMods.load();
    }

    public void checkModVersion() {
        String s = "http://data.chocolateminecraft.com/Versions/WorldMap.txt";
        s = s.replaceAll(" ", "%20");
        try {
            URL url = new URL(s);
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(900);
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String line = reader.readLine();
            if (line != null) {
                newestUpdateID = Integer.parseInt(line);
                if (!ModSettings.updateNotification || newestUpdateID == ModSettings.ignoreUpdate) {
                    isOutdated = false;
                    reader.close();
                    return;
                }
            }
            String[] current = versionID.split("_");
            while ((line = reader.readLine()) != null) {
                String[] args;
                if (line.equals(versionID)) {
                    isOutdated = false;
                    break;
                }
                if (Patreon4.patronPledge < 5 || !line.startsWith(current[0]) || current.length != 2 && !line.endsWith(current[2]) || (args = line.split("_")).length != current.length) continue;
                latestVersion = args[1];
            }
            reader.close();
        }
        catch (Exception e) {
            isOutdated = false;
        }
    }

    static {
        isOutdated = true;
        fileLayout = "XaerosWorldMap_&mod_Forge_&mc.jar";
        fileLayoutID = "worldmap";
        guiTextures = new ResourceLocation("xaeroworldmap", "gui/gui.png");
        oldOptionsFile = new File("./xaeroworldmap.txt");
        oldSaveFolder = new File("./mods/XaeroWorldMap");
        oldSaveFolder2 = new File("./config/XaeroWorldMap");
        globalVersion = 1;
        modJAR = null;
    }
}

