/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file;

import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import xaero.map.MapProcessor;
import xaero.map.file.MapRegionInfo;
import xaero.map.region.MapRegion;

public class RegionDetection
implements MapRegionInfo {
    private int initialVersion;
    private String world;
    private int regionX;
    private int regionZ;
    private boolean shouldCache;
    private File cacheFile;
    private File regionFile;

    public RegionDetection(String world, int regionX, int regionZ, File regionFile) {
        this.world = world;
        this.regionX = regionX;
        this.regionZ = regionZ;
        this.regionFile = regionFile;
        this.initialVersion = MapProcessor.instance.getGlobalVersion();
    }

    public int getInitialVersion() {
        return this.initialVersion;
    }

    @Override
    public boolean shouldCache() {
        return this.shouldCache;
    }

    @Override
    public File getCacheFile() {
        return this.cacheFile;
    }

    @Override
    public void setShouldCache(boolean shouldCache, String fsdfs) {
        this.shouldCache = shouldCache;
    }

    @Override
    public void setCacheFile(File cacheFile) {
        this.cacheFile = cacheFile;
    }

    @Override
    public String getWorld() {
        return this.world;
    }

    @Override
    public int getRegionX() {
        return this.regionX;
    }

    @Override
    public int getRegionZ() {
        return this.regionZ;
    }

    public void transferInfoTo(MapRegion to) {
        to.setShouldCache(this.shouldCache, "transfer");
        to.setCacheFile(this.cacheFile);
        to.setInitialVersion(this.initialVersion);
        to.setRegionFile(this.regionFile);
    }

    public void transferInfoFrom(MapRegion from) {
        this.shouldCache = from.shouldCache();
        this.cacheFile = from.getCacheFile();
        this.initialVersion = from.getInitialVersion();
        this.regionFile = from.getRegionFile();
    }

    public BufferedImage getRegionTexture() {
        try {
            return ImageIO.read(this.cacheFile);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public File getRegionFile() {
        return this.regionFile;
    }
}

