/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.file.MapRegionInfo;
import xaero.map.region.MapTileChunk;

public class MapRegion
implements Comparable<MapRegion>,
MapRegionInfo {
    public static final int SIDE_LENGTH = 8;
    private Boolean saveExists;
    private File regionFile;
    private boolean beingWritten;
    private long lastVisited;
    private long lastSaveTime = System.currentTimeMillis();
    private byte loadState;
    private int version = -1;
    private int initialVersion;
    private final boolean isMultiplayer;
    private String world;
    private String dim;
    private MapTileChunk[][] chunks = new MapTileChunk[8][8];
    private int regionX;
    private int regionZ;
    private boolean shouldCache;
    private boolean isRefreshing;
    private boolean allCachePrepared;
    private File cacheFile = null;
    public final Object writerThreadPauseSync = new Object();
    private int pauseWriting;
    private boolean recacheHasBeenRequested;
    private boolean reloadHasBeenRequested;
    private static int comparisonX = 0;
    private static int comparisonZ = 0;
    private int[] pixelResultBuffer = new int[4];
    private BlockPos.MutableBlockPos mutableGlobalPos = new BlockPos.MutableBlockPos();

    public MapRegion(String world, String dim, int x, int z) {
        this.world = world;
        this.regionX = x;
        this.regionZ = z;
        this.dim = dim;
        this.initialVersion = MapProcessor.instance.getGlobalVersion();
        this.isMultiplayer = MapProcessor.instance.isWorldMultiplayer(MapProcessor.instance.isWorldRealms(world), world);
    }

    public void destroyBufferUpdateObjects() {
        this.pixelResultBuffer = null;
        this.mutableGlobalPos = null;
    }

    public void restoreBufferUpdateObjects() {
        this.pixelResultBuffer = new int[4];
        this.mutableGlobalPos = new BlockPos.MutableBlockPos();
    }

    public void requestRefresh() {
        if (!this.isRefreshing) {
            this.isRefreshing = true;
            MapProcessor.instance.addToRefresh(this);
            if (WorldMap.settings.debug) {
                System.out.println(String.format("Requesting refresh for region %s.", this));
            }
        }
    }

    public void cancelRefresh() {
        if (this.isRefreshing) {
            this.isRefreshing = false;
            MapProcessor.instance.removeToRefresh(this);
            if (WorldMap.settings.debug) {
                System.out.println(String.format("Canceling refresh for region %s.", this));
            }
        }
    }

    public static void setComparison(EntityPlayer player) {
        MapRegion.setComparison((int)Math.floor(player.field_70165_t) >> 9, (int)Math.floor(player.field_70161_v) >> 9);
    }

    public static void setComparison(int x, int z) {
        comparisonX = x;
        comparisonZ = z;
    }

    @Override
    public int compareTo(MapRegion arg0) {
        int toRegion2;
        if (this.loadState < arg0.loadState) {
            return -1;
        }
        if (this.loadState > arg0.loadState) {
            return 1;
        }
        if (this.shouldCache && !arg0.shouldCache) {
            return 1;
        }
        if (arg0.shouldCache && !this.shouldCache) {
            return -1;
        }
        int toRegion = this.distanceFromPlayer();
        if (toRegion > (toRegion2 = arg0.distanceFromPlayer())) {
            return 1;
        }
        if (toRegion == toRegion2) {
            return 0;
        }
        return -1;
    }

    public int distanceFromPlayer() {
        int toRegionX = this.regionX - comparisonX;
        int toRegionZ = this.regionZ - comparisonZ;
        return (int)Math.sqrt(toRegionX * toRegionX + toRegionZ * toRegionZ);
    }

    public void deleteTexturesAndBuffers() {
        for (int i = 0; i < this.chunks.length; ++i) {
            for (int j = 0; j < this.chunks.length; ++j) {
                MapTileChunk c = this.chunks[i][j];
                if (c == null) continue;
                if (c.getGlColorTexture() != -1) {
                    MapProcessor.instance.requestTextureDeletion(c.getGlColorTexture());
                }
                if (c.getGlLightTexture() != -1) {
                    MapProcessor.instance.requestTextureDeletion(c.getGlLightTexture());
                }
                if (c.getColorBuffer() != null) {
                    c.deleteBuffers();
                }
                c.deletePBOs();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteBuffers() {
        MapRegion mapRegion = this;
        synchronized (mapRegion) {
            this.setAllCachePrepared(false);
        }
        for (int i = 0; i < this.chunks.length; ++i) {
            for (int j = 0; j < this.chunks.length; ++j) {
                MapTileChunk c = this.chunks[i][j];
                if (c == null || c.getColorBuffer() == null) continue;
                MapRegion mapRegion2 = this;
                synchronized (mapRegion2) {
                    this.setAllCachePrepared(false);
                    c.setCachePrepared(false);
                }
                c.setToUpload(false);
                c.deleteBuffers();
            }
        }
    }

    public void deleteGLBuffers() {
        for (int i = 0; i < this.chunks.length; ++i) {
            for (int j = 0; j < this.chunks.length; ++j) {
                MapTileChunk c = this.chunks[i][j];
                if (c == null) continue;
                c.deletePBOs();
            }
        }
    }

    public void clean() {
        for (int i = 0; i < this.chunks.length; ++i) {
            for (int j = 0; j < this.chunks.length; ++j) {
                MapTileChunk c = this.chunks[i][j];
                if (c == null) continue;
                c.clean();
                this.chunks[i][j] = null;
            }
        }
    }

    public void saveCacheTextures(File outputFile) throws IOException {
        if (WorldMap.settings.debug) {
            System.out.println("Saving cache: " + this.regionX + "_" + this.regionZ);
        }
        ZipOutputStream zipOutput = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
        DataOutputStream output = new DataOutputStream(zipOutput);
        ZipEntry e = new ZipEntry("cache.xaero");
        zipOutput.putNextEntry(e);
        byte[] usableBuffer = new byte[16384];
        byte[] integerByteBuffer = new byte[4];
        output.writeInt(5);
        for (int i = 0; i < this.chunks.length; ++i) {
            for (int j = 0; j < this.chunks.length; ++j) {
                MapTileChunk chunk = this.chunks[i][j];
                if (chunk == null) continue;
                if (!chunk.isCachePrepared()) {
                    throw new RuntimeException("Trying to save cache but " + chunk.getX() + " " + chunk.getZ() + " is not prepared.");
                }
                output.write(i << 4 | j);
                chunk.writeCacheData(output, usableBuffer, integerByteBuffer);
            }
        }
        zipOutput.closeEntry();
        output.close();
    }

    public void loadCacheTextures() {
        block13: {
            block14: {
                if (this.cacheFile == null) {
                    return;
                }
                if (!this.cacheFile.exists()) break block14;
                DataInputStream input = null;
                try {
                    MapRegion prevRegion = null;
                    boolean prevRegionChecked = false;
                    ZipInputStream zipInput = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.cacheFile)));
                    input = new DataInputStream(zipInput);
                    ZipEntry entry = zipInput.getNextEntry();
                    if (entry != null) {
                        byte[] integerByteBuffer = new byte[4];
                        int cacheSaveVersion = input.readInt();
                        if (cacheSaveVersion > 5) {
                            input.close();
                            System.out.println("Trying to load newer region cache " + this.regionX + "_" + this.regionZ + " using an older version of Xaero's World Map!");
                            MapProcessor.instance.getMapSaveLoad().backupFile(this.cacheFile, cacheSaveVersion);
                            this.cacheFile = null;
                            this.shouldCache = true;
                            return;
                        }
                        if (cacheSaveVersion < 5) {
                            this.shouldCache = true;
                        }
                        byte[] usableBuffer = new byte[16384];
                        int chunkCoords = input.read();
                        while (chunkCoords != -1) {
                            int x = chunkCoords >> 4;
                            int z = chunkCoords & 0xF;
                            MapTileChunk chunk = this.chunks[x][z];
                            if (chunk == null) {
                                this.chunks[x][z] = chunk = new MapTileChunk(this, this.regionX * 8 + x, this.regionZ * 8 + z);
                            }
                            chunk.readCacheData(cacheSaveVersion, input, usableBuffer, integerByteBuffer);
                            if (!this.shouldCache && z == 0 && chunk.getSuccessMask() != 15) {
                                MapTileChunk prevChunk;
                                if (!prevRegionChecked && prevRegion == null) {
                                    prevRegion = MapProcessor.instance.getMapRegion(this.regionX, this.regionZ - 1, false);
                                    prevRegionChecked = true;
                                }
                                if (prevRegion != null && (prevChunk = prevRegion.getChunk(x, 7)) != null && chunk.tileChunkShouldTriggerUpdate(prevChunk)) {
                                    this.shouldCache = true;
                                }
                            }
                            chunkCoords = input.read();
                        }
                        zipInput.closeEntry();
                    }
                    input.close();
                }
                catch (IOException ioe) {
                    this.cacheFile = null;
                    this.shouldCache = true;
                    System.out.println("Failed to load cache for region " + this + "! " + this.cacheFile);
                    ioe.printStackTrace();
                    if (input == null) break block13;
                    try {
                        input.close();
                        break block13;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                break block13;
            }
            this.cacheFile = null;
            this.shouldCache = true;
        }
    }

    public void onTopRegionLoaded(MapRegion topRegion) {
        if (this.version > 0) {
            for (int o = 0; o < 8; ++o) {
                MapTileChunk edgeBottomChunk;
                MapTileChunk edgeTopChunk = topRegion.getChunk(o, 7);
                if (edgeTopChunk == null || (edgeBottomChunk = this.chunks[o][0]) == null || !edgeBottomChunk.tileChunkShouldTriggerUpdate(edgeTopChunk)) continue;
                --this.version;
                break;
            }
        }
    }

    public void clearRegion() {
        this.setRecacheHasBeenRequested(false, "clearing");
        this.cancelRefresh();
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                MapTileChunk c = this.getChunk(i, j);
                if (c == null) continue;
                c.setLoadState((byte)3);
                this.setLoadState((byte)3);
                c.clean();
            }
        }
        if (!MapProcessor.instance.getMapSaveLoad().toCacheContains(this)) {
            this.deleteBuffers();
        }
        this.deleteGLBuffers();
        this.setLoadState((byte)4);
        if (WorldMap.settings.debug) {
            System.out.println("Cleared region! " + this + " " + this.getWorld() + " " + this.getRegionX() + "_" + this.getRegionZ());
        }
    }

    public boolean isResting() {
        return this.loadState != 3 && this.loadState != 1 && !this.recacheHasBeenRequested;
    }

    @Override
    public boolean shouldCache() {
        return this.shouldCache;
    }

    @Override
    public void setShouldCache(boolean shouldCache, String by) {
        this.shouldCache = shouldCache;
        if (WorldMap.settings.detailed_debug) {
            System.out.println("shouldCache set to " + shouldCache + " by " + by + " for " + this.regionX + "_" + this.regionZ);
        }
    }

    @Override
    public File getCacheFile() {
        return this.cacheFile;
    }

    @Override
    public void setCacheFile(File cacheFile) {
        this.cacheFile = cacheFile;
    }

    @Override
    public String getWorld() {
        return this.world;
    }

    @Override
    public int getRegionX() {
        return this.regionX;
    }

    @Override
    public int getRegionZ() {
        return this.regionZ;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
        if (WorldMap.settings.detailed_debug) {
            System.out.println("Version set to " + version + " by for " + this);
        }
    }

    public boolean isBeingWritten() {
        return this.beingWritten;
    }

    public void setBeingWritten(boolean beingWritten) {
        this.beingWritten = beingWritten;
    }

    public byte getLoadState() {
        return this.loadState;
    }

    public void setLoadState(byte loadState) {
        this.loadState = loadState;
    }

    public MapTileChunk getChunk(int x, int z) {
        return this.chunks[x][z];
    }

    public void setChunk(int x, int z, MapTileChunk chunk) {
        this.chunks[x][z] = chunk;
    }

    public int getInitialVersion() {
        return this.initialVersion;
    }

    public void setInitialVersion(int initialVersion) {
        this.initialVersion = initialVersion;
    }

    public String getDim() {
        return this.dim;
    }

    public int[] getPixelResultBuffer() {
        return this.pixelResultBuffer;
    }

    public BlockPos.MutableBlockPos getMutableGlobalPos() {
        return this.mutableGlobalPos;
    }

    @Override
    public File getRegionFile() {
        return this.regionFile;
    }

    public void setRegionFile(File loadedFromFile) {
        this.regionFile = loadedFromFile;
    }

    public Boolean getSaveExists() {
        return this.saveExists;
    }

    public void setSaveExists(Boolean saveExists) {
        this.saveExists = saveExists;
    }

    public long getLastSaveTime() {
        return this.lastSaveTime;
    }

    public void setLastSaveTime(long lastSaveTime) {
        this.lastSaveTime = lastSaveTime;
    }

    public boolean isAllCachePrepared() {
        return this.allCachePrepared;
    }

    public void setAllCachePrepared(boolean allCachePrepared) {
        if (this.allCachePrepared && !allCachePrepared && WorldMap.settings.detailed_debug) {
            System.out.println("Cancelling cache: " + this.getRegionX() + "_" + this.getRegionZ() + " " + this.getLoadState());
        }
        this.allCachePrepared = allCachePrepared;
    }

    public boolean isRefreshing() {
        return this.isRefreshing;
    }

    public void setRefreshing(boolean isRefreshing) {
        this.isRefreshing = isRefreshing;
    }

    public boolean isWritingPaused() {
        return this.pauseWriting > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushWriterPause() {
        Object object = this.writerThreadPauseSync;
        synchronized (object) {
            ++this.pauseWriting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popWriterPause() {
        Object object = this.writerThreadPauseSync;
        synchronized (object) {
            --this.pauseWriting;
        }
    }

    public boolean recacheHasBeenRequested() {
        return this.recacheHasBeenRequested;
    }

    public void setRecacheHasBeenRequested(boolean recacheHasBeenRequested, String by) {
        if (WorldMap.settings.detailed_debug && recacheHasBeenRequested != this.recacheHasBeenRequested) {
            System.out.println("Recache set to " + recacheHasBeenRequested + " by " + by + " for " + this.regionX + "_" + this.regionZ);
        }
        this.recacheHasBeenRequested = recacheHasBeenRequested;
    }

    public String toString() {
        return this.regionX + "_" + this.regionZ + " " + super.toString();
    }

    public boolean hasVersion() {
        return this.version != -1;
    }

    public boolean reloadHasBeenRequested() {
        return this.reloadHasBeenRequested;
    }

    public void setReloadHasBeenRequested(boolean reloadHasBeenRequested, String by) {
        if (WorldMap.settings.detailed_debug && reloadHasBeenRequested != this.reloadHasBeenRequested) {
            System.out.println("Reload set to " + reloadHasBeenRequested + " by " + by + " for " + this.regionX + "_" + this.regionZ);
        }
        this.reloadHasBeenRequested = reloadHasBeenRequested;
    }

    public boolean isMultiplayer() {
        return this.isMultiplayer;
    }

    public long getLastVisited() {
        return this.lastVisited;
    }

    public long getTimeSinceVisit() {
        return System.currentTimeMillis() - this.lastVisited;
    }

    public void registerVisit() {
        this.lastVisited = System.currentTimeMillis();
    }

    public int countChunks() {
        int count = 0;
        for (int i = 0; i < this.chunks.length; ++i) {
            for (int j = 0; j < this.chunks.length; ++j) {
                if (this.chunks[i][j] == null) continue;
                ++count;
            }
        }
        return count;
    }
}

