/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.cows;

import com.animania.Animania;
import com.animania.api.data.EntityGender;
import com.animania.api.interfaces.IImpregnable;
import com.animania.api.interfaces.IMateable;
import com.animania.common.ModSoundEvents;
import com.animania.common.entities.cows.EntityAnimaniaCow;
import com.animania.common.entities.cows.EntityBullBase;
import com.animania.common.entities.generic.GenericBehavior;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.compat.top.providers.entity.TOPInfoProviderMateable;
import com.animania.config.AnimaniaConfig;
import com.google.common.base.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;

public class EntityCowBase
extends EntityAnimaniaCow
implements TOPInfoProviderMateable,
IMateable,
IImpregnable {
    public int dryTimer;
    protected ItemStack milk = new ItemStack(Items.field_151117_aB);
    protected static final DataParameter<Boolean> PREGNANT = EntityDataManager.func_187226_a(EntityCowBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> HAS_KIDS = EntityDataManager.func_187226_a(EntityCowBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> FERTILE = EntityDataManager.func_187226_a(EntityCowBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> GESTATION_TIMER = EntityDataManager.func_187226_a(EntityCowBase.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Optional<UUID>> MATE_UNIQUE_ID = EntityDataManager.func_187226_a(EntityCowBase.class, (DataSerializer)DataSerializers.field_187203_m);

    public EntityCowBase(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.4f, 1.8f);
        this.field_70130_N = 1.4f;
        this.field_70131_O = 1.8f;
        this.field_70138_W = 1.1f;
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.2, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.mateable = true;
        this.gender = EntityGender.FEMALE;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PREGNANT, (Object)false);
        if (AnimaniaConfig.gameRules.cowsMilkableAtSpawn) {
            this.field_70180_af.func_187214_a(HAS_KIDS, (Object)true);
        } else {
            this.field_70180_af.func_187214_a(HAS_KIDS, (Object)false);
        }
        this.field_70180_af.func_187214_a(FERTILE, (Object)true);
        this.field_70180_af.func_187214_a(GESTATION_TIMER, (Object)(AnimaniaConfig.careAndFeeding.gestationTimer + this.field_70146_Z.nextInt(200)));
        this.field_70180_af.func_187214_a(MATE_UNIQUE_ID, (Object)Optional.absent());
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getSleeping()) {
            this.setSleeping(false);
            this.setSleepTimer(Float.valueOf(0.0f));
            this.func_70664_aZ();
        }
        boolean flag = false;
        if (this.func_70685_l(entityIn) && this.func_70032_d(entityIn) <= 2.0f) {
            flag = entityIn.func_70097_a((DamageSource)new EntityDamageSource("bull", (Entity)this), 2.0f);
            if (flag) {
                this.func_174815_a((EntityLivingBase)this, entityIn);
            }
            if (entityIn instanceof EntityPlayer) {
                ((EntityLivingBase)entityIn).func_70653_a((Entity)this, 0.0f, (this.field_70165_t - entityIn.field_70165_t) / 2.0, (this.field_70161_v - entityIn.field_70161_v) / 2.0);
            }
        }
        return flag;
    }

    public void func_146082_f(EntityPlayer player) {
        if (!this.getSleeping()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)18);
        }
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        GenericBehavior.initialSpawnFemale(this, EntityAnimaniaCow.class);
        return livingdata;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(18.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    @Override
    public DataParameter<Boolean> getFertileParam() {
        return FERTILE;
    }

    @Override
    public DataParameter<Boolean> getHasKidsParam() {
        return HAS_KIDS;
    }

    protected SoundEvent func_184639_G() {
        return GenericBehavior.getAmbientSound(this, ModSoundEvents.moo1, ModSoundEvents.moo3, ModSoundEvents.moo4, ModSoundEvents.moo4, ModSoundEvents.moo5, ModSoundEvents.moo6, ModSoundEvents.moo7, ModSoundEvents.moo8);
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return Animania.RANDOM.nextBoolean() ? ModSoundEvents.cowHurt1 : ModSoundEvents.cowHurt2;
    }

    protected SoundEvent func_184615_bR() {
        return Animania.RANDOM.nextBoolean() ? ModSoundEvents.cowDeath1 : ModSoundEvents.cowDeath2;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187566_ao, 0.1f, 1.0f);
    }

    @Override
    public void func_70636_d() {
        GenericBehavior.livingUpdateFemale(this, EntityBullBase.class);
        super.func_70636_d();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack filled;
        ItemStack stack = player.func_184586_b(hand);
        EntityPlayer entityplayer = player;
        if (!this.getFed() || !this.getWatered() || stack == ItemStack.field_190927_a || !AnimaniaHelper.isEmptyFluidContainer(stack) || !this.getHasKids()) return super.func_184645_a(player, hand);
        player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
        ItemStack one = stack.func_77946_l();
        one.func_190920_e(1);
        FluidActionResult result = this.func_95999_t().trim().toLowerCase().equals("purp") ? FluidUtil.tryFillContainer((ItemStack)one, (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)new ItemStack(Items.field_151129_at)), (int)1000, (EntityPlayer)player, (boolean)true) : FluidUtil.tryFillContainer((ItemStack)one, (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)this.milk.func_77946_l()), (int)1000, (EntityPlayer)player, (boolean)true);
        if (!result.success) {
            Item item = stack.func_77973_b();
            if (item == Items.field_151133_ar) {
                filled = this.milk.func_77946_l();
            } else {
                if (!Loader.isModLoaded((String)"ceramics") || item != Item.func_111206_d((String)"ceramics:clay_bucket")) return false;
                filled = new ItemStack(Item.func_111206_d((String)"ceramics:clay_bucket"), 1, 1);
            }
        } else {
            filled = result.result;
        }
        stack.func_190918_g(1);
        AnimaniaHelper.addItem(player, filled);
        this.setWatered(false);
        return true;
    }

    public EntityCowBase createChild(EntityAgeable ageable) {
        return null;
    }

    @Override
    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
        if (player.func_70093_af()) {
            if (this.getMateUniqueId() != null) {
                probeInfo.text(I18n.func_74838_a((String)"text.waila.mated"));
            }
            if (this.getHasKids()) {
                probeInfo.text(I18n.func_74838_a((String)"text.waila.milkable"));
            }
            if (this.getFertile() && !this.getPregnant()) {
                probeInfo.text(I18n.func_74838_a((String)"text.waila.fertile1"));
            }
            if (this.getPregnant()) {
                if (this.getGestation() > 1) {
                    int bob = this.getGestation();
                    probeInfo.text(I18n.func_74838_a((String)"text.waila.pregnant1") + " (" + bob + " " + I18n.func_74838_a((String)"text.waila.pregnant2") + ")");
                } else {
                    probeInfo.text(I18n.func_74838_a((String)"text.waila.pregnant1"));
                }
            }
        }
        TOPInfoProviderMateable.super.addProbeInfo(mode, probeInfo, player, world, entity, data);
    }

    @Override
    public DataParameter<Integer> getGestationParam() {
        return GESTATION_TIMER;
    }

    @Override
    public DataParameter<Boolean> getPregnantParam() {
        return PREGNANT;
    }

    @Override
    public int getDryTimer() {
        return this.dryTimer;
    }

    @Override
    public void setDryTimer(int i) {
        this.dryTimer = i;
    }

    @Override
    public DataParameter<Optional<UUID>> getMateUniqueIdParam() {
        return MATE_UNIQUE_ID;
    }
}

