/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.horses;

import com.animania.api.data.AnimalContainer;
import com.animania.api.data.EntityGender;
import com.animania.api.interfaces.AnimaniaType;
import com.animania.api.interfaces.IAnimaniaAnimalBase;
import com.animania.common.ModSoundEvents;
import com.animania.common.entities.generic.GenericBehavior;
import com.animania.common.entities.generic.ai.GenericAIFindFood;
import com.animania.common.entities.generic.ai.GenericAIFindSaltLick;
import com.animania.common.entities.generic.ai.GenericAIFindWater;
import com.animania.common.entities.generic.ai.GenericAIPanic;
import com.animania.common.entities.generic.ai.GenericAISleep;
import com.animania.common.entities.generic.ai.GenericAITempt;
import com.animania.common.entities.generic.ai.GenericAIWatchClosest;
import com.animania.common.entities.horses.EntityFoalBase;
import com.animania.common.entities.horses.HorseType;
import com.animania.common.entities.horses.ai.EntityAIFollowMateHorses;
import com.animania.common.entities.horses.ai.EntityAILookIdleHorses;
import com.animania.common.entities.horses.ai.EntityAIWanderHorses;
import com.animania.common.entities.horses.ai.EntityHorseEatGrass;
import com.animania.common.entities.props.EntityWagon;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.common.inventory.ContainerHorseCart;
import com.animania.common.items.ItemEntityEgg;
import com.animania.config.AnimaniaConfig;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAnimaniaHorse
extends EntityHorse
implements IAnimaniaAnimalBase {
    public static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])AnimaniaHelper.getItemArray(AnimaniaConfig.careAndFeeding.horseFood));
    protected static final DataParameter<Boolean> WATERED = EntityDataManager.func_187226_a(EntityAnimaniaHorse.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> FED = EntityDataManager.func_187226_a(EntityAnimaniaHorse.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> COLOR_NUM = EntityDataManager.func_187226_a(EntityAnimaniaHorse.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(EntityAnimaniaHorse.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> HANDFED = EntityDataManager.func_187226_a(EntityAnimaniaHorse.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(EntityAnimaniaHorse.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Float> SLEEPTIMER = EntityDataManager.func_187226_a(EntityAnimaniaHorse.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Boolean> INTERACTED = EntityDataManager.func_187226_a(EntityAnimaniaHorse.class, (DataSerializer)DataSerializers.field_187198_h);
    protected int happyTimer;
    public int blinkTimer;
    public int eatTimer;
    protected int fedTimer;
    protected int wateredTimer;
    protected int damageTimer;
    public EntityHorseEatGrass entityAIEatGrass;
    public HorseType horseType;
    protected boolean mateable = false;
    private ResourceLocation resourceLocation;
    private ResourceLocation resourceLocationBlink;
    protected EntityGender gender;
    protected ContainerHorseCart cartChest;
    protected Item dropRaw = Items.field_190931_a;
    protected Item dropCooked = Items.field_190931_a;

    public EntityAnimaniaHorse(World worldIn) {
        super(worldIn);
        this.field_70138_W = 1.2f;
        this.field_70714_bg.field_75782_a.clear();
        this.entityAIEatGrass = new EntityHorseEatGrass(this);
        if (!AnimaniaConfig.gameRules.ambianceMode) {
            this.field_70714_bg.func_75776_a(1, new GenericAIFindWater<EntityAnimaniaHorse>(this, 1.0, this.entityAIEatGrass, EntityAnimaniaHorse.class));
            this.field_70714_bg.func_75776_a(1, new GenericAIFindFood<EntityAnimaniaHorse>(this, 1.0, this.entityAIEatGrass, true));
        }
        this.field_70714_bg.func_75776_a(0, new GenericAIPanic<EntityAnimaniaHorse>(this, 2.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowMateHorses(this, 1.1));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWanderHorses((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, new GenericAITempt<EntityAnimaniaHorse>(this, 1.25, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.entityAIEatGrass);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new GenericAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdleHorses((EntityCreature)this));
        this.field_70714_bg.func_75776_a(9, new GenericAIFindSaltLick<EntityAnimaniaHorse>(this, 1.0, this.entityAIEatGrass));
        if (AnimaniaConfig.gameRules.animalsSleep) {
            this.field_70714_bg.func_75776_a(10, new GenericAISleep<EntityAnimaniaHorse>(this, 0.8, AnimaniaHelper.getBlock(AnimaniaConfig.careAndFeeding.horseBed), AnimaniaHelper.getBlock(AnimaniaConfig.careAndFeeding.horseBed2), EntityAnimaniaHorse.class));
        }
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.fedTimer = AnimaniaConfig.careAndFeeding.feedTimer + this.field_70146_Z.nextInt(100);
        this.wateredTimer = AnimaniaConfig.careAndFeeding.waterTimer + this.field_70146_Z.nextInt(100);
        this.happyTimer = 60;
        this.blinkTimer = 80 + this.field_70146_Z.nextInt(80);
        this.func_110163_bv();
        this.func_110226_cD();
    }

    protected void func_184651_r() {
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR_NUM, (Object)this.field_70146_Z.nextInt(6));
        this.field_70180_af.func_187214_a(FED, (Object)true);
        this.field_70180_af.func_187214_a(HANDFED, (Object)false);
        this.field_70180_af.func_187214_a(WATERED, (Object)true);
        this.field_70180_af.func_187214_a(SLEEPING, (Object)false);
        this.field_70180_af.func_187214_a(SLEEPTIMER, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(AGE, (Object)0);
        this.field_70180_af.func_187214_a(INTERACTED, (Object)false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2849999940395355);
    }

    public void func_70636_d() {
        GenericBehavior.livingUpdateCommon(this);
        super.func_70636_d();
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float f = 0.0f;
            float f1 = (float)((this.field_70128_L ? (double)0.01f : this.func_70042_X()) + passenger.func_70033_W());
            if (passenger instanceof EntityPlayer) {
                f1 = (float)((this.field_70128_L ? (double)0.01f : 1.6) + passenger.func_70033_W());
            }
            if (passenger instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)passenger;
                List<EntityWagon> wagons = AnimaniaHelper.getWagonsInRange(EntityWagon.class, 3.0, this.field_70170_p, (Entity)this);
                if (!wagons.isEmpty()) {
                    if (wagons.size() >= 0) {
                        for (int i = 0; i < wagons.size(); ++i) {
                            EntityWagon tempWagon = wagons.get(i);
                            if (tempWagon.pulled && tempWagon.puller == this) {
                                f = (float)((double)f + 1.82);
                                Vec3d vec3d = new Vec3d((double)f, 0.0, 0.0).func_178785_b(-tempWagon.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
                                passenger.func_70107_b(tempWagon.field_70165_t + vec3d.field_72450_a, tempWagon.field_70163_u + (double)f1, tempWagon.field_70161_v + vec3d.field_72449_c);
                                continue;
                            }
                            passenger.func_70107_b(this.field_70165_t, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), this.field_70161_v);
                        }
                    }
                } else {
                    f = (float)((double)f - 0.42);
                    Vec3d vec3d = new Vec3d((double)f, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
                    passenger.func_70107_b(this.field_70165_t, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), this.field_70161_v);
                }
            } else {
                passenger.func_70107_b(this.field_70165_t, this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), this.field_70161_v);
            }
        }
    }

    protected ResourceLocation func_184647_J() {
        return this instanceof EntityFoalBase ? null : new ResourceLocation("animania", "horse");
    }

    public boolean func_184776_b() {
        return true;
    }

    protected SoundEvent func_184639_G() {
        return GenericBehavior.getAmbientSound(this, ModSoundEvents.horseliving1, ModSoundEvents.horseliving2, ModSoundEvents.horseliving3, ModSoundEvents.horseliving4, ModSoundEvents.horseliving5, ModSoundEvents.horseliving6);
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return GenericBehavior.getRandomSound(ModSoundEvents.horsehurt1, ModSoundEvents.horsehurt2, ModSoundEvents.horsehurt3);
    }

    protected SoundEvent func_184615_bR() {
        return GenericBehavior.getRandomSound(ModSoundEvents.horsehurt1, ModSoundEvents.horsehurt2, ModSoundEvents.horsehurt3);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_110206_u(int jumpPowerIn) {
        if (jumpPowerIn < 0) {
            jumpPowerIn = 0;
        }
        this.field_110277_bt = jumpPowerIn >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPowerIn / 90.0f;
    }

    @Override
    public DataParameter<Boolean> getFedParam() {
        return FED;
    }

    @Override
    public DataParameter<Boolean> getHandFedParam() {
        return HANDFED;
    }

    @Override
    public DataParameter<Boolean> getWateredParam() {
        return WATERED;
    }

    @Override
    public DataParameter<Boolean> getSleepingParam() {
        return SLEEPING;
    }

    @Override
    public DataParameter<Float> getSleepTimerParam() {
        return SLEEPTIMER;
    }

    @Override
    public DataParameter<Integer> getAgeParam() {
        return AGE;
    }

    protected void func_70619_bc() {
        this.eatTimer = this.entityAIEatGrass.getEatingGrassTimer();
        super.func_70619_bc();
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null && !this.getSleeping()) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i() - 0.2f);
        }
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public int getColorNumber() {
        return this.getIntFromDataManager(COLOR_NUM);
    }

    public void setColorNumber(int color) {
        this.field_70180_af.func_187227_b(COLOR_NUM, (Object)color);
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public ResourceLocation getResourceLocationBlink() {
        return this.resourceLocationBlink;
    }

    public void func_191986_a(float p_191986_1_, float p_191986_2_, float p_191986_3_) {
        if (this.func_184207_aI() && this.func_82171_bF()) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)this.func_184179_bs();
            this.field_70126_B = this.field_70177_z = entitylivingbase.field_70177_z;
            this.field_70125_A = entitylivingbase.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70759_as = this.field_70761_aq = this.field_70177_z;
            p_191986_1_ = entitylivingbase.field_70702_br * 0.5f;
            p_191986_3_ = entitylivingbase.field_191988_bg * 4.0f;
            if (p_191986_3_ <= 0.0f) {
                p_191986_3_ *= 0.25f;
                this.field_110285_bP = 0;
            }
            if (this.field_70122_E && this.field_110277_bt == 0.0f && this.func_110209_cd()) {
                p_191986_1_ = 0.0f;
                p_191986_3_ = 0.0f;
            }
            if (this.field_110277_bt > 0.0f && !this.func_110246_bZ() && this.field_70122_E) {
                this.field_70181_x = this.func_110215_cj() * (double)this.field_110277_bt;
                if (this.func_70644_a(MobEffects.field_76430_j)) {
                    this.field_70181_x += (double)((float)(this.func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1) * 0.1f);
                }
                this.func_110255_k(true);
                this.field_70160_al = true;
                if (p_191986_3_ > 0.0f) {
                    float f = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    float f1 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    this.field_70159_w += (double)(-0.4f * f * this.field_110277_bt);
                    this.field_70179_y += (double)(0.4f * f1 * this.field_110277_bt);
                    this.func_184185_a(SoundEvents.field_187720_cs, 0.4f, 1.0f);
                }
                this.field_110277_bt = 0.0f;
            }
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (this.func_184186_bw() || this.func_110167_bD()) {
                this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                super.func_191986_a(p_191986_1_, p_191986_2_ / 8.0f, p_191986_3_);
            } else if (entitylivingbase instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            if (this.field_70122_E) {
                this.field_110277_bt = 0.0f;
                this.func_110255_k(false);
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
        } else {
            this.field_70747_aH = 0.02f;
            if (!this.func_184207_aI()) {
                p_191986_3_ = this.field_191988_bg;
            }
            super.func_191986_a(p_191986_1_, p_191986_2_, p_191986_3_);
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack != ItemStack.field_190927_a && stack.func_77973_b() == Items.field_151141_av && !this.func_110257_ck() && !this.getSleeping()) {
            ItemStack bob = stack.func_77946_l();
            this.field_110296_bG.func_70299_a(0, bob);
            this.func_110251_o(true);
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            this.func_110232_cE();
            return true;
        }
        if (stack == ItemStack.field_190927_a && this.func_110257_ck() && !this.func_184207_aI() && this.getWatered() && this.getFed() && !this.func_70631_g_() && !this.getSleeping()) {
            this.field_70699_by.func_75499_g();
            this.func_110237_h(player);
            return true;
        }
        return GenericBehavior.interactCommon(this, player, hand, this.entityAIEatGrass) ? true : super.func_184645_a(player, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.eatTimer = 80;
        } else {
            super.func_70103_a(id);
        }
    }

    public void removeItem(EntityPlayer ep, ItemStack removeitem) {
        InventoryPlayer inv = ep.field_71071_by;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack j;
            if (inv.func_70301_a(i) == null || (j = inv.func_70301_a(i)).func_77973_b() == null || j.func_77973_b() != removeitem.func_77973_b()) continue;
            inv.func_70299_a(i, null);
            break;
        }
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != null && this.isHorseBreedingItem(stack.func_77973_b());
    }

    private boolean isHorseBreedingItem(Item itemIn) {
        return TEMPTATION_ITEMS.contains(itemIn);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("ColorNumber", this.getColorNumber());
        GenericBehavior.writeCommonNBT(compound, this);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setColorNumber(compound.func_74762_e("ColorNumber"));
        GenericBehavior.readCommonNBT(compound, this);
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    @Override
    public Item getSpawnEgg() {
        return ItemEntityEgg.ANIMAL_EGGS.get(new AnimalContainer(this.horseType, this.gender));
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(this.getSpawnEgg());
    }

    @Override
    public int getPrimaryEggColor() {
        return 0;
    }

    @Override
    public int getSecondaryEggColor() {
        return 0;
    }

    @Override
    public EntityGender getEntityGender() {
        return this.gender;
    }

    @Override
    public void setSleepingPos(BlockPos pos) {
    }

    @Override
    public BlockPos getSleepingPos() {
        return null;
    }

    @Override
    public Set<Item> getFoodItems() {
        return TEMPTATION_ITEMS;
    }

    @Override
    public int getBlinkTimer() {
        return this.blinkTimer;
    }

    @Override
    public void setBlinkTimer(int i) {
        this.blinkTimer = i;
    }

    @Override
    public int getEatTimer() {
        return this.eatTimer;
    }

    @Override
    public void setEatTimer(int i) {
        this.eatTimer = i;
    }

    @Override
    public int getFedTimer() {
        return this.fedTimer;
    }

    @Override
    public void setFedTimer(int i) {
        this.fedTimer = i;
    }

    @Override
    public DataParameter<Boolean> getInteractedParam() {
        return INTERACTED;
    }

    @Override
    public int getWaterTimer() {
        return this.wateredTimer;
    }

    @Override
    public void setWaterTimer(int i) {
        this.wateredTimer = i;
    }

    @Override
    public int getDamageTimer() {
        return this.damageTimer;
    }

    @Override
    public void setDamageTimer(int i) {
        this.damageTimer = i;
    }

    @Override
    public int getHappyTimer() {
        return this.happyTimer;
    }

    @Override
    public void setHappyTimer(int i) {
        this.happyTimer = i;
    }

    @Override
    public AnimaniaType getAnimalType() {
        return this.horseType;
    }
}

