/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.entities.rodents;

import com.animania.Animania;
import com.animania.api.data.AnimalContainer;
import com.animania.api.data.EntityGender;
import com.animania.api.interfaces.AnimaniaType;
import com.animania.api.interfaces.IAnimaniaAnimalBase;
import com.animania.common.ModSoundEvents;
import com.animania.common.capabilities.CapabilityRefs;
import com.animania.common.capabilities.ICapabilityPlayer;
import com.animania.common.entities.generic.GenericBehavior;
import com.animania.common.entities.generic.ai.GenericAIFindFood;
import com.animania.common.entities.generic.ai.GenericAIFindWater;
import com.animania.common.entities.generic.ai.GenericAIFollowOwner;
import com.animania.common.entities.generic.ai.GenericAIPanic;
import com.animania.common.entities.generic.ai.GenericAISwimmingSmallCreatures;
import com.animania.common.entities.generic.ai.GenericAITempt;
import com.animania.common.entities.generic.ai.GenericAIWanderAvoidWater;
import com.animania.common.entities.generic.ai.GenericAIWatchClosest;
import com.animania.common.entities.rodents.HamsterType;
import com.animania.common.entities.rodents.ai.EntityAILookIdleRodent;
import com.animania.common.entities.rodents.ai.EntityAISleepHamsters;
import com.animania.common.handler.ItemHandler;
import com.animania.common.handler.PatreonHandler;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.common.items.ItemEntityEgg;
import com.animania.compat.top.providers.entity.TOPInfoProviderRodent;
import com.animania.config.AnimaniaConfig;
import com.animania.network.client.CapSyncPacket;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFleeSun;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityHamster
extends EntityTameable
implements TOPInfoProviderRodent,
IAnimaniaAnimalBase {
    private static final DataParameter<Boolean> IN_BALL = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> RIDING = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> COLOR_NUM = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> FOOD_STACK_COUNT = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> IN_LOVE = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> BALL_COLOR = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])AnimaniaHelper.getItemArray(AnimaniaConfig.careAndFeeding.hamsterFood));
    private static final DataParameter<Boolean> FED = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> WATERED = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Float> SLEEPTIMER = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Boolean> INTERACTED = EntityDataManager.func_187226_a(EntityHamster.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final String[] HAMSTER_TEXTURES = new String[]{"black", "brown", "darkbrown", "darkgray", "gray", "plum", "tarou", "white", "gold"};
    private int fedTimer;
    private int wateredTimer;
    private int happyTimer;
    private int tamedTimer;
    public int blinkTimer;
    private long rideCount;
    private int stackCount;
    private int eatCount;
    private int foodStackCount;
    private int standCount;
    private EntityItem targetFood;
    private boolean looksWithInterest;
    private boolean isStanding;
    private float field_25048_b;
    private float field_25054_c;
    private static List hamsterColorList;
    private EntityPlayer givemeEntity;
    private int breeding;
    private boolean mountFlag;
    private double yOffset;
    private ResourceLocation resourceLocation;
    private ResourceLocation resourceLocationBlink;
    private int damageTimer;

    public EntityHamster(World world) {
        super(world);
        this.func_70606_j(6.0f);
        this.yOffset = 0.1f;
        this.func_70105_a(0.5f, 0.3f);
        this.field_70130_N = 0.5f;
        this.field_70131_O = 0.3f;
        this.field_70138_W = 1.0f;
        this.fedTimer = AnimaniaConfig.careAndFeeding.feedTimer + this.field_70146_Z.nextInt(100);
        this.wateredTimer = AnimaniaConfig.careAndFeeding.waterTimer * 4 + this.field_70146_Z.nextInt(200);
        this.looksWithInterest = false;
        this.stackCount = 20;
        this.eatCount = 5000;
        this.standCount = 30;
        this.isStanding = false;
        this.breeding = 0;
        this.happyTimer = 60;
        this.tamedTimer = 120;
        this.blinkTimer = 70 + this.field_70146_Z.nextInt(70);
        this.func_110163_bv();
        this.initAI();
    }

    protected void initAI() {
        this.field_70714_bg.func_75776_a(1, new GenericAIPanic<EntityHamster>(this, 1.4));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new GenericAISwimmingSmallCreatures((EntityLiving)this));
        if (!AnimaniaConfig.gameRules.ambianceMode) {
            this.field_70714_bg.func_75776_a(3, new GenericAIFindWater<EntityHamster>(this, 1.0, null, EntityHamster.class, true));
            this.field_70714_bg.func_75776_a(3, new GenericAIFindFood<EntityHamster>(this, 1.0, null, false));
        }
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFleeSun((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new GenericAIWanderAvoidWater((EntityCreature)this, 1.1));
        this.field_70714_bg.func_75776_a(6, new GenericAITempt<EntityHamster>(this, 1.2, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(7, new GenericAIFollowOwner<EntityHamster>(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new GenericAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdleRodent((EntityAnimal)this));
        if (AnimaniaConfig.gameRules.animalsSleep) {
            this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAISleepHamsters((EntityCreature)this, 0.8));
        }
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    public int func_70646_bf() {
        return this.func_70906_o() ? 20 : super.func_70646_bf();
    }

    public void func_146082_f(EntityPlayer player) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)18);
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.3f);
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public ResourceLocation getResourceLocationBlink() {
        return this.resourceLocationBlink;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IN_BALL, (Object)false);
        this.field_70180_af.func_187214_a(COLOR_NUM, (Object)this.func_70681_au().nextInt(8));
        this.field_70180_af.func_187214_a(FOOD_STACK_COUNT, (Object)0);
        this.field_70180_af.func_187214_a(IN_LOVE, (Object)0);
        this.field_70180_af.func_187214_a(BALL_COLOR, (Object)0);
        this.field_70180_af.func_187214_a(FED, (Object)true);
        this.field_70180_af.func_187214_a(WATERED, (Object)true);
        this.field_70180_af.func_187214_a(RIDING, (Object)false);
        this.field_70180_af.func_187214_a(AGE, (Object)0);
        this.field_70180_af.func_187214_a(SLEEPING, (Object)false);
        this.field_70180_af.func_187214_a(SLEEPTIMER, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(INTERACTED, (Object)false);
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74757_a("IsSitting", this.func_70906_o());
        nbttagcompound.func_74757_a("InBall", this.isInBall());
        nbttagcompound.func_74768_a("ColorNumber", this.getColorNumber());
        nbttagcompound.func_74768_a("foodStackCount", this.getFoodStackCount());
        nbttagcompound.func_74768_a("BallColor", this.getBallColor());
        nbttagcompound.func_74757_a("IsTamed", this.func_70909_n());
        nbttagcompound.func_74757_a("IsRiding", this.getIsRiding());
        GenericBehavior.writeCommonNBT(nbttagcompound, this);
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.func_70904_g(nbttagcompound.func_74767_n("IsSitting"));
        this.setInBall(nbttagcompound.func_74767_n("InBall"));
        this.setColorNumber(nbttagcompound.func_74762_e("ColorNumber"));
        this.setFoodStackCount(nbttagcompound.func_74762_e("foodStackCount"));
        this.setBallColor(nbttagcompound.func_74762_e("BallColor"));
        this.func_70903_f(nbttagcompound.func_74767_n("IsTamed"));
        this.setIsRiding(nbttagcompound.func_74767_n("IsRiding"));
        GenericBehavior.readCommonNBT(nbttagcompound, this);
    }

    @Override
    public DataParameter<Integer> getAgeParam() {
        return AGE;
    }

    @Override
    public DataParameter<Boolean> getSleepingParam() {
        return SLEEPING;
    }

    @Override
    public DataParameter<Float> getSleepTimerParam() {
        return SLEEPTIMER;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    public double func_70033_W() {
        return this.yOffset;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ICapabilityPlayer props;
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.func_70877_b(itemstack) && !this.getSleeping()) {
            this.doPatreonCheck(player);
            this.setHamsterStanding(true);
            this.standCount = 100;
            this.addFoodStack();
        }
        if (itemstack == ItemStack.field_190927_a && this.func_70909_n() && player.func_70093_af() && !this.isInBall() && !this.getSleeping() && !(props = CapabilityRefs.getPlayerCaps(player)).isCarrying()) {
            props.setAnimal(this.func_189511_e(new NBTTagCompound()));
            props.setCarrying(true);
            props.setType("hamster");
            this.func_70106_y();
            player.func_184609_a(EnumHand.MAIN_HAND);
            Animania.network.sendToAllAround((IMessage)new CapSyncPacket(props, player.func_145782_y()), new NetworkRegistry.TargetPoint(player.field_70170_p.field_73011_w.getDimension(), (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), 64.0));
            return true;
        }
        if (!(itemstack.func_190926_b() || itemstack.func_77973_b() != ItemHandler.hamsterBallColored || this.isInBall() || this.getSleeping())) {
            if (this.func_70906_o()) {
                this.func_70904_g(false);
            }
            this.setInBall(true);
            int meta = itemstack.func_77960_j();
            this.setBallColor(meta);
            if (!player.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            return true;
        }
        if (!(itemstack.func_190926_b() || itemstack.func_77973_b() != ItemHandler.hamsterBallClear || this.isInBall() || this.getSleeping())) {
            if (this.func_70906_o()) {
                this.func_70904_g(false);
                this.func_70904_g(false);
            }
            this.setInBall(true);
            int meta = itemstack.func_77960_j();
            this.setBallColor(16);
            if (!player.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            return true;
        }
        if (itemstack.func_190926_b() && this.isInBall() && !this.getSleeping()) {
            int color = this.getBallColor();
            this.setInBall(false);
            if (!player.func_184812_l_()) {
                if (color == 16) {
                    AnimaniaHelper.addItem(player, new ItemStack(ItemHandler.hamsterBallClear));
                } else {
                    AnimaniaHelper.addItem(player, new ItemStack(ItemHandler.hamsterBallColored, 1, color));
                }
            }
            return true;
        }
        return GenericBehavior.interactCommon(this, player, hand, null) ? true : super.func_184645_a(player, hand);
    }

    public boolean canRiderInteract() {
        return true;
    }

    private boolean interactOthersTamed() {
        if (this.isHamsterStanding() || !this.func_70906_o()) {
            this.func_70904_g(true);
        } else if (this.func_70906_o()) {
            this.func_70904_g(false);
        }
        this.field_70703_bu = false;
        this.field_70699_by.func_75499_g();
        return true;
    }

    public void func_70691_i(float f) {
        super.func_70691_i(f);
        this.field_70172_ad = this.field_70771_an / 2;
    }

    public boolean func_70067_L() {
        if (this.func_184187_bx() != null && this.func_184187_bx() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)this.func_184187_bx();
            ItemStack itemstack = player.field_71071_by.func_70448_g();
            if (itemstack != null) {
                return false;
            }
        }
        return super.func_70067_L();
    }

    public boolean func_70094_T() {
        if (this.func_184187_bx() != null) {
            return false;
        }
        return super.func_70094_T();
    }

    protected void func_70664_aZ() {
        this.field_70181_x = 0.3;
    }

    public boolean func_184186_bw() {
        return false;
    }

    public void func_70636_d() {
        EntityLivingBase entity;
        GenericBehavior.livingUpdateCommon(this);
        this.setResourceLoc();
        super.func_70636_d();
        if (this.func_110143_aJ() < 10.0f) {
            this.eatFood();
            this.eatCount = 5000;
        }
        if (!(this.isHamsterStanding() || this.func_70906_o() || this.getSleeping())) {
            if (this.field_70146_Z.nextInt(20) == 0 && this.field_70146_Z.nextInt(20) == 0) {
                this.setHamsterStanding(true);
                this.standCount = 30;
                this.field_70699_by.func_75499_g();
                this.field_70703_bu = false;
            }
        } else if (this.isHamsterStanding() && this.standCount-- <= 0 && this.field_70146_Z.nextInt(10) == 0) {
            this.setHamsterStanding(false);
        }
        if (this.getFoodStackCount() > 0) {
            if (this.eatCount == 0) {
                if (this.field_70146_Z.nextInt(30) == 0 && this.field_70146_Z.nextInt(30) == 0) {
                    this.eatFood();
                    this.eatCount = 5000;
                }
            } else {
                --this.eatCount;
            }
        }
        this.looksWithInterest = false;
        if (!this.func_70781_l() && (entity = this.func_70638_az()) instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entity;
            ItemStack itemstack = entityplayer.field_71071_by.func_70448_g();
            if (itemstack != ItemStack.field_190927_a && itemstack.func_77973_b() == Items.field_151014_N) {
                this.looksWithInterest = true;
            }
        }
        if (this.func_70906_o() | this.isHamsterStanding() && this.func_70661_as() != null) {
            this.func_70661_as().func_75499_g();
        }
        if (this.tamedTimer > -1) {
            --this.tamedTimer;
            if (this.tamedTimer == 0) {
                this.tamedTimer = 120;
                if (this.func_70909_n() && AnimaniaConfig.gameRules.showUnhappyParticles && !this.func_184218_aH()) {
                    double d = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                }
            }
        }
    }

    @Override
    public DataParameter<Boolean> getWateredParam() {
        return WATERED;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_25054_c = this.field_25048_b;
        this.field_25048_b = this.looksWithInterest ? (this.field_25048_b += (1.0f - this.field_25048_b) * 0.4f) : (this.field_25048_b += (0.0f - this.field_25048_b) * 0.4f);
        if (this.looksWithInterest) {
            // empty if block
        }
        if (this.field_70146_Z.nextInt(10) == 5) {
            ++this.field_70173_aa;
        }
    }

    public float getInterestedAngle(float f) {
        return (this.field_25054_c + (this.field_25048_b - this.field_25054_c) * f) * 0.15f * 3.141593f;
    }

    @Nullable
    public UUID getHamsterOwner() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(EntityTameable.field_184756_bw)).orNull();
    }

    public void setHamsterOwner(@Nullable UUID uniqueId) {
        this.field_70180_af.func_187227_b(EntityTameable.field_184756_bw, (Object)Optional.fromNullable((Object)uniqueId));
    }

    public boolean isInBall() {
        return this.getBoolFromDataManager(IN_BALL);
    }

    public void setInBall(boolean ball) {
        if (ball) {
            this.func_184185_a(SoundEvents.field_187719_p, 0.3f, 1.6f);
            this.field_70180_af.func_187227_b(IN_BALL, (Object)true);
        } else {
            this.func_184185_a(SoundEvents.field_187719_p, 0.3f, 1.3f);
            this.field_70180_af.func_187227_b(IN_BALL, (Object)false);
        }
    }

    public int getBallColor() {
        return this.getIntFromDataManager(BALL_COLOR);
    }

    public void setBallColor(int color) {
        this.field_70180_af.func_187227_b(BALL_COLOR, (Object)color);
    }

    void showHeartsOrSmokeFX(String s, int i, boolean flag) {
        for (int j = 0; j < i; ++j) {
            double d = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            if (this.field_70146_Z.nextInt(2) > 0) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, ModSoundEvents.hamsterEat1, SoundCategory.PLAYERS, 0.6f, 0.8f);
                continue;
            }
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, ModSoundEvents.hamsterEat2, SoundCategory.PLAYERS, 0.6f, 0.8f);
        }
    }

    public boolean getIsRiding() {
        return this.getBoolFromDataManager(RIDING);
    }

    public void setIsRiding(boolean riding) {
        this.field_70180_af.func_187227_b(RIDING, (Object)riding);
    }

    public boolean isHamsterStanding() {
        return this.isStanding;
    }

    public void setHamsterStanding(boolean flag) {
        this.isStanding = flag;
    }

    protected void func_70628_a(boolean hit, int lootlevel) {
        if (this.isInBall()) {
            int color = this.getBallColor();
            if (color == 16) {
                this.func_70099_a(new ItemStack(ItemHandler.hamsterBallClear), 0.0f);
            } else {
                this.func_70099_a(new ItemStack(ItemHandler.hamsterBallColored, 1, color), 0.0f);
            }
        }
    }

    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("animania", "hamster");
    }

    public int getFoodStackCount() {
        return this.foodStackCount;
    }

    public void setFoodStackCount(int i) {
        this.foodStackCount = i;
    }

    public int getColorNumber() {
        try {
            return this.getIntFromDataManager(COLOR_NUM);
        }
        catch (Exception e) {
            return this.func_70681_au().nextInt(8);
        }
    }

    public void setColorNumber(int color) {
        this.field_70180_af.func_187227_b(COLOR_NUM, (Object)color);
    }

    private boolean addFoodStack() {
        if (this.foodStackCount != 5) {
            ++this.foodStackCount;
            return true;
        }
        this.func_70691_i(1.0f);
        return false;
    }

    private boolean eatFood() {
        if (this.foodStackCount != 0) {
            --this.foodStackCount;
            this.func_70691_i(1.0f);
            return true;
        }
        return false;
    }

    public EntityAgeable func_90011_a(EntityAgeable entityanimal) {
        return null;
    }

    public double func_70042_X() {
        return this.field_70131_O;
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return stack != ItemStack.field_190927_a && TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    protected SoundEvent func_184639_G() {
        return GenericBehavior.getAmbientSound(this, ModSoundEvents.hamsterLiving1, ModSoundEvents.hamsterLiving2, ModSoundEvents.hamsterLiving3);
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return ModSoundEvents.hamsterHurt1;
    }

    protected SoundEvent func_184615_bR() {
        return ModSoundEvents.hamsterHurt1;
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null && !this.getSleeping()) {
            this.func_184185_a(soundevent, this.func_70599_aP() - 0.2f, this.func_70647_i());
        }
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.02f, 1.8f);
    }

    private void doPatreonCheck(EntityPlayer player) {
        if (player.func_70093_af() && PatreonHandler.isPlayerPatreon(player)) {
            this.setColorNumber(8);
            this.resourceLocation = null;
        }
    }

    public void setResourceLoc() {
        if (this.getColorNumber() == 9) {
            this.setColorNumber(8);
        } else if (this.getColorNumber() > 9) {
            this.setColorNumber(0);
        }
        if (this.resourceLocation == null) {
            this.resourceLocation = new ResourceLocation("animania:textures/entity/rodents/hamster_" + HAMSTER_TEXTURES[this.getColorNumber()] + ".png");
            this.resourceLocationBlink = new ResourceLocation("animania:textures/entity/rodents/hamster_" + HAMSTER_TEXTURES[this.getColorNumber()] + "_blink.png");
        }
    }

    @Override
    public Item getSpawnEgg() {
        return ItemEntityEgg.ANIMAL_EGGS.get(new AnimalContainer(HamsterType.STANDARD, EntityGender.NONE));
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(this.getSpawnEgg());
    }

    @Override
    public int getPrimaryEggColor() {
        return 14603464;
    }

    @Override
    public int getSecondaryEggColor() {
        return 14317391;
    }

    @Override
    public EntityGender getEntityGender() {
        return EntityGender.NONE;
    }

    @Override
    public Set<Item> getFoodItems() {
        return TEMPTATION_ITEMS;
    }

    @Override
    public void setSleepingPos(BlockPos pos) {
    }

    @Override
    public BlockPos getSleepingPos() {
        return null;
    }

    @Override
    public int getBlinkTimer() {
        return this.blinkTimer;
    }

    @Override
    public void setBlinkTimer(int i) {
        this.blinkTimer = i;
    }

    @Override
    public int getEatTimer() {
        return 0;
    }

    @Override
    public void setEatTimer(int i) {
    }

    @Override
    public int getFedTimer() {
        return this.fedTimer;
    }

    @Override
    public void setFedTimer(int i) {
        this.fedTimer = i;
    }

    @Override
    public DataParameter<Boolean> getInteractedParam() {
        return INTERACTED;
    }

    @Override
    public int getWaterTimer() {
        return this.wateredTimer;
    }

    @Override
    public void setWaterTimer(int i) {
        this.wateredTimer = i;
    }

    @Override
    public int getDamageTimer() {
        return this.damageTimer;
    }

    @Override
    public void setDamageTimer(int i) {
        this.damageTimer = i;
    }

    @Override
    public int getHappyTimer() {
        return this.happyTimer;
    }

    @Override
    public void setHappyTimer(int i) {
        this.happyTimer = i;
    }

    @Override
    public AnimaniaType getAnimalType() {
        return HamsterType.STANDARD;
    }

    @Override
    public DataParameter<Boolean> getHandFedParam() {
        return null;
    }

    @Override
    public DataParameter<Boolean> getFedParam() {
        return FED;
    }
}

