package org.dimdev.ddutils.nbt;

import net.minecraft.nbt.*;

public final class NBTTestNBTWriter {

    public static void writeToNBT(org.dimdev.ddutils.nbt.NBTTest obj, NBTTagCompound nbt) {
        // Write field boolean a
        nbt.setBoolean("a", obj.a);

        // Write field byte b
        nbt.setByte("b", obj.b);

        // Write field short c
        nbt.setShort("c", obj.c);

        // Write field int d
        nbt.setInteger("d", obj.d);

        // Write field long e
        nbt.setLong("e", obj.e);

        // Write field char f
        nbt.setInteger("f", (int) obj.f);

        // Write field float g
        nbt.setFloat("g", obj.g);

        // Write field double h
        nbt.setDouble("h", obj.h);

        // Write field byte[] i
        nbt.setByteArray("i", obj.i);

        // Write field int[] j
        nbt.setIntArray("j", obj.j);

        // Write field boolean[] k
        NBTTagList tag = new NBTTagList();
        for (boolean element : obj.k) {
            NBTTagByte elementNBT = new NBTTagByte((byte) (element ? 1 : 0));
            tag.appendTag(elementNBT);
        }
        nbt.setTag("k", tag);

        // Write field byte[] l
        nbt.setByteArray("l", obj.l);

        // Write field short[] m
        NBTTagList tag1 = new NBTTagList();
        for (short element : obj.m) {
            NBTTagShort elementNBT = new NBTTagShort(element);
            tag1.appendTag(elementNBT);
        }
        nbt.setTag("m", tag1);

        // Write field int[] n
        nbt.setIntArray("n", obj.n);

        // Write field long[] o
        NBTTagList tag2 = new NBTTagList();
        for (long element : obj.o) {
            NBTTagLong elementNBT = new NBTTagLong(element);
            tag2.appendTag(elementNBT);
        }
        nbt.setTag("o", tag2);

        // Write field float[] p
        NBTTagList tag3 = new NBTTagList();
        for (float element : obj.p) {
            NBTTagFloat elementNBT = new NBTTagFloat(element);
            tag3.appendTag(elementNBT);
        }
        nbt.setTag("p", tag3);

        // Write field double[] q
        NBTTagList tag4 = new NBTTagList();
        for (double element : obj.q) {
            NBTTagDouble elementNBT = new NBTTagDouble(element);
            tag4.appendTag(elementNBT);
        }
        nbt.setTag("q", tag4);

        // Write field byte[][] r
        NBTTagList tag5 = new NBTTagList();
        for (byte[] element : obj.r) {
            NBTTagByteArray elementNBT = new NBTTagByteArray(element);
            tag5.appendTag(elementNBT);
        }
        nbt.setTag("r", tag5);

        // Write field int[][] s
        NBTTagList tag6 = new NBTTagList();
        for (int[] element : obj.s) {
            NBTTagIntArray elementNBT = new NBTTagIntArray(element);
            tag6.appendTag(elementNBT);
        }
        nbt.setTag("s", tag6);

        // Write field java.lang.String str
        nbt.setString("str", obj.str);

        // Write field net.minecraft.util.math.Vec3i vec3i
        if (obj.vec3i != null) {
            NBTTagCompound tag7 = new NBTTagCompound();
            tag7.setInteger("x", obj.vec3i.getX());
            tag7.setInteger("y", obj.vec3i.getY());
            tag7.setInteger("z", obj.vec3i.getZ());
            nbt.setTag("vec3i", tag7);
        }

        // Write field net.minecraft.util.math.BlockPos blockPos
        if (obj.blockPos != null) {
            NBTTagCompound tag8 = new NBTTagCompound();
            tag8.setInteger("x", obj.blockPos.getX());
            tag8.setInteger("y", obj.blockPos.getY());
            tag8.setInteger("z", obj.blockPos.getZ());
            nbt.setTag("blockPos", tag8);
        }

        // Write field org.dimdev.ddutils.Location location
        if (obj.location != null) {
            NBTTagCompound tag9 = new NBTTagCompound();
            tag9.setInteger("dim", obj.location.getDim());
            tag9.setInteger("x", obj.location.getX());
            tag9.setInteger("y", obj.location.getY());
            tag9.setInteger("z", obj.location.getZ());
            nbt.setTag("location", tag9);
        }

        // Write field java.lang.String[] strArr
        NBTTagList tag10 = new NBTTagList();
        for (java.lang.String element : obj.strArr) {
            NBTTagString elementNBT = new NBTTagString(element);
            tag10.appendTag(elementNBT);
        }
        nbt.setTag("strArr", tag10);

        // Write field java.lang.String[][] strArrArr
        NBTTagList tag11 = new NBTTagList();
        for (java.lang.String[] element : obj.strArrArr) {
            NBTTagList elementNBT = new NBTTagList();
            for (java.lang.String element1 : element) {
                NBTTagString elementNBT1 = new NBTTagString(element1);
                elementNBT.appendTag(elementNBT1);
            }
            tag11.appendTag(elementNBT);
        }
        nbt.setTag("strArrArr", tag11);

        // Write field org.dimdev.pocketlib.Pocket nbtStorable
        if (obj.nbtStorable != null) {
            if (obj.nbtStorable != null) nbt.setTag("nbtStorable", obj.nbtStorable.writeToNBT(new NBTTagCompound()));
        }

        // Write field java.util.List<java.lang.Integer> list
        if (obj.list != null) {
            NBTTagList tag12 = new NBTTagList();
            for (java.lang.Integer element : obj.list) {
                NBTTagInt elementNBT = new NBTTagInt(element);
                tag12.appendTag(elementNBT);
            }
            nbt.setTag("list", tag12);
        }

        // Write field java.util.Map<java.lang.String,java.lang.Integer> map
        if (obj.map != null) {
            NBTTagList tag13 = new NBTTagList();
            for (java.util.Map.Entry<java.lang.String,java.lang.Integer> element : obj.map.entrySet()) {
                NBTTagCompound elementNBT = new NBTTagCompound();
                NBTTagString key = new NBTTagString(element.getKey());
                elementNBT.setTag("key", key);
                NBTTagInt value = new NBTTagInt(element.getValue());
                elementNBT.setTag("value", value);
                tag13.appendTag(elementNBT);
            }
            nbt.setTag("map", tag13);
        }

        // Write field java.util.Map<java.util.Map<java.util.List<java.lang.String>,int[]>,java.util.Map<org.dimdev.pocketlib.Pocket,java.util.List<org.dimdev.pocketlib.Pocket>>> test2
        if (obj.test2 != null) {
            NBTTagList tag14 = new NBTTagList();
            for (java.util.Map.Entry<java.util.Map<java.util.List<java.lang.String>,int[]>,java.util.Map<org.dimdev.pocketlib.Pocket,java.util.List<org.dimdev.pocketlib.Pocket>>> element : obj.test2.entrySet()) {
                NBTTagCompound elementNBT = new NBTTagCompound();
                NBTTagList key = new NBTTagList();
                for (java.util.Map.Entry<java.util.List<java.lang.String>,int[]> element1 : element.getKey().entrySet()) {
                    NBTTagCompound elementNBT1 = new NBTTagCompound();
                    NBTTagList key1 = new NBTTagList();
                    for (java.lang.String element2 : element1.getKey()) {
                        NBTTagString elementNBT2 = new NBTTagString(element2);
                        key1.appendTag(elementNBT2);
                    }
                    elementNBT1.setTag("key1", key1);
                    NBTTagIntArray value = new NBTTagIntArray(element1.getValue());
                    elementNBT1.setTag("value", value);
                    key.appendTag(elementNBT1);
                }
                elementNBT.setTag("key", key);
                NBTTagList value = new NBTTagList();
                for (java.util.Map.Entry<org.dimdev.pocketlib.Pocket,java.util.List<org.dimdev.pocketlib.Pocket>> element1 : element.getValue().entrySet()) {
                    NBTTagCompound elementNBT1 = new NBTTagCompound();
                    NBTTagCompound key1 = element1.getKey().writeToNBT(new NBTTagCompound());
                    elementNBT1.setTag("key1", key1);
                    NBTTagList value1 = new NBTTagList();
                    for (org.dimdev.pocketlib.Pocket element2 : element1.getValue()) {
                        NBTTagCompound elementNBT2 = element2.writeToNBT(new NBTTagCompound());
                        value1.appendTag(elementNBT2);
                    }
                    elementNBT1.setTag("value1", value1);
                    value.appendTag(elementNBT1);
                }
                elementNBT.setTag("value", value);
                tag14.appendTag(elementNBT);
            }
            nbt.setTag("test2", tag14);
        }
    }

    @SuppressWarnings({"OverlyStrongTypeCast", "RedundantSuppression"})
    public static void readFromNBT(org.dimdev.ddutils.nbt.NBTTest obj, NBTTagCompound nbt) {
        // Read field boolean a
        obj.a = nbt.getBoolean("a");

        // Read field byte b
        obj.b = nbt.getByte("b");

        // Read field short c
        obj.c = nbt.getShort("c");

        // Read field int d
        obj.d = nbt.getInteger("d");

        // Read field long e
        obj.e = nbt.getLong("e");

        // Read field char f
        obj.f = (char) nbt.getInteger("f");

        // Read field float g
        obj.g = nbt.getFloat("g");

        // Read field double h
        obj.h = nbt.getDouble("h");

        // Read field byte[] i
        obj.i = nbt.getByteArray("i");

        // Read field int[] j
        obj.j = nbt.getIntArray("j");

        // Read field boolean[] k
        NBTBase tag = nbt.getTag("k");
        boolean[] arr = new boolean[((NBTTagList) tag).tagCount()];
        int i = 0;
        for (NBTBase elementNBT : (NBTTagList) tag) {
            boolean element = ((NBTTagByte) elementNBT).getByte() == 1;
            arr[i++] = element;
        }
        obj.k = arr;

        // Read field byte[] l
        obj.l = nbt.getByteArray("l");

        // Read field short[] m
        NBTBase tag1 = nbt.getTag("m");
        short[] arr1 = new short[((NBTTagList) tag1).tagCount()];
        int i1 = 0;
        for (NBTBase elementNBT : (NBTTagList) tag1) {
            short element = ((NBTTagShort) elementNBT).getShort();
            arr1[i1++] = element;
        }
        obj.m = arr1;

        // Read field int[] n
        obj.n = nbt.getIntArray("n");

        // Read field long[] o
        NBTBase tag2 = nbt.getTag("o");
        long[] arr2 = new long[((NBTTagList) tag2).tagCount()];
        int i2 = 0;
        for (NBTBase elementNBT : (NBTTagList) tag2) {
            long element = ((NBTTagLong) elementNBT).getLong();
            arr2[i2++] = element;
        }
        obj.o = arr2;

        // Read field float[] p
        NBTBase tag3 = nbt.getTag("p");
        float[] arr3 = new float[((NBTTagList) tag3).tagCount()];
        int i3 = 0;
        for (NBTBase elementNBT : (NBTTagList) tag3) {
            float element = ((NBTTagFloat) elementNBT).getFloat();
            arr3[i3++] = element;
        }
        obj.p = arr3;

        // Read field double[] q
        NBTBase tag4 = nbt.getTag("q");
        double[] arr4 = new double[((NBTTagList) tag4).tagCount()];
        int i4 = 0;
        for (NBTBase elementNBT : (NBTTagList) tag4) {
            double element = ((NBTTagDouble) elementNBT).getDouble();
            arr4[i4++] = element;
        }
        obj.q = arr4;

        // Read field byte[][] r
        NBTBase tag5 = nbt.getTag("r");
        byte[][] arr5 = (byte[][]) new Object[((NBTTagList) tag5).tagCount()];
        int i5 = 0;
        for (NBTBase elementNBT : (NBTTagList) tag5) {
            byte[] element = ((NBTTagByteArray) elementNBT).getByteArray();
            arr5[i5++] = element;
        }
        obj.r = arr5;

        // Read field int[][] s
        NBTBase tag6 = nbt.getTag("s");
        int[][] arr6 = (int[][]) new Object[((NBTTagList) tag6).tagCount()];
        int i6 = 0;
        for (NBTBase elementNBT : (NBTTagList) tag6) {
            int[] element = ((NBTTagIntArray) elementNBT).getIntArray();
            arr6[i6++] = element;
        }
        obj.s = arr6;

        // Read field java.lang.String str
        obj.str = nbt.getString("str");

        // Read field net.minecraft.util.math.Vec3i vec3i
        if (nbt.hasKey("vec3i")) {
            NBTBase tag7 = nbt.getTag("vec3i");
            net.minecraft.util.math.Vec3i arr7 = new net.minecraft.util.math.Vec3i(((NBTTagCompound) tag7).getInteger("x"), ((NBTTagCompound) tag7).getInteger("y"), ((NBTTagCompound) tag7).getInteger("z"));
            obj.vec3i = arr7;
        }

        // Read field net.minecraft.util.math.BlockPos blockPos
        if (nbt.hasKey("blockPos")) {
            NBTBase tag8 = nbt.getTag("blockPos");
            net.minecraft.util.math.BlockPos arr8 = new net.minecraft.util.math.BlockPos(((NBTTagCompound) tag8).getInteger("x"), ((NBTTagCompound) tag8).getInteger("y"), ((NBTTagCompound) tag8).getInteger("z"));
            obj.blockPos = arr8;
        }

        // Read field org.dimdev.ddutils.Location location
        if (nbt.hasKey("location")) {
            NBTBase tag9 = nbt.getTag("location");
            org.dimdev.ddutils.Location arr9 = new org.dimdev.ddutils.Location(((NBTTagCompound) tag9).getInteger("dim"), ((NBTTagCompound) tag9).getInteger("x"), ((NBTTagCompound) tag9).getInteger("y"), ((NBTTagCompound) tag9).getInteger("z"));
            obj.location = arr9;
        }

        // Read field java.lang.String[] strArr
        NBTBase tag10 = nbt.getTag("strArr");
        java.lang.String[] arr10 = new java.lang.String[((NBTTagList) tag10).tagCount()];
        int i7 = 0;
        for (NBTBase elementNBT : (NBTTagList) tag10) {
            java.lang.String element = ((NBTTagString) elementNBT).getString();
            arr10[i7++] = element;
        }
        obj.strArr = arr10;

        // Read field java.lang.String[][] strArrArr
        NBTBase tag11 = nbt.getTag("strArrArr");
        java.lang.String[][] arr11 = (java.lang.String[][]) new Object[((NBTTagList) tag11).tagCount()];
        int i8 = 0;
        for (NBTBase elementNBT : (NBTTagList) tag11) {
            java.lang.String[] element = new java.lang.String[((NBTTagList) elementNBT).tagCount()];
            int i9 = 0;
            for (NBTBase elementNBT1 : (NBTTagList) elementNBT) {
                java.lang.String element1 = ((NBTTagString) elementNBT1).getString();
                element[i9++] = element1;
            }
            arr11[i8++] = element;
        }
        obj.strArrArr = arr11;

        // Read field org.dimdev.pocketlib.Pocket nbtStorable
        if (nbt.hasKey("nbtStorable")) {
            obj.nbtStorable = new org.dimdev.pocketlib.Pocket();
            obj.nbtStorable.readFromNBT(nbt.getCompoundTag("nbtStorable"));
        }

        // Read field java.util.List<java.lang.Integer> list
        if (nbt.hasKey("list")) {
            NBTBase tag12 = nbt.getTag("list");
            java.util.List<java.lang.Integer> arr12 = new java.util.ArrayList<>();
            for (NBTBase elementNBT : (NBTTagList) tag12) {
                java.lang.Integer element = ((NBTTagInt) elementNBT).getInt();
                arr12.add(element);
            }
            obj.list = arr12;
        }

        // Read field java.util.Map<java.lang.String,java.lang.Integer> map
        if (nbt.hasKey("map")) {
            NBTBase tag13 = nbt.getTag("map");
            java.util.Map<java.lang.String,java.lang.Integer> arr13 = new java.util.HashMap<>();
            for (NBTBase elementNBT : (NBTTagList) tag13) {
                java.lang.String key = ((NBTTagString) ((NBTTagCompound) elementNBT).getTag("key")).getString();
                java.lang.Integer value = ((NBTTagInt) ((NBTTagCompound) elementNBT).getTag("value")).getInt();
                arr13.put(key, value);
            }
            obj.map = arr13;
        }

        // Read field java.util.Map<java.util.Map<java.util.List<java.lang.String>,int[]>,java.util.Map<org.dimdev.pocketlib.Pocket,java.util.List<org.dimdev.pocketlib.Pocket>>> test2
        if (nbt.hasKey("test2")) {
            NBTBase tag14 = nbt.getTag("test2");
            java.util.Map<java.util.Map<java.util.List<java.lang.String>,int[]>,java.util.Map<org.dimdev.pocketlib.Pocket,java.util.List<org.dimdev.pocketlib.Pocket>>> arr14 = new java.util.HashMap<>();
            for (NBTBase elementNBT : (NBTTagList) tag14) {
                java.util.Map<java.util.List<java.lang.String>,int[]> key = new java.util.HashMap<>();
                for (NBTBase elementNBT1 : (NBTTagList) ((NBTTagCompound) elementNBT).getTag("key")) {
                    java.util.List<java.lang.String> key1 = new java.util.ArrayList<>();
                    for (NBTBase elementNBT2 : (NBTTagList) ((NBTTagCompound) elementNBT1).getTag("key")) {
                        java.lang.String element = ((NBTTagString) elementNBT2).getString();
                        key1.add(element);
                    }
                    int[] value = ((NBTTagIntArray) ((NBTTagCompound) elementNBT1).getTag("value")).getIntArray();
                    key.put(key1, value);
                }
                java.util.Map<org.dimdev.pocketlib.Pocket,java.util.List<org.dimdev.pocketlib.Pocket>> value = new java.util.HashMap<>();
                for (NBTBase elementNBT1 : (NBTTagList) ((NBTTagCompound) elementNBT).getTag("value")) {
                    org.dimdev.pocketlib.Pocket key1 = new org.dimdev.pocketlib.Pocket();
                    key1.readFromNBT((NBTTagCompound) ((NBTTagCompound) elementNBT1).getTag("key"));
                    java.util.List<org.dimdev.pocketlib.Pocket> value1 = new java.util.ArrayList<>();
                    for (NBTBase elementNBT2 : (NBTTagList) ((NBTTagCompound) elementNBT1).getTag("value")) {
                        org.dimdev.pocketlib.Pocket element = new org.dimdev.pocketlib.Pocket();
                        element.readFromNBT((NBTTagCompound) elementNBT2);
                        value1.add(element);
                    }
                    value.put(key1, value1);
                }
                arr14.put(key, value);
            }
            obj.test2 = arr14;
        }
    }
}
