package atomicstryker.infernalmobs.common.mods;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;

public class MM_Choke extends MobModifier
{

    private final int RESET_AIR_VALUE = -999;

    public MM_Choke()
    {
        super();
    }

    public MM_Choke(MobModifier next)
    {
        super(next);
    }

    private EntityLivingBase lastTarget;
    private int lastAir;

    @Override
    public String getModName()
    {
        return "Choke";
    }

    @Override
    public boolean onUpdate(EntityLivingBase mob)
    {
        if (!hasSteadyTarget())
        {
            return super.onUpdate(mob);
        }

        if (getMobTarget() != lastTarget)
        {
            lastAir = RESET_AIR_VALUE;
            if (lastTarget != null)
            {
                updateAir();
            }
            lastTarget = getMobTarget();
        }

        if (lastTarget != null)
        {
            if (mob.func_70685_l(lastTarget))
            {
                if (lastAir == RESET_AIR_VALUE)
                {
                    lastAir = lastTarget.func_70086_ai();
                }
                else
                {
                    lastAir = Math.min(lastAir, lastTarget.func_70086_ai());
                }

                if (!(lastTarget instanceof EntityPlayer && ((EntityPlayer) lastTarget).field_71075_bZ.field_75102_a))
                {
                    lastAir--;
                    if (lastAir < -19)
                    {
                        lastAir = 0;
                        lastTarget.func_70097_a(DamageSource.field_76369_e, 2.0F);
                    }

                    updateAir();
                }
            }
        }

        return super.onUpdate(mob);
    }

    @Override
    public float onHurt(EntityLivingBase mob, DamageSource source, float damage)
    {
        if (lastTarget != null && source.func_76346_g() == lastTarget && lastAir != RESET_AIR_VALUE)
        {
            lastAir += 60;
            updateAir();
        }

        return damage;
    }

    @Override
    public boolean onDeath()
    {
        lastAir = RESET_AIR_VALUE;
        if (lastTarget != null)
        {
            updateAir();
            lastTarget = null;
        }
        return false;
    }

    private void updateAir()
    {
        lastTarget.func_70050_g(lastAir);
        if (lastTarget instanceof EntityPlayerMP)
        {
            InfernalMobsCore.instance().sendAirPacket((EntityPlayerMP) lastTarget, lastAir);
            InfernalMobsCore.instance().getModifiedPlayerTimes().put(lastTarget.func_70005_c_(), System.currentTimeMillis());
        }
    }

    @Override
    public void resetModifiedVictim(EntityPlayer victim)
    {
        victim.func_70050_g(RESET_AIR_VALUE);
    }

    @Override
    protected String[] getModNameSuffix()
    {
        return suffix;
    }

    private static String[] suffix = { "ofBreathlessness", "theAnaerobic", "ofDeprivation" };

    @Override
    protected String[] getModNamePrefix()
    {
        return prefix;
    }

    private static String[] prefix = { "Sith Lord", "Dark Lord", "Darth" };

}
