/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.farming.farmers;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.farm.AbstractFarmerJoe;
import crazypants.enderio.api.farm.FarmNotification;
import crazypants.enderio.api.farm.FarmingAction;
import crazypants.enderio.api.farm.IFarmer;
import crazypants.enderio.api.farm.IHarvestResult;
import crazypants.enderio.base.farming.FarmingTool;
import crazypants.enderio.base.farming.farmers.HarvestResult;
import crazypants.enderio.util.Prep;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStem;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;

public class PlantableFarmer
extends AbstractFarmerJoe {
    private Set<Block> harvestExcludes = new HashSet<Block>();

    public void addHarvestExlude(Block block) {
        this.harvestExcludes.add(block);
    }

    @Override
    public boolean canPlant(@Nonnull ItemStack stack) {
        if (Prep.isInvalid(stack)) {
            return false;
        }
        return stack.func_77973_b() instanceof IPlantable;
    }

    @Override
    public boolean prepareBlock(@Nonnull IFarmer farm, @Nonnull BlockPos bc, @Nonnull IBlockState state) {
        ItemStack seedStack = farm.getSeedTypeInSuppliesFor(bc);
        if (Prep.isInvalid(seedStack)) {
            if (!farm.isSlotLocked(bc)) {
                farm.setNotification(FarmNotification.NO_SEEDS);
            }
            return false;
        }
        if (!(seedStack.func_77973_b() instanceof IPlantable)) {
            return false;
        }
        IPlantable plantable = (IPlantable)seedStack.func_77973_b();
        EnumPlantType type = plantable.getPlantType((IBlockAccess)farm.getWorld(), bc);
        if (type == null) {
            return false;
        }
        if (type == EnumPlantType.Nether) {
            Block ground = farm.getBlockState(bc.func_177977_b()).func_177230_c();
            if (ground != Blocks.field_150425_aM) {
                return false;
            }
            return this.plantFromInventory(farm, bc, plantable);
        }
        if (type == EnumPlantType.Crop) {
            farm.tillBlock(bc);
            return this.plantFromInventory(farm, bc, plantable);
        }
        if (type == EnumPlantType.Water) {
            return this.plantFromInventory(farm, bc, plantable);
        }
        return false;
    }

    protected boolean plantFromInventory(@Nonnull IFarmer farm, @Nonnull BlockPos bc, @Nonnull IPlantable plantable) {
        World world = farm.getWorld();
        if (this.canPlant(farm, world, bc, plantable) && Prep.isValid(farm.takeSeedFromSupplies(bc, true)) && this.plant(farm, world, bc, plantable)) {
            farm.takeSeedFromSupplies(bc, false);
            return true;
        }
        return false;
    }

    protected boolean plant(@Nonnull IFarmer farm, @Nonnull World world, @Nonnull BlockPos bc, @Nonnull IPlantable plantable) {
        world.func_180501_a(bc, Blocks.field_150350_a.func_176223_P(), 3);
        IBlockState target = this.getPlant(farm, plantable);
        if (target == null || !farm.checkAction(FarmingAction.PLANT, FarmingTool.HOE)) {
            return false;
        }
        world.func_180501_a(bc, target, 3);
        farm.registerAction(FarmingAction.PLANT, FarmingTool.HOE, target, bc);
        return true;
    }

    protected boolean canPlant(@Nonnull IFarmer farm, @Nonnull World world, @Nonnull BlockPos bc, @Nonnull IPlantable plantable) {
        IBlockState target = this.getPlant(farm, plantable);
        BlockPos groundPos = bc.func_177977_b();
        IBlockState groundBS = world.func_180495_p(groundPos);
        Block ground = groundBS.func_177230_c();
        return target != null && target.func_177230_c().func_176196_c(world, bc) && ground.canSustainPlant(groundBS, (IBlockAccess)world, groundPos, EnumFacing.UP, plantable);
    }

    @Override
    public boolean canHarvest(@Nonnull IFarmer farm, @Nonnull BlockPos bc, @Nonnull IBlockState state) {
        Block block = state.func_177230_c();
        if (!this.harvestExcludes.contains(block) && block instanceof IGrowable && !(block instanceof BlockStem)) {
            return !((IGrowable)block).func_176473_a(farm.getWorld(), bc, state, true);
        }
        return false;
    }

    @Override
    public IHarvestResult harvestBlock(@Nonnull IFarmer farm, final @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        if (!this.canHarvest(farm, pos, state) || !farm.checkAction(FarmingAction.HARVEST, FarmingTool.HOE)) {
            return null;
        }
        if (!farm.hasTool(FarmingTool.HOE)) {
            farm.setNotification(FarmNotification.NO_HOE);
            return null;
        }
        World world = farm.getWorld();
        final HarvestResult res = new HarvestResult(pos);
        FakePlayer fakePlayer = farm.startUsingItem(FarmingTool.HOE);
        int fortune = farm.getLootingValue(FarmingTool.HOE);
        ItemStack removedPlantable = Prep.getEmpty();
        NNList drops = new NNList();
        state.func_177230_c().getDrops((NonNullList)drops, (IBlockAccess)world, pos, state, fortune);
        float chance = ForgeEventFactory.fireBlockHarvesting((List)drops, (World)world, (BlockPos)pos, (IBlockState)state, (int)fortune, (float)1.0f, (boolean)false, (EntityPlayer)fakePlayer);
        farm.registerAction(FarmingAction.HARVEST, FarmingTool.HOE, state, pos);
        for (ItemStack stack : drops) {
            if (stack == null || !Prep.isValid(stack) || !(world.field_73012_v.nextFloat() <= chance)) continue;
            if (Prep.isInvalid(removedPlantable) && this.isPlantableForBlock(farm, stack, state.func_177230_c())) {
                removedPlantable = stack.func_77946_l();
                removedPlantable.func_190920_e(1);
                stack.func_190918_g(1);
            }
            if (!Prep.isValid(stack)) continue;
            res.addDrop(pos, stack.func_77946_l());
        }
        NNList.wrap(farm.endUsingItem(FarmingTool.HOE)).apply((NNList.Callback)new NNList.Callback<ItemStack>(){

            public void apply(@Nonnull ItemStack drop) {
                res.addDrop(pos, drop.func_77946_l());
            }
        });
        if (Prep.isValid(removedPlantable)) {
            if (!this.plant(farm, world, pos, (IPlantable)removedPlantable.func_77973_b())) {
                res.addDrop(pos, removedPlantable.func_77946_l());
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
            }
        } else {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
        return res;
    }

    protected boolean isPlantableForBlock(@Nonnull IFarmer farm, @Nonnull ItemStack stack, @Nonnull Block block) {
        if (!(stack.func_77973_b() instanceof IPlantable)) {
            return false;
        }
        IPlantable plantable = (IPlantable)stack.func_77973_b();
        IBlockState b = this.getPlant(farm, plantable);
        return b != null && b.func_177230_c() == block;
    }

    protected IBlockState getPlant(@Nonnull IFarmer farm, IPlantable plantable) {
        return plantable.getPlant((IBlockAccess)farm.getWorld(), farm.getLocation().func_177981_b(256));
    }
}

