/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.handler.darksteel;

import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.upgrades.IDarkSteelItem;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.base.config.config.DarkSteelConfig;
import crazypants.enderio.base.handler.darksteel.gui.SlotSelector;
import crazypants.enderio.base.handler.darksteel.gui.UpgradeCap;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.material.upgrades.ItemUpgrades;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="enderio")
public class UpgradeRegistry {
    private static IForgeRegistry<IDarkSteelUpgrade> REGISTRY = null;
    @Nonnull
    private static final NNList<IDarkSteelUpgrade> sortedList = new NNList();

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void registerRegistry(@Nonnull RegistryEvent.NewRegistry event) {
        REGISTRY = new RegistryBuilder().setName(new ResourceLocation("enderio", "upgrades")).setType(IDarkSteelUpgrade.class).setIDRange(0, 0x7FFFFFFE).add((owner, stage, id, obj, oldObj) -> sortedList.clear()).add((owner, stage) -> sortedList.clear()).create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static NNList<IDarkSteelUpgrade> getUpgrades() {
        if (sortedList.isEmpty()) {
            NNList<IDarkSteelUpgrade> nNList = sortedList;
            synchronized (nNList) {
                sortedList.clear();
                sortedList.addAll(REGISTRY.getValuesCollection());
                sortedList.sort(UpgradeRegistry::compare);
                Arrays.stream(((String)DarkSteelConfig.disabledUpgrades.get()).split("\\s*[,;]\\s*")).map(s -> s != null ? new ResourceLocation(s) : null).forEach(rl -> sortedList.remove((Object)UpgradeRegistry.getUpgrade(rl)));
            }
        }
        return sortedList;
    }

    protected static int compare(@Nonnull IDarkSteelUpgrade o1, @Nonnull IDarkSteelUpgrade o2) {
        Pair<String, Integer> k1 = o1.getSortKey();
        Pair<String, Integer> k2 = o2.getSortKey();
        return ((String)k1.getLeft() + k1.getRight()).compareTo((String)k2.getLeft() + k2.getRight());
    }

    @Nullable
    public static IDarkSteelUpgrade getUpgrade(ResourceLocation id) {
        return (IDarkSteelUpgrade)REGISTRY.getValue(id);
    }

    public static int getId(IDarkSteelUpgrade upgrade) {
        return ((ForgeRegistry)REGISTRY).getID((IForgeRegistryEntry)upgrade);
    }

    @Nonnull
    public static ItemStack getUpgradeItem(@Nonnull IDarkSteelUpgrade upgrade, boolean enabled) {
        return ItemUpgrades.setEnabled(((ItemUpgrades)ModObject.itemDarkSteelUpgrade.getItemNN()).withUpgrade(upgrade), enabled);
    }

    @Nonnull
    public static ItemStack getUpgradeItem(@Nonnull IDarkSteelUpgrade upgrade) {
        return UpgradeRegistry.getUpgradeItem(upgrade, true);
    }

    public static boolean isUpgradeItem(@Nonnull IDarkSteelUpgrade upgrade, @Nonnull ItemStack stack) {
        return UpgradeRegistry.isUpgradeItem(upgrade, stack, true);
    }

    public static boolean isUpgradeItem(@Nonnull IDarkSteelUpgrade upgrade, @Nonnull ItemStack stack, Boolean enabled) {
        return stack.func_190916_E() == 1 && stack.func_77973_b() == ModObject.itemDarkSteelUpgrade.getItemNN() && ItemUpgrades.getUpgrade(stack) == upgrade && (enabled == null || ItemUpgrades.isEnabled(stack) == enabled);
    }

    @Nullable
    public static IDarkSteelUpgrade getUpgradeFromItem(@Nonnull ItemStack stack) {
        if (stack.func_190916_E() == 1 && stack.func_77973_b() == ModObject.itemDarkSteelUpgrade.getItemNN() && ItemUpgrades.isEnabled(stack)) {
            return ItemUpgrades.getUpgrade(stack);
        }
        return null;
    }

    @Nullable
    public static IDarkSteelUpgrade read(@Nonnull ByteBuf in) {
        return (IDarkSteelUpgrade)ByteBufUtils.readRegistryEntry((ByteBuf)in, REGISTRY);
    }

    @SubscribeEvent
    public static void onItemDesctroyed(PlayerDestroyItemEvent event) {
        EntityPlayer player;
        if (event.getOriginal().func_77973_b() instanceof IDarkSteelItem && (player = event.getEntityPlayer()) != null) {
            if (event.getHand() != null && event.getOriginal().func_77973_b() instanceof ItemArmor && ItemStack.func_77989_b((ItemStack)event.getOriginal(), (ItemStack)player.func_184582_a(EntityLiving.func_184640_d((ItemStack)event.getOriginal())))) {
                return;
            }
            new UpgradeCap(new SlotSelector.RawItem(event.getOriginal()), player, false).dropAll(true);
        }
    }
}

