/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.blocks;

import buildcraft.api.blocks.ICustomPaintHandler;
import buildcraft.api.core.BCDebugging;
import buildcraft.api.core.BCLog;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public enum CustomPaintHelper {
    INSTANCE;

    private static final boolean DEBUG;
    private final Map<Block, List<ICustomPaintHandler>> handlers = Maps.newIdentityHashMap();
    private final List<ICustomPaintHandler> allHandlers = Lists.newArrayList();

    public void registerHandlerForAll(ICustomPaintHandler handler) {
        if (DEBUG) {
            BCLog.logger.info("[api.painting] Adding a paint handler for ALL blocks (" + handler.getClass() + ")");
        }
        this.allHandlers.add(handler);
    }

    public void registerHandlerForAll(Class<? extends Block> blockClass, ICustomPaintHandler handler) {
        for (Block block : Block.field_149771_c) {
            Class<?> foundClass = block.getClass();
            if (!blockClass.isAssignableFrom(foundClass)) continue;
            if (DEBUG) {
                BCLog.logger.info("[api.painting] Found an assignable block " + block.getRegistryName() + " (" + foundClass + ") for " + blockClass);
            }
            this.registerHandlerInternal(block, handler);
        }
    }

    public void registerHandler(Block block, ICustomPaintHandler handler) {
        if (this.registerHandlerInternal(block, handler)) {
            if (DEBUG) {
                BCLog.logger.info("[api.painting] Setting a paint handler for block " + block.getRegistryName() + "(" + handler.getClass() + ")");
            }
        } else if (DEBUG) {
            BCLog.logger.info("[api.painting] Adding another paint handler for block " + block.getRegistryName() + "(" + handler.getClass() + ")");
        }
    }

    private boolean registerHandlerInternal(Block block, ICustomPaintHandler handler) {
        if (!this.handlers.containsKey(block)) {
            ArrayList forBlock = Lists.newArrayList();
            forBlock.add(handler);
            this.handlers.put(block, forBlock);
            return true;
        }
        this.handlers.get(block).add(handler);
        return false;
    }

    public EnumActionResult attemptPaintBlock(World world, BlockPos pos, IBlockState state, Vec3d hitPos, @Nullable EnumFacing hitSide, @Nullable EnumDyeColor paint) {
        Block block = state.func_177230_c();
        if (block instanceof ICustomPaintHandler) {
            return ((ICustomPaintHandler)block).attemptPaint(world, pos, state, hitPos, hitSide, paint);
        }
        List<ICustomPaintHandler> custom = this.handlers.get(block);
        if (custom == null || custom.isEmpty()) {
            return this.defaultAttemptPaint(world, pos, state, hitPos, hitSide, paint);
        }
        for (ICustomPaintHandler handler : custom) {
            EnumActionResult result = handler.attemptPaint(world, pos, state, hitPos, hitSide, paint);
            if (result == EnumActionResult.PASS) continue;
            return result;
        }
        return this.defaultAttemptPaint(world, pos, state, hitPos, hitSide, paint);
    }

    private EnumActionResult defaultAttemptPaint(World world, BlockPos pos, IBlockState state, Vec3d hitPos, EnumFacing hitSide, @Nullable EnumDyeColor paint) {
        for (ICustomPaintHandler handler : this.allHandlers) {
            EnumActionResult result = handler.attemptPaint(world, pos, state, hitPos, hitSide, paint);
            if (result == EnumActionResult.PASS) continue;
            return result;
        }
        if (paint == null) {
            return EnumActionResult.FAIL;
        }
        Block b = state.func_177230_c();
        if (b.recolorBlock(world, pos, hitSide, paint)) {
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    static {
        DEBUG = BCDebugging.shouldDebugLog("api.painting");
    }
}

