/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.statements;

import buildcraft.api.core.render.ISprite;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.core.BCCoreSprites;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.StackUtil;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class StatementParameterRedstoneLevel
implements IStatementParameter {
    public final int level;
    private final int minLevel;
    private final int maxLevel;

    public StatementParameterRedstoneLevel() {
        this(0, 0, 15);
    }

    public StatementParameterRedstoneLevel(int min, int max) {
        this(0, min, max);
    }

    public StatementParameterRedstoneLevel(int def, int min, int max) {
        this.level = def;
        this.minLevel = min;
        this.maxLevel = max;
    }

    public StatementParameterRedstoneLevel(NBTTagCompound nbt) {
        this.level = nbt.func_74771_c("l");
        this.minLevel = nbt.func_74771_c("ml");
        this.maxLevel = nbt.func_74771_c("ma");
    }

    @Override
    public void writeToNbt(NBTTagCompound nbt) {
        nbt.func_74774_a("l", (byte)this.level);
        nbt.func_74774_a("mi", (byte)this.minLevel);
        nbt.func_74774_a("ma", (byte)this.maxLevel);
    }

    @Override
    @Nonnull
    public ItemStack getItemStack() {
        return StackUtil.EMPTY;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ISprite getSprite() {
        return BCCoreSprites.PARAM_REDSTONE_LEVEL[this.level & 0xF];
    }

    @Override
    public IStatementParameter onClick(IStatementContainer source, IStatement stmt, ItemStack stack, StatementMouseClick mouse) {
        int l;
        if (mouse.getButton() == 0) {
            l = this.level + 1 & 0xF;
            while (this.level < this.minLevel || this.level > this.maxLevel) {
                l = this.level + 1 & 0xF;
            }
        } else {
            l = this.level - 1 & 0xF;
            while (this.level < this.minLevel || this.level > this.maxLevel) {
                l = this.level - 1 & 0xF;
            }
        }
        return new StatementParameterRedstoneLevel(l, this.minLevel, this.maxLevel);
    }

    public boolean equals(Object object) {
        if (object instanceof StatementParameterRedstoneLevel) {
            StatementParameterRedstoneLevel param = (StatementParameterRedstoneLevel)object;
            return param.level == this.level;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.level);
    }

    @Override
    public String getDescription() {
        return String.format(LocaleUtil.localize("gate.trigger.redstone.input.level"), this.level);
    }

    @Override
    public String getUniqueTag() {
        return "buildcraft:redstoneLevel";
    }

    @Override
    public IStatementParameter rotateLeft() {
        return this;
    }

    @Override
    public IStatementParameter[] getPossible(IStatementContainer source) {
        IStatementParameter[] possible = new IStatementParameter[this.maxLevel - this.minLevel];
        for (int i = 0; i < this.maxLevel - this.minLevel; ++i) {
            int l = this.minLevel + i;
            possible[i] = this.level == l ? this : new StatementParameterRedstoneLevel(l, this.minLevel, this.maxLevel);
        }
        return possible;
    }
}

