/*
 * Decompiled with CFR 0.152.
 */
package kaptainwutax.memorytester.data;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import kaptainwutax.memorytester.data.DataUnit;
import kaptainwutax.memorytester.thread.ThreadMain;
import org.apache.commons.io.FileUtils;

public class DataConfig {
    public ThreadMain threadInstance;
    public String directory = "";
    public String location = this.directory + "";
    public String defaultConfig = "";
    private ArrayList<DataUnit> entries = new ArrayList();

    public DataConfig(ThreadMain threadInstance, String directory, String location) {
        this.threadInstance = threadInstance;
        this.directory = directory;
        this.location = this.directory + location;
        this.populateFields();
        this.populateConfig();
        this.setDefaultDataToThread();
    }

    public void populateFields() {
    }

    public void populateConfig() {
        for (DataUnit entry : this.entries) {
            this.defaultConfig = this.defaultConfig + entry.getName() + "=" + entry.getDefaultValue() + "\n\n";
        }
    }

    public DataUnit[] getEntries() {
        return this.entries.toArray(new DataUnit[this.entries.size()]);
    }

    public void addEntry(DataUnit data) {
        this.entries.add(data);
    }

    public void configLoadData() {
        FileReader reader = null;
        BufferedWriter writer = null;
        try {
            reader = new FileReader(this.location);
        }
        catch (FileNotFoundException e) {
            try {
                File dir = new File(this.directory);
                dir.mkdir();
                writer = new BufferedWriter(new FileWriter(this.location));
                writer.write(this.defaultConfig);
                writer.flush();
                writer.close();
                reader = new FileReader(this.location);
            }
            catch (IOException e2) {
                this.runUnexpectedLoadingError(this.location);
            }
        }
        this.configParseData(reader);
    }

    private void configParseData(FileReader input) {
        BufferedReader bufReader = new BufferedReader(input);
        Boolean illegalArgument = false;
        String[] data = null;
        for (DataUnit entry : this.entries) {
            try {
                String myLine = null;
                while ((myLine = bufReader.readLine()).startsWith("#") || myLine.isEmpty()) {
                }
                data = myLine.split("=");
            }
            catch (Exception e) {
                this.runEntryError(entry.getName(), this.location);
            }
            if (data[0].trim().equals(entry.getName())) {
                try {
                    switch (entry.getType()) {
                        case "int": {
                            entry.setValue(Integer.parseInt(data[1]));
                            break;
                        }
                        case "bool": {
                            entry.setValue(Boolean.parseBoolean(data[1]));
                            break;
                        }
                        case "string": {
                            entry.setValue(data[1]);
                        }
                    }
                }
                catch (Exception e) {
                    this.runEntryError(entry.getName(), this.location);
                }
                continue;
            }
            this.runEntryError(entry.getName(), this.location);
        }
        try {
            bufReader.close();
        }
        catch (IOException e) {
            this.runUnexpectedLoadingError(this.location);
        }
        this.updateThread();
    }

    public void updateThread() {
    }

    public void setDefaultDataToThread() {
        for (DataUnit entry : this.entries) {
            switch (entry.getType()) {
                case "int": {
                    entry.setValue(Integer.valueOf((Integer)entry.getDefaultValue()));
                    break;
                }
                case "bool": {
                    entry.setValue(Boolean.valueOf((Boolean)entry.getDefaultValue()));
                    break;
                }
                case "string": {
                    entry.setValue((String)entry.getDefaultValue());
                }
            }
        }
        this.updateThread();
    }

    public void resetFile() {
        try {
            File configDir = new File("config/");
            if (!configDir.exists()) {
                configDir.mkdir();
            }
            BufferedWriter writer = null;
            File dir = new File(this.directory);
            dir.mkdir();
            writer = new BufferedWriter(new FileWriter(this.location));
            writer.write(this.defaultConfig);
            writer.flush();
            writer.close();
        }
        catch (IOException e2) {
            this.runUnexpectedResettingError();
        }
    }

    public static void generateResources(ThreadMain threadInstance) {
        try {
            File resourcesFolder = new File("config/MemoryTester/resources/");
            if (!resourcesFolder.exists()) {
                resourcesFolder.mkdir();
            }
            threadInstance.guiErrorCrashInstance.crashInfo.setText("Downloading window icon...");
            threadInstance.guiErrorCrashInstance.frame.update(threadInstance.guiErrorCrashInstance.frame.getGraphics());
            File windowIcon = new File("config/MemoryTester/resources/windowIcon.png");
            FileUtils.copyURLToFile((URL)new URL("https://www.dropbox.com/s/tme7acmeo8hr2qp/windowIcon.png?dl=1"), (File)windowIcon);
            threadInstance.guiErrorCrashInstance.crashInfo.setText("Downloading background image...");
            threadInstance.guiErrorCrashInstance.frame.update(threadInstance.guiErrorCrashInstance.frame.getGraphics());
            File backgroundImage = new File("config/MemoryTester/resources/backgroundImage.png");
            FileUtils.copyURLToFile((URL)new URL("https://www.dropbox.com/s/b8unrnz8ambnsu0/backgroundImage.png?dl=1"), (File)backgroundImage);
            threadInstance.guiErrorCrashInstance.crashInfo.setText("Downloading button icon...");
            threadInstance.guiErrorCrashInstance.frame.update(threadInstance.guiErrorCrashInstance.frame.getGraphics());
            File buttonIcon = new File("config/MemoryTester/resources/buttonIcon.png");
            FileUtils.copyURLToFile((URL)new URL("https://www.dropbox.com/s/u4kzmcquygnkn9f/buttonIcon.png?dl=1"), (File)buttonIcon);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void runUnexpectedLoadingError(String location) {
        this.threadInstance.inGuiErrorCrash("Unexpected error while accessing the data in " + location + ", any other program using the directory?");
    }

    public void runUnexpectedParsingError(String location) {
        this.threadInstance.inGuiErrorCrash("Unknown error trying to generate config in " + location);
    }

    public void runUnexpectedResettingError() {
        this.threadInstance.inGuiErrorCrash("Unexpected error while resetting, please delete the whole directory.");
    }

    public void runEntryError(String name, String location) {
        this.threadInstance.inGuiErrorCrash(name + " entry in " + location);
    }

    public String addTextModifiersTo(String text) {
        return text + " />Font:Yu Gothic UI Light />FontType:normal />FontSize:30 />Color:0, 0, 0, 255";
    }

    public String toString() {
        String string = "DataConfig{";
        for (int i = 0; i < this.entries.size(); ++i) {
            string = i != this.entries.size() - 1 ? string + this.entries.get(i).getName() + ", " : string + this.entries.get(i).getName() + "}";
        }
        string = string + " at " + this.location;
        return string;
    }
}

