/*
 * Decompiled with CFR 0.152.
 */
package kaptainwutax.memorytester.gui;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.net.URI;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import kaptainwutax.memorytester.thread.ThreadMain;

public class GuiForceCrash
extends JFrame {
    private ThreadMain threadInstance;
    public JFrame frame;
    public JLabel crash;
    public JLabel currentAllocation;
    public JLabel recommendedAllocation;
    public JLabel crashInfo;

    public GuiForceCrash(ThreadMain threadInstance) {
        this.threadInstance = threadInstance;
        this.initialize();
    }

    private void initialize() {
        this.frame = new JFrame();
        int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        this.frame.setBounds(0, 0, screenWidth, screenHeight);
        this.frame.setTitle("Memory Tester");
        this.frame.setDefaultCloseOperation(2);
        this.frame.getContentPane().setLayout(null);
        this.frame.setExtendedState(6);
        this.frame.setIconImage(new ImageIcon("config/MemoryTester/" + this.threadInstance.windowIconDirectory).getImage());
        this.frame.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent arg0) {
            }

            @Override
            public void windowClosed(WindowEvent arg0) {
                ((GuiForceCrash)GuiForceCrash.this).threadInstance.shouldGameStart = false;
                GuiForceCrash.this.frame.setEnabled(false);
                GuiForceCrash.this.frame.setVisible(false);
            }

            @Override
            public void windowClosing(WindowEvent arg0) {
            }

            @Override
            public void windowDeactivated(WindowEvent arg0) {
            }

            @Override
            public void windowDeiconified(WindowEvent arg0) {
            }

            @Override
            public void windowIconified(WindowEvent arg0) {
            }

            @Override
            public void windowOpened(WindowEvent arg0) {
            }
        });
        int textWidth = screenWidth;
        int textCenterX = this.frame.getWidth() / 2 - textWidth / 2;
        int textOffsetX = 0;
        int textHeight = 40;
        int textCenterY = this.frame.getHeight() / 2 - textHeight / 2;
        int textOffsetY = -400;
        this.crash = new JLabel("loading...");
        this.crash.setFont(new Font("Yu Gothic UI Light", 0, 30));
        this.crash.setHorizontalAlignment(0);
        this.crash.setBounds(textCenterX + textOffsetX, textCenterY + textOffsetY, textWidth, textHeight);
        this.frame.getContentPane().add(this.crash);
        this.currentAllocation = new JLabel("loading...");
        this.currentAllocation.setFont(new Font("Yu Gothic UI Light", 0, 30));
        this.currentAllocation.setHorizontalAlignment(0);
        this.currentAllocation.setBounds(textCenterX + textOffsetX, textCenterY + textOffsetY + 40, textWidth, textHeight);
        this.frame.getContentPane().add(this.currentAllocation);
        this.recommendedAllocation = new JLabel("loading...");
        this.recommendedAllocation.setFont(new Font("Yu Gothic UI Light", 0, 30));
        this.recommendedAllocation.setHorizontalAlignment(0);
        this.recommendedAllocation.setBounds(textCenterX + textOffsetX, textCenterY + textOffsetY + 80, textWidth, textHeight);
        this.frame.getContentPane().add(this.recommendedAllocation);
        this.crashInfo = new JLabel("loading...");
        this.crashInfo.setFont(new Font("Yu Gothic UI Light", 0, 30));
        this.crashInfo.setHorizontalAlignment(0);
        this.crashInfo.setBounds(textCenterX + textOffsetX, textCenterY + textOffsetY + 140, textWidth, textHeight);
        this.frame.getContentPane().add(this.crashInfo);
        int buttonWidth = 180;
        int buttonCenterX = this.frame.getWidth() / 2 - buttonWidth / 2;
        int buttonOffsetX = 0;
        int buttonHeight = 40;
        JButton redirectButton = null;
        if (this.threadInstance.crashRedirectLink != null && !"null".equals(this.threadInstance.crashRedirectLink)) {
            redirectButton = new JButton("Redirect");
            redirectButton.setEnabled(true);
            redirectButton.setBounds(buttonCenterX + buttonOffsetX, textCenterY + textOffsetY + 200, buttonWidth, buttonHeight);
            String[] color = this.threadInstance.crashRedirectBgColor.split(",");
            redirectButton.setBackground(new Color(Integer.parseInt(color[0].trim()), Integer.parseInt(color[1].trim()), Integer.parseInt(color[2].trim()), Integer.parseInt(color[3].trim())));
            redirectButton.setFocusPainted(false);
            this.frame.getContentPane().add(redirectButton);
        }
        JLabel backgroundImage = new JLabel("BackgroundImage");
        backgroundImage.setIcon(new ImageIcon(this.getScaledImage(new ImageIcon("config/MemoryTester/" + this.threadInstance.crashBackgroundImageDirectory).getImage(), screenWidth, screenHeight)));
        backgroundImage.setBounds(0, 0, screenWidth, screenHeight);
        backgroundImage.setHorizontalAlignment(2);
        backgroundImage.setVerticalAlignment(1);
        this.frame.getContentPane().add(backgroundImage);
        if (redirectButton != null) {
            redirectButton.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent arg0) {
                    Desktop desktop;
                    Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                    if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                        try {
                            desktop.browse(new URI(((GuiForceCrash)GuiForceCrash.this).threadInstance.crashRedirectLink));
                        }
                        catch (Exception e) {
                            System.out.println("Invalid link!");
                        }
                        GuiForceCrash.this.threadInstance.performSleep(100L);
                        ((GuiForceCrash)GuiForceCrash.this).threadInstance.shouldGameStart = false;
                        GuiForceCrash.this.frame.setEnabled(false);
                        GuiForceCrash.this.frame.setVisible(false);
                        GuiForceCrash.this.frame.dispose();
                    }
                }

                @Override
                public void mouseEntered(MouseEvent arg0) {
                }

                @Override
                public void mouseExited(MouseEvent arg0) {
                }

                @Override
                public void mousePressed(MouseEvent arg0) {
                }

                @Override
                public void mouseReleased(MouseEvent arg0) {
                }
            });
        }
    }

    private Image getScaledImage(Image rawImage, int imageWidth, int imageHeight) {
        BufferedImage resizedImage = new BufferedImage(imageWidth, imageHeight, 2);
        Graphics2D graphics = resizedImage.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics.drawImage(rawImage, 0, 0, imageWidth, imageHeight, null);
        graphics.dispose();
        return resizedImage;
    }
}

