/*
 * Decompiled with CFR 0.152.
 */
package kaptainwutax.memorytester.thread;

import java.awt.Color;
import java.awt.Font;
import javax.swing.JLabel;
import kaptainwutax.memorytester.data.DataUnit;
import kaptainwutax.memorytester.gui.GuiErrorCrash;
import kaptainwutax.memorytester.gui.GuiForceCrash;
import kaptainwutax.memorytester.gui.GuiMenu;
import kaptainwutax.memorytester.init.InitData;

public class ThreadMain
extends Thread {
    public GuiMenu guiMenuInstance;
    public GuiForceCrash guiForceCrashInstance;
    public GuiErrorCrash guiErrorCrashInstance;
    public int recommendedMemoryAllocation;
    public boolean useMenuGui;
    public boolean useCrashGui;
    public String windowIconDirectory;
    public String menuHeader;
    public String menuLine1WhenOptimalMemory;
    public String menuLine1WhenNonoptimalMemory;
    public String menuButtonStartText;
    public String menuButtonStartBgColor;
    public String menuButtonQuitText;
    public String menuButtonQuitBgColor;
    public String menuBackgroundImageDirectory;
    public String crashInfoHeader;
    public String crashInfoLine1;
    public String crashInfoLine2;
    public String crashInfoFooter;
    public String crashRedirectLink;
    public String crashRedirectBgColor;
    public String crashBackgroundImageDirectory;
    public boolean hasGameInitialized = false;
    public boolean isInMenu = true;
    public boolean shouldGameStart = true;
    private String threadName = "MemoryTesterThread";
    private long maxMemory;
    private long totalMemory;
    private long freeMemory;

    @Override
    public void run() {
        this.setThreadName(this.threadName);
        this.initialize();
    }

    public void initialize() {
        this.updateMemoryStatistics();
        InitData.initializeConfigs();
        if ((long)this.recommendedMemoryAllocation > this.maxMemory && this.useCrashGui) {
            this.inGuiForceCrashAction();
        }
        while (this.isInMenu && this.useMenuGui) {
            this.inGuiMenuAction();
        }
        this.isInMenu = false;
    }

    private void setThreadName(String name) {
        Thread.currentThread().setName(name);
    }

    private void updateMemoryStatistics() {
        this.maxMemory = Runtime.getRuntime().maxMemory() / 1000000L;
        this.totalMemory = Runtime.getRuntime().totalMemory() / 1000000L;
        this.freeMemory = Runtime.getRuntime().freeMemory() / 1000000L;
    }

    private void inGuiMenuAction() {
        if (this.guiMenuInstance == null) {
            this.guiMenuInstance = new GuiMenu((ThreadMain)Thread.currentThread());
            this.guiMenuInstance.frame.setVisible(true);
        }
        this.updateGuiMenu();
    }

    public void inGuiForceCrashAction() {
        if (this.guiForceCrashInstance == null) {
            this.guiForceCrashInstance = new GuiForceCrash((ThreadMain)Thread.currentThread());
            this.guiForceCrashInstance.frame.setVisible(true);
        }
        this.updateGuiForceCrash();
        while (true) {
            this.performSleep(100L);
        }
    }

    public void inGuiErrorCrash(String errorLocation) {
        if (this.guiErrorCrashInstance == null) {
            this.guiErrorCrashInstance = new GuiErrorCrash((ThreadMain)Thread.currentThread());
            this.guiErrorCrashInstance.frame.setVisible(true);
        }
        this.updateGuiErrorCrash(errorLocation);
        while (true) {
            this.performSleep(100L);
        }
    }

    public void performSleep(long millis) {
        try {
            Thread.currentThread();
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void updateGuiMenu() {
        String[] color;
        this.updateMemoryStatistics();
        this.guiMenuInstance.memoryAllocatedText.setText(this.applyString(this.menuHeader));
        this.applyTextModifiers(this.menuHeader, this.guiMenuInstance.memoryAllocatedText, InitData.dataMenu.menuHeader);
        if ((long)this.recommendedMemoryAllocation > this.maxMemory) {
            this.guiMenuInstance.memoryAllocatedRecommendedText.setText(this.applyString(this.menuLine1WhenNonoptimalMemory));
            this.applyTextModifiers(this.menuLine1WhenNonoptimalMemory, this.guiMenuInstance.memoryAllocatedRecommendedText, InitData.dataMenu.menuLine1WhenNonoptimalMemory);
        } else {
            this.guiMenuInstance.memoryAllocatedRecommendedText.setText(this.applyString(this.menuLine1WhenOptimalMemory));
            this.applyTextModifiers(this.menuLine1WhenOptimalMemory, this.guiMenuInstance.memoryAllocatedRecommendedText, InitData.dataMenu.menuLine1WhenOptimalMemory);
        }
        if (this.guiMenuInstance.startButton != null) {
            this.guiMenuInstance.startButton.setText(this.applyString(this.menuButtonStartText));
            color = this.menuButtonStartBgColor.split(",");
            this.guiMenuInstance.startButton.setBackground(new Color(Integer.parseInt(color[0].trim()), Integer.parseInt(color[1].trim()), Integer.parseInt(color[2].trim()), Integer.parseInt(color[3].trim())));
        }
        if (this.guiMenuInstance.quitButton != null) {
            this.guiMenuInstance.quitButton.setText(this.applyString(this.menuButtonQuitText));
            color = this.menuButtonQuitBgColor.split(",");
            this.guiMenuInstance.quitButton.setBackground(new Color(Integer.parseInt(color[0].trim()), Integer.parseInt(color[1].trim()), Integer.parseInt(color[2].trim()), Integer.parseInt(color[3].trim())));
        }
    }

    private void updateGuiForceCrash() {
        this.guiForceCrashInstance.crash.setText(this.applyString(this.crashInfoHeader));
        this.applyTextModifiers(this.crashInfoHeader, this.guiForceCrashInstance.crash, InitData.dataForceCrash.crashInfoHeader);
        this.guiForceCrashInstance.currentAllocation.setText(this.applyString(this.crashInfoLine1));
        this.applyTextModifiers(this.crashInfoLine1, this.guiForceCrashInstance.currentAllocation, InitData.dataForceCrash.crashInfoline1);
        this.guiForceCrashInstance.recommendedAllocation.setText(this.applyString(this.crashInfoLine2));
        this.applyTextModifiers(this.crashInfoLine2, this.guiForceCrashInstance.recommendedAllocation, InitData.dataForceCrash.crashInfoLine2);
        this.guiForceCrashInstance.crashInfo.setText(this.applyString(this.crashInfoFooter));
        this.applyTextModifiers(this.crashInfoFooter, this.guiForceCrashInstance.crashInfo, InitData.dataForceCrash.crashInfoFooter);
    }

    private void updateGuiErrorCrash(String errorLocation) {
        this.guiErrorCrashInstance.crash.setText("The game was forcibly crashed because of an invalid configuration.");
        this.guiErrorCrashInstance.crashInfo.setText(errorLocation);
    }

    private String applyString(String string) {
        String modifiedString = string;
        modifiedString = modifiedString.replace("[AllocatedMemory]", String.valueOf(this.maxMemory));
        modifiedString = modifiedString.replace("[RecommendedMemory]", String.valueOf(this.recommendedMemoryAllocation));
        modifiedString = modifiedString.replace("[RecommendedMemory-AllocatedMemory]", String.valueOf((long)this.recommendedMemoryAllocation - this.maxMemory));
        return modifiedString.split("/>")[0].trim();
    }

    private void applyTextModifiers(String text, JLabel label, DataUnit entry) {
        try {
            String[] params = text.split("/>");
            String font = params[1].replaceFirst("Font:", "").trim();
            int fontType = 0;
            int fontSize = Integer.parseInt(params[3].replaceFirst("FontSize:", "").trim());
            String[] color = params[4].replaceFirst("Color:", "").trim().split(",");
            switch (params[2].replaceFirst("FontType:", "").trim()) {
                case "bold": {
                    fontType = 1;
                    break;
                }
                case "italic": {
                    fontType = 2;
                }
            }
            label.setFont(new Font(font, fontType, fontSize));
            label.setForeground(new Color(Integer.parseInt(color[0].trim()), Integer.parseInt(color[1].trim()), Integer.parseInt(color[2].trim()), Integer.parseInt(color[3].trim())));
        }
        catch (Exception e) {
            this.guiMenuInstance.frame.setVisible(false);
            this.guiMenuInstance.frame.setEnabled(false);
            this.inGuiErrorCrash("Invalid text modifiers for " + entry.getName() + ".");
        }
    }

    private String applyStringError(String string, String errorLocation) {
        return null;
    }
}

